/*
 * Decompiled with CFR 0.152.
 */
package com.lightbend.lagom.javadsl.api.transport;

import com.lightbend.lagom.javadsl.api.deser.DeserializationException;
import com.lightbend.lagom.javadsl.api.deser.ExceptionMessage;
import com.lightbend.lagom.javadsl.api.deser.SerializationException;
import com.lightbend.lagom.javadsl.api.transport.BadRequest;
import com.lightbend.lagom.javadsl.api.transport.Forbidden;
import com.lightbend.lagom.javadsl.api.transport.NotAcceptable;
import com.lightbend.lagom.javadsl.api.transport.NotFound;
import com.lightbend.lagom.javadsl.api.transport.PayloadTooLarge;
import com.lightbend.lagom.javadsl.api.transport.PolicyViolation;
import com.lightbend.lagom.javadsl.api.transport.TooManyRequests;
import com.lightbend.lagom.javadsl.api.transport.TransportErrorCode;
import com.lightbend.lagom.javadsl.api.transport.Unauthorized;
import com.lightbend.lagom.javadsl.api.transport.UnsupportedMediaType;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;

public class TransportException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private final TransportErrorCode errorCode;
    private final ExceptionMessage exceptionMessage;
    private static final Map<String, BiFunction<TransportErrorCode, ExceptionMessage, TransportException>> BY_NAME_TRANSPORT_EXCEPTIONS;
    private static final Map<TransportErrorCode, BiFunction<TransportErrorCode, ExceptionMessage, TransportException>> BY_CODE_TRANSPORT_EXCEPTIONS;

    protected TransportException(TransportErrorCode transportErrorCode, String string) {
        super(string);
        this.errorCode = transportErrorCode;
        this.exceptionMessage = new ExceptionMessage(this.getClass().getSimpleName(), string);
    }

    protected TransportException(TransportErrorCode transportErrorCode, Throwable throwable) {
        super(throwable.getMessage(), throwable);
        this.errorCode = transportErrorCode;
        this.exceptionMessage = new ExceptionMessage(this.getClass().getSimpleName(), throwable.getMessage());
    }

    public TransportException(TransportErrorCode transportErrorCode, ExceptionMessage exceptionMessage) {
        super(exceptionMessage.detail());
        this.errorCode = transportErrorCode;
        this.exceptionMessage = exceptionMessage;
    }

    public TransportException(TransportErrorCode transportErrorCode, String string, Throwable throwable) {
        super(string, throwable);
        this.errorCode = transportErrorCode;
        this.exceptionMessage = new ExceptionMessage(this.getClass().getSimpleName(), string);
    }

    public static TransportException fromCodeAndMessage(TransportErrorCode transportErrorCode, ExceptionMessage exceptionMessage) {
        BiFunction<TransportErrorCode, ExceptionMessage, TransportException> biFunction = BY_NAME_TRANSPORT_EXCEPTIONS.get(exceptionMessage.name());
        if (biFunction != null) {
            return biFunction.apply(transportErrorCode, exceptionMessage);
        }
        biFunction = BY_CODE_TRANSPORT_EXCEPTIONS.get(transportErrorCode);
        if (biFunction != null) {
            return biFunction.apply(transportErrorCode, exceptionMessage);
        }
        return new TransportException(transportErrorCode, exceptionMessage);
    }

    public TransportErrorCode errorCode() {
        return this.errorCode;
    }

    public ExceptionMessage exceptionMessage() {
        return this.exceptionMessage;
    }

    @Override
    public String toString() {
        return super.toString() + " (" + this.errorCode + ")";
    }

    static {
        HashMap<String, BiFunction<TransportErrorCode, ExceptionMessage, TransportException>> hashMap = new HashMap<String, BiFunction<TransportErrorCode, ExceptionMessage, TransportException>>();
        hashMap.put(DeserializationException.class.getSimpleName(), DeserializationException::new);
        hashMap.put(BadRequest.class.getSimpleName(), BadRequest::new);
        hashMap.put(Unauthorized.class.getSimpleName(), Unauthorized::new);
        hashMap.put(Forbidden.class.getSimpleName(), Forbidden::new);
        hashMap.put(PolicyViolation.class.getSimpleName(), PolicyViolation::new);
        hashMap.put(NotFound.class.getSimpleName(), NotFound::new);
        hashMap.put(NotAcceptable.class.getSimpleName(), NotAcceptable::new);
        hashMap.put(PayloadTooLarge.class.getSimpleName(), PayloadTooLarge::new);
        hashMap.put(SerializationException.class.getSimpleName(), SerializationException::new);
        hashMap.put(UnsupportedMediaType.class.getSimpleName(), UnsupportedMediaType::new);
        hashMap.put(TooManyRequests.class.getSimpleName(), TooManyRequests::new);
        HashMap<TransportErrorCode, BiFunction<TransportErrorCode, ExceptionMessage, TransportException>> hashMap2 = new HashMap<TransportErrorCode, BiFunction<TransportErrorCode, ExceptionMessage, TransportException>>();
        hashMap2.put(DeserializationException.ERROR_CODE, DeserializationException::new);
        hashMap2.put(Forbidden.ERROR_CODE, Forbidden::new);
        hashMap2.put(Unauthorized.ERROR_CODE, Unauthorized::new);
        hashMap2.put(PolicyViolation.ERROR_CODE, PolicyViolation::new);
        hashMap2.put(NotAcceptable.ERROR_CODE, NotAcceptable::new);
        hashMap2.put(PayloadTooLarge.ERROR_CODE, PayloadTooLarge::new);
        hashMap2.put(UnsupportedMediaType.ERROR_CODE, UnsupportedMediaType::new);
        hashMap2.put(TooManyRequests.ERROR_CODE, TooManyRequests::new);
        BY_NAME_TRANSPORT_EXCEPTIONS = Collections.unmodifiableMap(hashMap);
        BY_CODE_TRANSPORT_EXCEPTIONS = Collections.unmodifiableMap(hashMap2);
    }
}

