/*
 * Decompiled with CFR 0.152.
 */
package com.lightbend.lagom.javadsl.client;

import com.lightbend.lagom.internal.client.CircuitBreakers;
import com.lightbend.lagom.internal.client.CircuitBreakersPanelInternal;
import com.lightbend.lagom.internal.client.ConfigExtensions;
import com.lightbend.lagom.internal.javadsl.client.CircuitBreakersPanelImpl;
import com.lightbend.lagom.javadsl.api.Descriptor;
import com.lightbend.lagom.javadsl.client.CircuitBreakersPanel;
import com.lightbend.lagom.javadsl.client.CircuitBreakingServiceLocator;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.pcollections.HashTreePMap;
import org.pcollections.PMap;
import play.Configuration;

@Singleton
public class ConfigurationServiceLocator
extends CircuitBreakingServiceLocator {
    private static final String LAGOM_SERVICES_KEY = "lagom.services";
    private final PMap<String, List<URI>> services;

    @Deprecated
    public ConfigurationServiceLocator(Configuration configuration, CircuitBreakers circuitBreakers) {
        this(configuration.underlying(), new CircuitBreakersPanelImpl((CircuitBreakersPanelInternal)circuitBreakers));
    }

    @Inject
    public ConfigurationServiceLocator(Config config, CircuitBreakersPanel circuitBreakersPanel) {
        super(circuitBreakersPanel);
        HashMap hashMap = new HashMap();
        if (config.hasPath(LAGOM_SERVICES_KEY)) {
            Config config2 = config.getConfig(LAGOM_SERVICES_KEY);
            for (String string : config2.root().keySet()) {
                try {
                    List list = ConfigExtensions.getStringList((Config)config2, (String)string).stream().map(URI::create).collect(Collectors.toList());
                    hashMap.put(string, list);
                }
                catch (ConfigException.WrongType wrongType) {
                    throw new IllegalStateException("Error loading configuration for " + this.getClass().getSimpleName() + ". Expected lagom.services." + string + " to be a String or a List of Strings, but was " + config2.getValue(string).valueType(), wrongType);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new IllegalStateException("Error loading configuration for  " + this.getClass().getSimpleName() + ". Expected lagom.services." + string + " to be a URI, but it failed to parse", illegalArgumentException);
                }
            }
        }
        this.services = HashTreePMap.from(hashMap);
    }

    public CompletionStage<Optional<URI>> locate(String string, Descriptor.Call<?, ?> call) {
        return this.locateAll(string, call).thenApply(list -> list.stream().findFirst());
    }

    public CompletionStage<List<URI>> locateAll(String string, Descriptor.Call<?, ?> call) {
        return CompletableFuture.completedFuture(this.services.getOrDefault((Object)string, Collections.emptyList()));
    }
}

