/*
 * Decompiled with CFR 0.152.
 */
package com.lightbend.lagom.internal.jackson;

import akka.actor.ActorSystem;
import akka.actor.ExtendedActorSystem;
import akka.annotation.InternalApi;
import akka.event.Logging$;
import akka.event.LoggingAdapter;
import akka.serialization.BaseSerializer;
import akka.serialization.SerializerWithStringManifest;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.lightbend.lagom.internal.jackson.JacksonObjectMapperProvider;
import com.lightbend.lagom.internal.jackson.JacksonObjectMapperProvider$;
import com.lightbend.lagom.serialization.CompressedJsonable;
import com.lightbend.lagom.serialization.JacksonJsonMigration;
import com.typesafe.config.Config;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.NotSerializableException;
import java.io.Serializable;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005d!B\r\u001b\u0001y!\u0003\u0002\u0003\u0019\u0001\u0005\u000b\u0007I\u0011\u0001\u001a\t\u0011e\u0002!\u0011!Q\u0001\nMBQA\u000f\u0001\u0005\u0002mBqa\u0010\u0001C\u0002\u0013%\u0001\t\u0003\u0004H\u0001\u0001\u0006I!\u0011\u0005\b\u0011\u0002\u0011\r\u0011\"\u0003J\u0011\u0019\u0011\u0006\u0001)A\u0005\u0015\"91\u000b\u0001b\u0001\n\u0013!\u0006BB.\u0001A\u0003%Q\u000bC\u0004]\u0001\t\u0007I\u0011B/\t\r\u001d\u0004\u0001\u0015!\u0003_\u0011\u001dA\u0007A1A\u0005\u000e%Da\u0001\u001c\u0001!\u0002\u001bQ\u0007bB7\u0001\u0005\u0004%IA\u001c\u0005\b\u0003\u000b\u0001\u0001\u0015!\u0003p\u0011%\t9\u0001\u0001b\u0001\n\u0013\tI\u0001\u0003\u0005\u0002\u0012\u0001\u0001\u000b\u0011BA\u0006\u0011\u001d\t\u0019\u0002\u0001C!\u0003+Aq!!\t\u0001\t\u0003\n\u0019\u0003C\u0004\u00024\u0001!\t%!\u000e\t\u000f\u0005u\u0002\u0001\"\u0003\u0002@!9\u0011q\n\u0001\u0005\u0002\u0005E\u0003bBA+\u0001\u0011\u0005\u0011q\u000b\u0005\b\u00037\u0002A\u0011AA/\u0005UQ\u0015mY6t_:T5o\u001c8TKJL\u0017\r\\5{KJT!a\u0007\u000f\u0002\u000f)\f7m[:p]*\u0011QDH\u0001\tS:$XM\u001d8bY*\u0011q\u0004I\u0001\u0006Y\u0006<w.\u001c\u0006\u0003C\t\n\u0011\u0002\\5hQR\u0014WM\u001c3\u000b\u0003\r\n1aY8n'\r\u0001Q%\f\t\u0003M-j\u0011a\n\u0006\u0003Q%\nQb]3sS\u0006d\u0017N_1uS>t'\"\u0001\u0016\u0002\t\u0005\\7.Y\u0005\u0003Y\u001d\u0012AdU3sS\u0006d\u0017N_3s/&$\bn\u0015;sS:<W*\u00198jM\u0016\u001cH\u000f\u0005\u0002']%\u0011qf\n\u0002\u000f\u0005\u0006\u001cXmU3sS\u0006d\u0017N_3s\u0003\u0019\u0019\u0018p\u001d;f[\u000e\u0001Q#A\u001a\u0011\u0005Q:T\"A\u001b\u000b\u0005YJ\u0013!B1di>\u0014\u0018B\u0001\u001d6\u0005M)\u0005\u0010^3oI\u0016$\u0017i\u0019;peNK8\u000f^3n\u0003\u001d\u0019\u0018p\u001d;f[\u0002\na\u0001P5oSRtDC\u0001\u001f?!\ti\u0004!D\u0001\u001b\u0011\u0015\u00014\u00011\u00014\u0003\rawnZ\u000b\u0002\u0003B\u0011!)R\u0007\u0002\u0007*\u0011A)K\u0001\u0006KZ,g\u000e^\u0005\u0003\r\u000e\u0013a\u0002T8hO&tw-\u00113baR,'/\u0001\u0003m_\u001e\u0004\u0013\u0001B2p]\u001a,\u0012A\u0013\t\u0003\u0017Bk\u0011\u0001\u0014\u0006\u0003\u001b:\u000baaY8oM&<'BA(#\u0003!!\u0018\u0010]3tC\u001a,\u0017BA)M\u0005\u0019\u0019uN\u001c4jO\u0006)1m\u001c8gA\u0005q\u0011n\u001d#fEV<WI\\1cY\u0016$W#A+\u0011\u0005YKV\"A,\u000b\u0003a\u000bQa]2bY\u0006L!AW,\u0003\u000f\t{w\u000e\\3b]\u0006y\u0011n\u001d#fEV<WI\\1cY\u0016$\u0007%\u0001\u0007pE*,7\r^'baB,'/F\u0001_!\tyV-D\u0001a\u0015\t\t'-\u0001\u0005eCR\f'-\u001b8e\u0015\tY2M\u0003\u0002eE\u0005Ia-Y:uKJDX\u000e\\\u0005\u0003M\u0002\u0014Ab\u00142kK\u000e$X*\u00199qKJ\fQb\u001c2kK\u000e$X*\u00199qKJ\u0004\u0013A\u0003\"vM\u001a,'oU5{KV\t!nD\u0001l;\t\u0001\u0002!A\u0006Ck\u001a4WM]*ju\u0016\u0004\u0013AC7jOJ\fG/[8ogV\tq\u000e\u0005\u0003qojlhBA9v!\t\u0011x+D\u0001t\u0015\t!\u0018'\u0001\u0004=e>|GOP\u0005\u0003m^\u000ba\u0001\u0015:fI\u00164\u0017B\u0001=z\u0005\ri\u0015\r\u001d\u0006\u0003m^\u0003\"\u0001]>\n\u0005qL(AB*ue&tw\rE\u0002\u007f\u0003\u0003i\u0011a \u0006\u0003QyI1!a\u0001\u0000\u0005QQ\u0015mY6t_:T5o\u001c8NS\u001e\u0014\u0018\r^5p]\u0006YQ.[4sCRLwN\\:!\u0003I\u0019w.\u001c9sKN\u001cH*\u0019:hKJ$\u0006.\u00198\u0016\u0005\u0005-\u0001c\u0001,\u0002\u000e%\u0019\u0011qB,\u0003\t1{gnZ\u0001\u0014G>l\u0007O]3tg2\u000b'oZ3s)\"\fg\u000eI\u0001\t[\u0006t\u0017NZ3tiR\u0019!0a\u0006\t\u000f\u0005e!\u00031\u0001\u0002\u001c\u0005\u0019qN\u00196\u0011\u0007Y\u000bi\"C\u0002\u0002 ]\u0013a!\u00118z%\u00164\u0017\u0001\u0003;p\u0005&t\u0017M]=\u0015\t\u0005\u0015\u0012\u0011\u0007\t\u0006-\u0006\u001d\u00121F\u0005\u0004\u0003S9&!B!se\u0006L\bc\u0001,\u0002.%\u0019\u0011qF,\u0003\t\tKH/\u001a\u0005\b\u00033\u0019\u0002\u0019AA\u000e\u0003)1'o\\7CS:\f'/\u001f\u000b\u0007\u00037\t9$a\u000f\t\u000f\u0005eB\u00031\u0001\u0002&\u0005)!-\u001f;fg\"1\u00111\u0003\u000bA\u0002i\fQ\u0002]1sg\u0016l\u0015M\\5gKN$H\u0003BA!\u0003\u001b\u0002bAVA\"\u0003\u000fR\u0018bAA#/\n1A+\u001e9mKJ\u00022AVA%\u0013\r\tYe\u0016\u0002\u0004\u0013:$\bBBA\n+\u0001\u0007!0\u0001\u0005d_6\u0004(/Z:t)\u0011\t)#a\u0015\t\u000f\u0005eb\u00031\u0001\u0002&\u0005QA-Z2p[B\u0014Xm]:\u0015\t\u0005\u0015\u0012\u0011\f\u0005\b\u0003s9\u0002\u0019AA\u0013\u0003%I7o\u0012.jaB,G\rF\u0002V\u0003?Bq!!\u000f\u0019\u0001\u0004\t)\u0003")
public class JacksonJsonSerializer
extends SerializerWithStringManifest
implements BaseSerializer {
    private final ExtendedActorSystem system;
    private final LoggingAdapter log;
    private final Config conf;
    private final boolean isDebugEnabled;
    private final ObjectMapper objectMapper;
    private final Map<String, JacksonJsonMigration> migrations;
    private final long compressLargerThan;
    private final int identifier;

    @InternalApi
    public int identifierFromConfig() {
        return BaseSerializer.identifierFromConfig$((BaseSerializer)this);
    }

    public int identifier() {
        return this.identifier;
    }

    public void akka$serialization$BaseSerializer$_setter_$identifier_$eq(int x$1) {
        this.identifier = x$1;
    }

    public ExtendedActorSystem system() {
        return this.system;
    }

    private LoggingAdapter log() {
        return this.log;
    }

    private Config conf() {
        return this.conf;
    }

    private boolean isDebugEnabled() {
        return this.isDebugEnabled;
    }

    private ObjectMapper objectMapper() {
        return this.objectMapper;
    }

    private final int BufferSize() {
        return 4096;
    }

    private Map<String, JacksonJsonMigration> migrations() {
        return this.migrations;
    }

    private long compressLargerThan() {
        return this.compressLargerThan;
    }

    public String manifest(Object obj) {
        String string;
        String className = obj.getClass().getName();
        Option option = this.migrations().get((Object)className);
        if (option instanceof Some) {
            Some some = (Some)option;
            JacksonJsonMigration transformer = (JacksonJsonMigration)some.value();
            string = new StringBuilder(1).append(className).append("#").append(transformer.currentVersion()).toString();
        } else if (None$.MODULE$.equals(option)) {
            string = className;
        } else {
            throw new MatchError((Object)option);
        }
        return string;
    }

    public byte[] toBinary(Object obj) {
        byte[] result;
        block2: {
            long startTime = this.isDebugEnabled() ? System.nanoTime() : 0L;
            byte[] bytes = this.objectMapper().writeValueAsBytes(obj);
            Object object = obj;
            byte[] byArray = object instanceof CompressedJsonable && (long)bytes.length > this.compressLargerThan() ? this.compress(bytes) : bytes;
            result = byArray;
            if (!this.isDebugEnabled()) break block2;
            long durationMicros = (System.nanoTime() - startTime) / 1000L;
            if (bytes.length == result.length) {
                this.log().debug("Serialization of [{}] took [{}] \u00b5s, size [{}] bytes", (Object)obj.getClass().getName(), (Object)BoxesRunTime.boxToLong((long)durationMicros), (Object)BoxesRunTime.boxToInteger((int)result.length));
            } else {
                this.log().debug("Serialization of [{}] took [{}] \u00b5s, compressed size [{}] bytes, uncompressed size [{}] bytes", (Object)obj.getClass().getName(), (Object)BoxesRunTime.boxToLong((long)durationMicros), (Object)BoxesRunTime.boxToInteger((int)result.length), (Object)BoxesRunTime.boxToInteger((int)bytes.length));
            }
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    public Object fromBinary(byte[] bytes, String manifest) {
        startTime = this.isDebugEnabled() != false ? System.nanoTime() : 0L;
        compressed = this.isGZipped(bytes);
        var11_5 = this.parseManifest(manifest);
        if (var11_5 == null) {
            throw new MatchError(var11_5);
        }
        fromVersion = var11_5._1$mcI$sp();
        manifestClassName = (String)var11_5._2();
        var6_8 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)fromVersion), (Object)manifestClassName);
        var10_9 = var6_8;
        fromVersion = var10_9._1$mcI$sp();
        manifestClassName = (String)var10_9._2();
        migration = this.migrations().get((Object)manifestClassName);
        var18_13 = false;
        var19_14 = null;
        var20_15 = migration;
        if (!(var20_15 instanceof Some)) ** GOTO lbl-1000
        var18_13 = true;
        var19_14 = (Some)var20_15;
        transformer = (JacksonJsonMigration)var19_14.value();
        if (fromVersion < transformer.currentVersion()) {
            var5_17 = transformer.transformClassName(fromVersion, manifestClassName);
        } else lbl-1000:
        // 2 sources

        {
            if (var18_13 && fromVersion > (transformer = (JacksonJsonMigration)var19_14.value()).currentVersion()) {
                throw new IllegalStateException(new StringBuilder(61).append("Migration version ").append(transformer.currentVersion()).append(" is ").append("behind version ").append(fromVersion).append(" of deserialized type [").append(manifestClassName).append("]").toString());
            }
            var5_17 = manifestClassName;
        }
        className = var5_17;
        var24_20 = this.system().dynamicAccess().getClassFor(className, ClassTag$.MODULE$.AnyRef());
        if (!(var24_20 instanceof Success)) {
            if (var24_20 instanceof Failure) {
                throw new NotSerializableException(new StringBuilder(48).append("Cannot find manifest class [").append(className).append("] for serializer [").append(this.getClass().getName()).append("].").toString());
            }
            throw new MatchError((Object)var24_20);
        }
        var25_21 = (Success)var24_20;
        var4_23 = clazz = (Class)var25_21.value();
        clazz = var4_23;
        v0 = decompressBytes = compressed != false ? this.decompress(bytes) : bytes;
        if (this.isDebugEnabled()) {
            durationMicros = (System.nanoTime() - startTime) / 1000L;
            if (bytes.length == decompressBytes.length) {
                this.log().debug("Deserialization of [{}] took [{}] \u00b5s, size [{}] bytes", (Object)clazz.getName(), (Object)BoxesRunTime.boxToLong((long)durationMicros), (Object)BoxesRunTime.boxToInteger((int)decompressBytes.length));
            } else {
                this.log().debug("Deserialization of [{}] took [{}] \u00b5s, compressed size [{}] bytes, uncompressed size [{}] bytes", (Object)clazz.getName(), (Object)BoxesRunTime.boxToLong((long)durationMicros), (Object)BoxesRunTime.boxToInteger((int)decompressBytes.length), (Object)BoxesRunTime.boxToInteger((int)bytes.length));
            }
        }
        if ((var30_27 = migration) instanceof Some && fromVersion < (transformer = (JacksonJsonMigration)(var31_28 = (Some)var30_27).value()).currentVersion()) {
            jsonTree = this.objectMapper().readTree(decompressBytes);
            newJsonTree = transformer.transform(fromVersion, jsonTree);
            var3_32 = this.objectMapper().treeToValue((TreeNode)newJsonTree, clazz);
        } else {
            var3_32 = this.objectMapper().readValue(decompressBytes, clazz);
        }
        return var3_32;
    }

    private Tuple2<Object, String> parseManifest(String manifest) {
        int i = manifest.lastIndexOf(35);
        int fromVersion = i == -1 ? 1 : new StringOps(Predef$.MODULE$.augmentString(manifest.substring(i + 1))).toInt();
        String manifestClassName = i == -1 ? manifest : manifest.substring(0, i);
        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)fromVersion), (Object)manifestClassName);
    }

    public byte[] compress(byte[] bytes) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(4096);
        try (GZIPOutputStream zip = new GZIPOutputStream(bos);){
            zip.write(bytes);
        }
        return bos.toByteArray();
    }

    public byte[] decompress(byte[] bytes) {
        GZIPInputStream in = new GZIPInputStream(new ByteArrayInputStream(bytes));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        try {
            this.readChunk$1(in, buffer, out);
        }
        finally {
            in.close();
        }
        return out.toByteArray();
    }

    public boolean isGZipped(byte[] bytes) {
        return bytes != null && bytes.length >= 2 && bytes[0] == (byte)35615 && bytes[1] == (byte)139;
    }

    private final void readChunk$1(GZIPInputStream in$1, byte[] buffer$1, ByteArrayOutputStream out$1) {
        block3: while (true) {
            int n = in$1.read(buffer$1);
            switch (n) {
                case -1: {
                    break block3;
                }
                default: {
                    out$1.write(buffer$1, 0, n);
                    break;
                }
            }
        }
    }

    public JacksonJsonSerializer(ExtendedActorSystem system) {
        this.system = system;
        BaseSerializer.$init$((BaseSerializer)this);
        this.log = Logging$.MODULE$.getLogger((ActorSystem)system, (Object)this.getClass());
        this.conf = system.settings().config().getConfig("lagom.serialization.json");
        this.isDebugEnabled = this.log().isDebugEnabled();
        this.objectMapper = ((JacksonObjectMapperProvider)JacksonObjectMapperProvider$.MODULE$.apply((ActorSystem)system)).objectMapper();
        this.migrations = (Map)((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(this.conf().getConfig("migrations").root().unwrapped()).asScala()).toMap(Predef$.MODULE$.$conforms()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            Object v = tuple2._2();
            JacksonJsonMigration transformer = (JacksonJsonMigration)this.system().dynamicAccess().createInstanceFor(v.toString(), (Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(JacksonJsonMigration.class)).get();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)transformer);
            return tuple22;
        }, package$.MODULE$.breakOut(Map$.MODULE$.canBuildFrom()));
        this.compressLargerThan = Predef$.MODULE$.Long2long(this.conf().getBytes("compress-larger-than"));
    }
}

