/*
 * Decompiled with CFR 0.152.
 */
package com.lightbend.lagom.internal.jackson;

import akka.actor.ActorSystem;
import akka.actor.DynamicAccess;
import akka.actor.ExtendedActorSystem;
import akka.actor.Extension;
import akka.event.LoggingAdapter;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.paramnames.ParameterNamesModule;
import com.lightbend.lagom.internal.jackson.JacksonObjectMapperProvider$;
import com.typesafe.config.Config;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001-<Q!\u0004\b\t\u0002e1Qa\u0007\b\t\u0002qAQAR\u0001\u0005\u0002iCQaW\u0001\u0005BqCQAY\u0001\u0005B\rDQ!Z\u0001\u0005B\u00194Aa\u0007\b\u0001Y!A\u0001G\u0002B\u0001B\u0003%\u0011\u0007\u0003\u00059\r\t\u0005\t\u0015!\u0003:\u0011!adA!A!\u0002\u0013i\u0004\"\u0002$\u0007\t\u00039\u0005bB&\u0007\u0005\u0004%\t\u0001\u0014\u0005\u0007-\u001a\u0001\u000b\u0011B'\u00027)\u000b7m[:p]>\u0013'.Z2u\u001b\u0006\u0004\b/\u001a:Qe>4\u0018\u000eZ3s\u0015\ty\u0001#A\u0004kC\u000e\\7o\u001c8\u000b\u0005E\u0011\u0012\u0001C5oi\u0016\u0014h.\u00197\u000b\u0005M!\u0012!\u00027bO>l'BA\u000b\u0017\u0003%a\u0017n\u001a5uE\u0016tGMC\u0001\u0018\u0003\r\u0019w.\\\u0002\u0001!\tQ\u0012!D\u0001\u000f\u0005mQ\u0015mY6t_:|%M[3di6\u000b\u0007\u000f]3s!J|g/\u001b3feN!\u0011!H\u0012X!\tq\u0012%D\u0001 \u0015\u0005\u0001\u0013!B:dC2\f\u0017B\u0001\u0012 \u0005\u0019\te.\u001f*fMB\u0019A%K\u0016\u000e\u0003\u0015R!AJ\u0014\u0002\u000b\u0005\u001cGo\u001c:\u000b\u0003!\nA!Y6lC&\u0011!&\n\u0002\f\u000bb$XM\\:j_:LE\r\u0005\u0002\u001b\rM\u0019a!H\u0017\u0011\u0005\u0011r\u0013BA\u0018&\u0005%)\u0005\u0010^3og&|g.\u0001\u0004d_:4\u0017n\u001a\t\u0003eYj\u0011a\r\u0006\u0003aQR!!\u000e\f\u0002\u0011QL\b/Z:bM\u0016L!aN\u001a\u0003\r\r{gNZ5h\u00035!\u0017P\\1nS\u000e\f5mY3tgB\u0011AEO\u0005\u0003w\u0015\u0012Q\u0002R=oC6L7-Q2dKN\u001c\u0018a\u00017pOB\u0019aD\u0010!\n\u0005}z\"AB(qi&|g\u000e\u0005\u0002B\t6\t!I\u0003\u0002DO\u0005)QM^3oi&\u0011QI\u0011\u0002\u000f\u0019><w-\u001b8h\u0003\u0012\f\u0007\u000f^3s\u0003\u0019a\u0014N\\5u}Q!1\u0006S%K\u0011\u0015\u0001$\u00021\u00012\u0011\u0015A$\u00021\u0001:\u0011\u0015a$\u00021\u0001>\u00031y'M[3di6\u000b\u0007\u000f]3s+\u0005i\u0005C\u0001(U\u001b\u0005y%B\u0001)R\u0003!!\u0017\r^1cS:$'BA\bS\u0015\t\u0019f#A\u0005gCN$XM\u001d=nY&\u0011Qk\u0014\u0002\r\u001f\nTWm\u0019;NCB\u0004XM]\u0001\u000e_\nTWm\u0019;NCB\u0004XM\u001d\u0011\u0011\u0005\u0011B\u0016BA-&\u0005M)\u0005\u0010^3og&|g.\u00133Qe>4\u0018\u000eZ3s)\u0005I\u0012aA4fiR\u00111&\u0018\u0005\u0006=\u000e\u0001\raX\u0001\u0007gf\u001cH/Z7\u0011\u0005\u0011\u0002\u0017BA1&\u0005-\t5\r^8s'f\u001cH/Z7\u0002\r1|wn[;q)\u0005!gB\u0001\u000e\u0001\u0003=\u0019'/Z1uK\u0016CH/\u001a8tS>tGCA\u0016h\u0011\u0015qV\u00011\u0001i!\t!\u0013.\u0003\u0002kK\t\u0019R\t\u001f;f]\u0012,G-Q2u_J\u001c\u0016p\u001d;f[\u0002")
public class JacksonObjectMapperProvider
implements Extension {
    private final DynamicAccess dynamicAccess;
    private final Option<LoggingAdapter> log;
    private final ObjectMapper objectMapper;

    public static JacksonObjectMapperProvider createExtension(ExtendedActorSystem extendedActorSystem) {
        return JacksonObjectMapperProvider$.MODULE$.createExtension(extendedActorSystem);
    }

    public static JacksonObjectMapperProvider$ lookup() {
        return JacksonObjectMapperProvider$.MODULE$.lookup();
    }

    public static JacksonObjectMapperProvider get(ActorSystem actorSystem) {
        return JacksonObjectMapperProvider$.MODULE$.get(actorSystem);
    }

    public static Extension apply(ActorSystem actorSystem) {
        return JacksonObjectMapperProvider$.MODULE$.apply(actorSystem);
    }

    public ObjectMapper objectMapper() {
        return this.objectMapper;
    }

    public static final /* synthetic */ void $anonfun$objectMapper$3(JacksonObjectMapperProvider $this, ObjectMapper mapper$1, Module module) {
        ObjectMapper objectMapper = module instanceof ParameterNamesModule ? mapper$1.registerModule((Module)new ParameterNamesModule(JsonCreator.Mode.PROPERTIES)) : mapper$1.registerModule(module);
        $this.log.foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            x$2.debug("Registered Jackson module [{}]", (Object)module.getClass().getName());
            return BoxedUnit.UNIT;
        });
    }

    public JacksonObjectMapperProvider(Config config, DynamicAccess dynamicAccess, Option<LoggingAdapter> log) {
        this.dynamicAccess = dynamicAccess;
        this.log = log;
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
        Buffer configuredModules = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(config.getStringList("lagom.serialization.json.jackson-modules")).asScala();
        Seq modules = configuredModules.contains((Object)"*") ? (Seq)JavaConverters$.MODULE$.asScalaBufferConverter(ObjectMapper.findModules((ClassLoader)dynamicAccess.classLoader())).asScala() : (Seq)configuredModules.flatMap((Function1 & Serializable & scala.Serializable)fqcn -> {
            Iterable iterable;
            Try try_ = $this.dynamicAccess.createInstanceFor(fqcn, (scala.collection.immutable.Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(Module.class));
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                Module m = (Module)success.value();
                iterable = Option$.MODULE$.option2Iterable((Option)new Some((Object)m));
            } else if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable e = failure.exception();
                $this.log.foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                    x$1.error(e, new StringBuilder(184).append("Could not load configured Jackson module [").append(fqcn).append("], ").append("please verify classpath dependencies or amend the configuration ").append("[lagom.serialization.json.jackson-modules]. Continuing ").append("without this module.").toString());
                    return BoxedUnit.UNIT;
                });
                iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            } else {
                throw new MatchError((Object)try_);
            }
            return iterable;
        }, Buffer$.MODULE$.canBuildFrom());
        modules.foreach((Function1 & Serializable & scala.Serializable)module -> {
            JacksonObjectMapperProvider.$anonfun$objectMapper$3(this, mapper, module);
            return BoxedUnit.UNIT;
        });
        this.objectMapper = mapper;
    }
}

