/*
 * Copyright (C) 2016-2019 Lightbend Inc. <https://www.lightbend.com>
 */
package com.lightbend.lagom.javadsl.server.status;

import java.time.Instant;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.lightbend.lagom.javadsl.immutable.ImmutableStyle;
import org.immutables.value.Value;

// NOTE: The `CircuitBreakerStatus.java` is generated by Immutables, but since Scaladoc is
// not running the annotation processor we had to embed the generated code.
// Do not edit `CircuitBreakerStatus.java` manually, but re-generate it and copy the
// generated source. Remove the comment @Value.Immutable at this class to
// re-generate.

// @Value.Immutable
@ImmutableStyle
@JsonDeserialize(as = CircuitBreakerStatus.class)
public interface AbstractCircuitBreakerStatus {

  /** Circuit breaker identifier. */
  String getId();

  @Value.Default
  default Instant getTimestamp() {
    return Instant.now();
  }

  /** Circuit breaker state; closed, open, half-open. */
  String getState();

  /** Total number of successful calls. */
  long getTotalSuccessCount();

  /** Total number of failed calls. */
  long getTotalFailureCount();

  /** Latency distribution for Exponentially Decaying Reservoir. Time unit is microseconds. */
  Latency getLatencyMicros();

  /** Total (successful + failed) calls per second for the last minute. */
  double getThroughputOneMinute();

  /** Failed calls per second for the last minute. */
  double getFailedThroughputOneMinute();
}
