/*
 * Decompiled with CFR 0.152.
 */
package com.lightbend.lagom.internal.server.status;

import akka.NotUsed;
import akka.actor.ActorSystem;
import akka.japi.function.Function;
import akka.stream.javadsl.Source;
import com.codahale.metrics.Snapshot;
import com.lightbend.lagom.internal.client.CircuitBreakerMetricsImpl;
import com.lightbend.lagom.internal.client.CircuitBreakerMetricsProviderImpl;
import com.lightbend.lagom.internal.spi.CircuitBreakerMetricsProvider;
import com.lightbend.lagom.javadsl.api.ServiceCall;
import com.lightbend.lagom.javadsl.api.transport.NotFound;
import com.lightbend.lagom.javadsl.server.status.CircuitBreakerStatus;
import com.lightbend.lagom.javadsl.server.status.Latency;
import com.lightbend.lagom.javadsl.server.status.MetricsService;
import java.io.Serializable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import javax.inject.Inject;

public class MetricsServiceImpl
implements MetricsService {
    private final Optional<CircuitBreakerMetricsProviderImpl> provider;

    @Inject
    public MetricsServiceImpl(CircuitBreakerMetricsProvider circuitBreakerMetricsProvider, ActorSystem actorSystem) {
        boolean bl = actorSystem.settings().config().getBoolean("lagom.status-endpoint.enabled");
        this.provider = bl && circuitBreakerMetricsProvider instanceof CircuitBreakerMetricsProviderImpl ? Optional.of((CircuitBreakerMetricsProviderImpl)circuitBreakerMetricsProvider) : Optional.empty();
    }

    @Override
    public ServiceCall<NotUsed, List<CircuitBreakerStatus>> currentCircuitBreakers() {
        return notUsed -> {
            if (!this.provider.isPresent()) {
                throw new NotFound("No metrics");
            }
            return CompletableFuture.completedFuture(this.allCircuitBreakerStatus());
        };
    }

    @Override
    public ServiceCall<NotUsed, Source<List<CircuitBreakerStatus>, ?>> circuitBreakers() {
        return notUsed -> {
            if (!this.provider.isPresent()) {
                throw new NotFound("No metrics");
            }
            Source source = Source.tick((Duration)Duration.ofMillis(100L), (Duration)Duration.ofSeconds(2L), (Object)"tick").map((Function & Serializable)string -> this.allCircuitBreakerStatus());
            return CompletableFuture.completedFuture(source);
        };
    }

    private List<CircuitBreakerStatus> allCircuitBreakerStatus() {
        ArrayList<CircuitBreakerStatus> arrayList = new ArrayList<CircuitBreakerStatus>();
        for (CircuitBreakerMetricsImpl circuitBreakerMetricsImpl : this.provider.get().allMetrics()) {
            try {
                arrayList.add(this.circuitBreakerStatus(circuitBreakerMetricsImpl));
            }
            catch (Exception exception) {}
        }
        return arrayList;
    }

    private CircuitBreakerStatus circuitBreakerStatus(CircuitBreakerMetricsImpl circuitBreakerMetricsImpl) {
        Snapshot snapshot = circuitBreakerMetricsImpl.latency().getSnapshot();
        Latency latency = Latency.builder().median(snapshot.getMedian()).percentile98th(snapshot.get98thPercentile()).percentile99th(snapshot.get99thPercentile()).percentile999th(snapshot.get999thPercentile()).min(snapshot.getMin()).max(snapshot.getMax()).mean(snapshot.getMean()).build();
        return CircuitBreakerStatus.builder().id(circuitBreakerMetricsImpl.breakerId()).state((String)circuitBreakerMetricsImpl.state().getValue()).totalSuccessCount(circuitBreakerMetricsImpl.successCount().getCount()).totalFailureCount(circuitBreakerMetricsImpl.failureCount().getCount()).throughputOneMinute(circuitBreakerMetricsImpl.throughput().getOneMinuteRate()).failedThroughputOneMinute(circuitBreakerMetricsImpl.failureThroughput().getOneMinuteRate()).latencyMicros(latency).build();
    }
}

