/*
 * Decompiled with CFR 0.152.
 */
package com.lightbend.lagom.javadsl.testkit;

import akka.actor.ActorSystem;
import akka.japi.function.Effect;
import akka.japi.function.Procedure;
import com.lightbend.lagom.devmode.ssl.LagomDevModeSSLHolder;
import com.lightbend.lagom.internal.javadsl.api.broker.TopicFactory;
import com.lightbend.lagom.internal.javadsl.cluster.JoinClusterModule;
import com.lightbend.lagom.internal.persistence.testkit.AwaitPersistenceInit$;
import com.lightbend.lagom.internal.persistence.testkit.PersistenceTestConfig$;
import com.lightbend.lagom.internal.testkit.CassandraTestServer$;
import com.lightbend.lagom.internal.testkit.TestServiceLocator;
import com.lightbend.lagom.internal.testkit.TestServiceLocatorPort;
import com.lightbend.lagom.internal.testkit.TestTopicFactory;
import com.lightbend.lagom.internal.testkit.TestkitSslSetup;
import com.lightbend.lagom.internal.testkit.TestkitSslSetup$;
import com.lightbend.lagom.javadsl.api.ServiceLocator;
import com.lightbend.lagom.javadsl.persistence.PersistenceModule;
import com.lightbend.lagom.javadsl.pubsub.PubSubModule;
import com.lightbend.lagom.javadsl.testkit.ServiceTest;
import com.lightbend.lagom.javadsl.testkit.ServiceTest$GuiceBuilderOps$;
import com.lightbend.lagom.spi.persistence.InMemoryOffsetStore;
import com.lightbend.lagom.spi.persistence.OffsetStore;
import java.io.File;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Optional;
import java.util.Properties;
import javax.net.ssl.SSLContext;
import play.Application;
import play.api.Configuration;
import play.api.Configuration$;
import play.api.Mode;
import play.api.Play$;
import play.api.inject.ApplicationLifecycle;
import play.api.inject.Binding;
import play.api.inject.BindingKey;
import play.api.inject.DefaultApplicationLifecycle;
import play.api.inject.package$;
import play.core.server.Server;
import play.core.server.ServerConfig;
import play.core.server.ServerProvider$;
import play.inject.Bindings;
import play.inject.guice.GuiceApplicationBuilder;
import play.inject.guice.GuiceBuilder;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

public final class ServiceTest$ {
    public static final ServiceTest$ MODULE$;
    private final String JdbcPersistenceModule;
    private final String CassandraPersistenceModule;
    private final String KafkaBrokerModule;
    private final String KafkaClientModule;
    private final ServiceTest.Setup defaultSetup;

    static {
        new ServiceTest$();
    }

    private String JdbcPersistenceModule() {
        return this.JdbcPersistenceModule;
    }

    private String CassandraPersistenceModule() {
        return this.CassandraPersistenceModule;
    }

    private String KafkaBrokerModule() {
        return this.KafkaBrokerModule;
    }

    private String KafkaClientModule() {
        return this.KafkaClientModule;
    }

    public ServiceTest.Setup defaultSetup() {
        return this.defaultSetup;
    }

    /*
     * WARNING - void declaration
     */
    public void withServer(ServiceTest.Setup setup, Procedure<ServiceTest.TestServer> block) {
        ServiceTest.TestServer testServer = this.startServer(setup);
        try {
            block.apply((Object)testServer);
            testServer.stop();
            return;
        }
        catch (Throwable throwable) {
            void var3_3;
            var3_3.stop();
            throw throwable;
        }
    }

    public ServiceTest.TestServer startServer(ServiceTest.Setup setup) {
        TestkitSslSetup.Disabled$ disabled$;
        GuiceApplicationBuilder guiceApplicationBuilder;
        Promise port = Promise$.MODULE$.apply();
        TestServiceLocatorPort testServiceLocatorPort = new TestServiceLocatorPort((Future<Object>)port.future());
        String now = DateTimeFormatter.ofPattern("yyMMddHHmmssSSS").format(LocalDateTime.now());
        String testName = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ServiceTest_", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{now}));
        DefaultApplicationLifecycle lifecycle = new DefaultApplicationLifecycle();
        GuiceApplicationBuilder initialBuilder = (GuiceApplicationBuilder)((GuiceBuilder)((GuiceBuilder)((GuiceBuilder)((GuiceBuilder)new GuiceApplicationBuilder().bindings(new Binding[]{package$.MODULE$.bind(ClassTag$.MODULE$.apply(TestServiceLocatorPort.class)).to((Function0)new Serializable(testServiceLocatorPort){
            public static final long serialVersionUID = 0L;
            private final TestServiceLocatorPort testServiceLocatorPort$1;

            public final TestServiceLocatorPort apply() {
                return this.testServiceLocatorPort$1;
            }
            {
                this.testServiceLocatorPort$1 = testServiceLocatorPort$1;
            }
        })})).bindings(new Binding[]{package$.MODULE$.bind(ClassTag$.MODULE$.apply(ServiceLocator.class)).to(TestServiceLocator.class)})).bindings(new Binding[]{package$.MODULE$.bind(ClassTag$.MODULE$.apply(TopicFactory.class)).to(TestTopicFactory.class)})).overrides(new Binding[]{package$.MODULE$.bind(ClassTag$.MODULE$.apply(ApplicationLifecycle.class)).to((Function0)new Serializable(lifecycle){
            public static final long serialVersionUID = 0L;
            private final DefaultApplicationLifecycle lifecycle$1;

            public final DefaultApplicationLifecycle apply() {
                return this.lifecycle$1;
            }
            {
                this.lifecycle$1 = lifecycle$1;
            }
        })})).configure("play.akka.actor-system", (Object)testName);
        if (setup.cassandra()) {
            int cassandraPort = CassandraTestServer$.MODULE$.run(testName, (ApplicationLifecycle)lifecycle);
            guiceApplicationBuilder = ServiceTest$GuiceBuilderOps$.MODULE$.disableModules$extension(this.GuiceBuilderOps((GuiceApplicationBuilder)((GuiceBuilder)initialBuilder.configure(PersistenceTestConfig$.MODULE$.cassandraConfig(testName, cassandraPort))).configure(PersistenceTestConfig$.MODULE$.ClusterConfig())), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.JdbcPersistenceModule(), this.KafkaClientModule(), this.KafkaBrokerModule()}));
        } else {
            guiceApplicationBuilder = setup.jdbc() ? ServiceTest$GuiceBuilderOps$.MODULE$.disableModules$extension(this.GuiceBuilderOps((GuiceApplicationBuilder)((GuiceBuilder)initialBuilder.configure(PersistenceTestConfig$.MODULE$.JdbcConfig())).configure(PersistenceTestConfig$.MODULE$.ClusterConfig())), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.CassandraPersistenceModule(), this.KafkaClientModule(), this.KafkaBrokerModule()})) : (setup.cluster() ? ServiceTest$GuiceBuilderOps$.MODULE$.disableModules$extension(this.GuiceBuilderOps((GuiceApplicationBuilder)((GuiceBuilder)((GuiceBuilder)initialBuilder.configure(PersistenceTestConfig$.MODULE$.ClusterConfig())).disable(new Class[]{PersistenceModule.class})).bindings(new Binding[]{package$.MODULE$.bind(ClassTag$.MODULE$.apply(OffsetStore.class)).to(ClassTag$.MODULE$.apply(InMemoryOffsetStore.class))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.CassandraPersistenceModule(), this.JdbcPersistenceModule(), this.KafkaClientModule(), this.KafkaBrokerModule()})) : ServiceTest$GuiceBuilderOps$.MODULE$.disableModules$extension(this.GuiceBuilderOps((GuiceApplicationBuilder)((GuiceBuilder)((GuiceBuilder)((GuiceBuilder)initialBuilder.configure("akka.actor.provider", (Object)"akka.actor.LocalActorRefProvider")).configure(PersistenceTestConfig$.MODULE$.BasicConfig())).disable(new Class[]{PersistenceModule.class, PubSubModule.class, JoinClusterModule.class})).bindings(new Binding[]{package$.MODULE$.bind(ClassTag$.MODULE$.apply(OffsetStore.class)).to(ClassTag$.MODULE$.apply(InMemoryOffsetStore.class))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.CassandraPersistenceModule(), this.JdbcPersistenceModule(), this.KafkaClientModule(), this.KafkaBrokerModule()})));
        }
        GuiceApplicationBuilder finalBuilder = guiceApplicationBuilder;
        Application application = setup.configureBuilder().apply(finalBuilder).build();
        Play$.MODULE$.start(application.asScala());
        if (setup.ssl()) {
            LagomDevModeSSLHolder sslHolder = new LagomDevModeSSLHolder(application.environment().asScala());
            SSLContext clientSslContext = sslHolder.sslContext();
            disabled$ = TestkitSslSetup$.MODULE$.enabled(sslHolder.keyStoreMetadata(), sslHolder.trustStoreMetadata(), clientSslContext);
        } else {
            disabled$ = TestkitSslSetup.Disabled$.MODULE$;
        }
        TestkitSslSetup.Disabled$ sslSetup = disabled$;
        Properties props = System.getProperties();
        Configuration sslConfig = Configuration$.MODULE$.load(this.getClass().getClassLoader(), props, sslSetup.sslSettings(), true);
        Some x$36 = new Some((Object)BoxesRunTime.boxToInteger((int)0));
        Option x$37 = sslSetup.sslPort();
        Mode x$38 = application.environment().mode().asScala();
        Configuration x$39 = sslConfig;
        File x$40 = application.environment().rootPath();
        String x$41 = "0.0.0.0";
        Properties x$42 = props;
        ServerConfig serverConfig = new ServerConfig(x$40, (Option)x$36, x$37, x$41, x$38, x$42, x$39);
        Server srv = ServerProvider$.MODULE$.defaultServerProvider().createServer(serverConfig, application.asScala());
        int assignedPort = BoxesRunTime.unboxToInt((Object)srv.httpPort().orElse((Function0)new Serializable(srv){
            public static final long serialVersionUID = 0L;
            private final Server srv$1;

            public final Option<Object> apply() {
                return this.srv$1.httpsPort();
            }
            {
                this.srv$1 = srv$1;
            }
        }).get());
        port.success((Object)BoxesRunTime.boxToInteger((int)assignedPort));
        if (setup.cassandra() || setup.jdbc()) {
            ActorSystem system = (ActorSystem)application.injector().instanceOf(ActorSystem.class);
            AwaitPersistenceInit$.MODULE$.awaitPersistenceInit(system);
        }
        Optional<Object> javaSslContext = Optional.ofNullable(sslSetup.clientSslContext().orNull(Predef$.MODULE$.$conforms()));
        return new ServiceTest.TestServer(assignedPort, application, srv, javaSslContext);
    }

    private GuiceApplicationBuilder GuiceBuilderOps(GuiceApplicationBuilder builder) {
        return builder;
    }

    public void eventually(FiniteDuration max, Effect block) {
        this.eventually(max, new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(100)).millis(), block);
    }

    public void eventually(FiniteDuration max, FiniteDuration interval, Effect block) {
        FiniteDuration stop2 = this.now$1().$plus(max);
        this.poll$1((Duration)max.min(interval), interval, block, stop2);
    }

    public <T> BindingKey<T> bind(Class<T> clazz) {
        return Bindings.bind(clazz);
    }

    private final FiniteDuration now$1() {
        return new package.DurationLong(scala.concurrent.duration.package$.MODULE$.DurationLong(System.nanoTime())).nanos();
    }

    private final void poll$1(Duration t, FiniteDuration interval$1, Effect block$1, FiniteDuration stop$1) {
        while (true) {
            boolean failed;
            boolean bl;
            try {
                block$1.apply();
                bl = false;
            }
            catch (Throwable throwable) {
                boolean bl2;
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (option.isEmpty()) {
                    throw throwable;
                }
                Throwable e = (Throwable)option.get();
                if (this.now$1().$plus(t).$greater$eq((Object)stop$1)) {
                    throw e;
                }
                bl = failed = (bl2 = true);
            }
            if (!failed) break;
            Thread.sleep(t.toMillis());
            t = stop$1.$minus(this.now$1()).min(interval$1);
        }
    }

    private ServiceTest$() {
        MODULE$ = this;
        this.JdbcPersistenceModule = "com.lightbend.lagom.javadsl.persistence.jdbc.JdbcPersistenceModule";
        this.CassandraPersistenceModule = "com.lightbend.lagom.javadsl.persistence.cassandra.CassandraPersistenceModule";
        this.KafkaBrokerModule = "com.lightbend.lagom.internal.javadsl.broker.kafka.KafkaBrokerModule";
        this.KafkaClientModule = "com.lightbend.lagom.javadsl.broker.kafka.KafkaClientModule";
        this.defaultSetup = new ServiceTest.SetupImpl();
    }
}

