/*
 * Decompiled with CFR 0.152.
 */
package com.lightbend.lagom.internal.kafka;

import com.lightbend.lagom.internal.kafka.KafkaLocalServer;
import com.lightbend.lagom.internal.util.PropertiesLoader$;
import java.io.File;
import java.io.Serializable;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Comparator;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;

public final class KafkaLocalServer$ {
    public static KafkaLocalServer$ MODULE$;
    private String tempDir;
    private final Logger com$lightbend$lagom$internal$kafka$KafkaLocalServer$$Log;
    private volatile boolean bitmap$0;

    static {
        new KafkaLocalServer$();
    }

    public final int DefaultPort() {
        return 9092;
    }

    public final String DefaultPropertiesFile() {
        return "/kafka-server.properties";
    }

    public final boolean DefaultResetOnStart() {
        return true;
    }

    private final String KafkaDataFolderName() {
        return "kafka_data";
    }

    public Logger com$lightbend$lagom$internal$kafka$KafkaLocalServer$$Log() {
        return this.com$lightbend$lagom$internal$kafka$KafkaLocalServer$$Log;
    }

    private String tempDir$lzycompute() {
        KafkaLocalServer$ kafkaLocalServer$ = this;
        synchronized (kafkaLocalServer$) {
            if (!this.bitmap$0) {
                this.tempDir = System.getProperty("java.io.tmpdir");
                this.bitmap$0 = true;
            }
        }
        return this.tempDir;
    }

    private String tempDir() {
        return !this.bitmap$0 ? this.tempDir$lzycompute() : this.tempDir;
    }

    public KafkaLocalServer apply(boolean cleanOnStart) {
        return this.apply(9092, 2181, "/kafka-server.properties", (Option<String>)new Some((Object)this.tempDir()), cleanOnStart);
    }

    public KafkaLocalServer apply(int kafkaPort, int zookeeperServerPort, String kafkaPropertiesFile, Option<String> targetDir, boolean cleanOnStart) {
        File kafkaDataDir = this.com$lightbend$lagom$internal$kafka$KafkaLocalServer$$dataDirectory(targetDir, "kafka_data");
        this.com$lightbend$lagom$internal$kafka$KafkaLocalServer$$Log().info(new StringBuilder(25).append("Kafka data directory is ").append(kafkaDataDir).append(".").toString());
        Properties kafkaProperties = this.createKafkaProperties(kafkaPropertiesFile, kafkaPort, zookeeperServerPort, kafkaDataDir);
        if (cleanOnStart) {
            this.com$lightbend$lagom$internal$kafka$KafkaLocalServer$$deleteDirectory(kafkaDataDir);
        }
        return new KafkaLocalServer(kafkaProperties, new KafkaLocalServer.ZooKeeperLocalServer(zookeeperServerPort, cleanOnStart, targetDir));
    }

    private Properties createKafkaProperties(String kafkaPropertiesFile, int kafkaPort, int zookeeperServerPort, File dataDir) {
        Properties kafkaProperties = PropertiesLoader$.MODULE$.from(kafkaPropertiesFile);
        kafkaProperties.setProperty("log.dirs", dataDir.getAbsolutePath());
        kafkaProperties.setProperty("listeners", new StringBuilder(13).append("PLAINTEXT://:").append(kafkaPort).toString());
        kafkaProperties.setProperty("zookeeper.connect", new StringBuilder(10).append("localhost:").append(zookeeperServerPort).toString());
        return kafkaProperties;
    }

    public void com$lightbend$lagom$internal$kafka$KafkaLocalServer$$deleteDirectory(File directory) {
        block2: {
            if (!directory.exists()) break block2;
            try {
                Path rootPath = Paths.get(directory.getAbsolutePath(), new String[0]);
                Iterator files = (Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(Files.walk(rootPath, FileVisitOption.FOLLOW_LINKS).sorted(Comparator.reverseOrder()).iterator()).asScala();
                files.foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                    KafkaLocalServer$.$anonfun$deleteDirectory$1(x$1);
                    return BoxedUnit.UNIT;
                });
                this.com$lightbend$lagom$internal$kafka$KafkaLocalServer$$Log().debug(new StringBuilder(9).append("Deleted ").append(directory.getAbsolutePath()).append(".").toString());
            }
            catch (Exception e) {
                this.com$lightbend$lagom$internal$kafka$KafkaLocalServer$$Log().warn(new StringBuilder(28).append("Failed to delete directory ").append(directory.getAbsolutePath()).append(".").toString(), (Throwable)e);
            }
        }
    }

    public File com$lightbend$lagom$internal$kafka$KafkaLocalServer$$dataDirectory(Option<String> baseDirPath, String directoryName) {
        File file;
        LazyRef tempDirMessage$lzy = new LazyRef();
        Option maybeBaseDir = baseDirPath.map((Function1 & Serializable & scala.Serializable)x$1 -> new File((String)x$1)).filter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)f.exists()));
        Option option = maybeBaseDir;
        if (None$.MODULE$.equals(option)) {
            this.com$lightbend$lagom$internal$kafka$KafkaLocalServer$$Log().warn(new StringBuilder(27).append("Directory ").append(baseDirPath).append(" doesn't exist. ").append(this.tempDirMessage$1(tempDirMessage$lzy, directoryName)).append(".").toString());
            file = new File(this.tempDir());
        } else if (option instanceof Some) {
            File file2;
            Some some = (Some)option;
            File directory = (File)some.value();
            if (!directory.isDirectory()) {
                this.com$lightbend$lagom$internal$kafka$KafkaLocalServer$$Log().warn(new StringBuilder(22).append(baseDirPath).append(" is not a directory. ").append(this.tempDirMessage$1(tempDirMessage$lzy, directoryName)).append(".").toString());
                file2 = new File(this.tempDir());
            } else if (!directory.canWrite()) {
                this.com$lightbend$lagom$internal$kafka$KafkaLocalServer$$Log().warn(new StringBuilder(59).append("The application does not have write access to directory ").append(baseDirPath).append(". ").append(this.tempDirMessage$1(tempDirMessage$lzy, directoryName)).append(".").toString());
                file2 = new File(this.tempDir());
            } else {
                file2 = directory;
            }
            file = file2;
        } else {
            throw new MatchError((Object)option);
        }
        File baseDir = file;
        File dataDirectory = new File(baseDir, directoryName);
        if (dataDirectory.exists() && !dataDirectory.isDirectory()) {
            throw new IllegalArgumentException(new StringBuilder(81).append("Cannot use ").append(directoryName).append(" as a directory name because a file with that name already exists in ").append(dataDirectory).append(".").toString());
        }
        return dataDirectory;
    }

    public static final /* synthetic */ void $anonfun$deleteDirectory$1(Path x$1) {
        Files.delete(x$1);
    }

    private final /* synthetic */ String tempDirMessage$lzycompute$1(LazyRef tempDirMessage$lzy$1, String directoryName$1) {
        String string;
        LazyRef lazyRef = tempDirMessage$lzy$1;
        synchronized (lazyRef) {
            string = tempDirMessage$lzy$1.initialized() ? (String)tempDirMessage$lzy$1.value() : (String)tempDirMessage$lzy$1.initialize((Object)new StringBuilder(66).append("Will attempt to create folder ").append(directoryName$1).append(" in the system temporary directory: ").append(this.tempDir()).toString());
        }
        return string;
    }

    private final String tempDirMessage$1(LazyRef tempDirMessage$lzy$1, String directoryName$1) {
        return tempDirMessage$lzy$1.initialized() ? (String)tempDirMessage$lzy$1.value() : this.tempDirMessage$lzycompute$1(tempDirMessage$lzy$1, directoryName$1);
    }

    private KafkaLocalServer$() {
        MODULE$ = this;
        this.com$lightbend$lagom$internal$kafka$KafkaLocalServer$$Log = LoggerFactory.getLogger(KafkaLocalServer.class);
    }
}

