/*
 * Decompiled with CFR 0.152.
 */
package com.lightbend.lagom.internal.persistence.cassandra;

import akka.Done$;
import akka.actor.ActorSystem;
import akka.actor.ExtendedActorSystem;
import akka.event.Logging$;
import akka.persistence.cassandra.CassandraPluginConfig$;
import akka.persistence.cassandra.SessionProvider$;
import akka.persistence.cassandra.package;
import akka.persistence.cassandra.package$;
import akka.persistence.cassandra.session.CassandraSessionSettings;
import akka.persistence.cassandra.session.scaladsl.CassandraSession;
import akka.util.Helpers;
import akka.util.Helpers$;
import com.datastax.driver.core.Session;
import com.google.common.util.concurrent.ListenableFuture;
import com.typesafe.config.Config;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.runtime.BoxesRunTime;

public final class CassandraReadSideSessionProvider$ {
    public static CassandraReadSideSessionProvider$ MODULE$;

    static {
        new CassandraReadSideSessionProvider$();
    }

    public CassandraSession apply(ActorSystem system, CassandraSessionSettings settings, ExecutionContext executionContext) {
        Config cfg = settings.config();
        String replicationStrategy = CassandraPluginConfig$.MODULE$.getReplicationStrategy(cfg.getString("replication-strategy"), cfg.getInt("replication-factor"), (Seq)JavaConverters$.MODULE$.asScalaBufferConverter(cfg.getStringList("data-center-replication-factors")).asScala());
        boolean keyspaceAutoCreate = cfg.getBoolean("keyspace-autocreate");
        String keyspace = (String)Helpers.Requiring$.MODULE$.requiring$extension1(Helpers$.MODULE$.Requiring((Object)cfg.getString("keyspace")), (Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)CassandraReadSideSessionProvider$.$anonfun$apply$1(keyspaceAutoCreate, x$1)), (Function0 & Serializable & scala.Serializable)() -> "'keyspace' configuration must be defined, or use keyspace-autocreate=off");
        String metricsCategory = new StringBuilder(6).append("lagom-").append(system.name()).toString();
        return new CassandraSession(system, SessionProvider$.MODULE$.apply((ExtendedActorSystem)system, settings.config()), settings, executionContext, Logging$.MODULE$.getLogger(system, this.getClass()), metricsCategory, (Function1 & Serializable & scala.Serializable)session -> CassandraReadSideSessionProvider$.init$1(session, executionContext, keyspaceAutoCreate, keyspace, replicationStrategy));
    }

    public static final /* synthetic */ boolean $anonfun$apply$1(boolean keyspaceAutoCreate$1, String x$1) {
        return !keyspaceAutoCreate$1 || new StringOps(Predef$.MODULE$.augmentString(x$1)).$greater((Object)"");
    }

    private static final Future init$1(Session session, ExecutionContext executionContext$1, boolean keyspaceAutoCreate$1, String keyspace$1, String replicationStrategy$1) {
        Future future;
        ExecutionContext ec = executionContext$1;
        if (keyspaceAutoCreate$1) {
            Future result1 = package.ListenableFutureConverter$.MODULE$.asScala$extension(package$.MODULE$.ListenableFutureConverter((ListenableFuture)session.executeAsync(new StringBuilder(102).append("\n            CREATE KEYSPACE IF NOT EXISTS ").append(keyspace$1).append("\n            WITH REPLICATION = { 'class' : ").append(replicationStrategy$1).append(" }\n            ").toString())), ec);
            future = result1.flatMap((Function1 & Serializable & scala.Serializable)x$2 -> package.ListenableFutureConverter$.MODULE$.asScala$extension(package$.MODULE$.ListenableFutureConverter((ListenableFuture)session.executeAsync(new StringBuilder(5).append("USE ").append(keyspace$1).append(";").toString())), ec), ec).map((Function1 & Serializable & scala.Serializable)x$3 -> Done$.MODULE$, ec);
        } else {
            String string = keyspace$1;
            String string2 = "";
            future = (string == null ? string2 != null : !string.equals(string2)) ? package.ListenableFutureConverter$.MODULE$.asScala$extension(package$.MODULE$.ListenableFutureConverter((ListenableFuture)session.executeAsync(new StringBuilder(5).append("USE ").append(keyspace$1).append(";").toString())), ec).map((Function1 & Serializable & scala.Serializable)x$4 -> Done$.MODULE$, ec) : Future$.MODULE$.successful((Object)Done$.MODULE$);
        }
        return future;
    }

    private CassandraReadSideSessionProvider$() {
        MODULE$ = this;
    }
}

