/*
 * Decompiled with CFR 0.152.
 */
package com.lightbend.lagom.internal.persistence.cassandra;

import akka.Done;
import akka.persistence.cassandra.session.scaladsl.CassandraSession;
import akka.persistence.query.NoOffset$;
import akka.persistence.query.Offset;
import akka.persistence.query.Sequence;
import akka.persistence.query.TimeBasedUUID;
import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.Statement;
import com.lightbend.lagom.spi.persistence.OffsetDao;
import scala.MatchError;
import scala.concurrent.Future;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001A4QAC\u0006\u0003#]A\u0001\"\n\u0001\u0003\u0002\u0003\u0006Ia\n\u0005\te\u0001\u0011\t\u0011)A\u0005g!AQ\b\u0001B\u0001B\u0003%a\b\u0003\u0005J\u0001\t\u0005\t\u0015!\u0003?\u0011!Q\u0005A!b\u0001\n\u0003Z\u0005\u0002\u0003*\u0001\u0005\u0003\u0005\u000b\u0011\u0002'\t\u000bM\u0003A\u0011\u0001+\t\u000bq\u0003A\u0011I/\t\u000b)\u0004A\u0011A6\u0003%\r\u000b7o]1oIJ\fwJ\u001a4tKR$\u0015m\u001c\u0006\u0003\u00195\t\u0011bY1tg\u0006tGM]1\u000b\u00059y\u0011a\u00039feNL7\u000f^3oG\u0016T!\u0001E\t\u0002\u0011%tG/\u001a:oC2T!AE\n\u0002\u000b1\fwm\\7\u000b\u0005Q)\u0012!\u00037jO\"$(-\u001a8e\u0015\u00051\u0012aA2p[N\u0019\u0001\u0001\u0007\u0010\u0011\u0005eaR\"\u0001\u000e\u000b\u0003m\tQa]2bY\u0006L!!\b\u000e\u0003\r\u0005s\u0017PU3g!\ty2%D\u0001!\u0015\tq\u0011E\u0003\u0002##\u0005\u00191\u000f]5\n\u0005\u0011\u0002#!C(gMN,G\u000fR1p\u0003\u001d\u0019Xm]:j_:\u001c\u0001\u0001\u0005\u0002)a5\t\u0011F\u0003\u0002+W\u0005A1oY1mC\u0012\u001cHN\u0003\u0002&Y)\u0011A\"\f\u0006\u0003\u001d9R\u0011aL\u0001\u0005C.\\\u0017-\u0003\u00022S\t\u00012)Y:tC:$'/Y*fgNLwN\\\u0001\ngR\fG/Z7f]R\u0004\"\u0001N\u001e\u000e\u0003UR!AN\u001c\u0002\t\r|'/\u001a\u0006\u0003qe\na\u0001\u001a:jm\u0016\u0014(B\u0001\u001e\u0016\u0003!!\u0017\r^1ti\u0006D\u0018B\u0001\u001f6\u0005E\u0001&/\u001a9be\u0016$7\u000b^1uK6,g\u000e^\u0001\u0011KZ,g\u000e\u001e)s_\u000e,7o]8s\u0013\u0012\u0004\"a\u0010$\u000f\u0005\u0001#\u0005CA!\u001b\u001b\u0005\u0011%BA\"'\u0003\u0019a$o\\8u}%\u0011QIG\u0001\u0007!J,G-\u001a4\n\u0005\u001dC%AB*ue&twM\u0003\u0002F5\u0005\u0019A/Y4\u0002\u00191|\u0017\rZ3e\u001f\u001a47/\u001a;\u0016\u00031\u0003\"!\u0014)\u000e\u00039S!aT\u0017\u0002\u000bE,XM]=\n\u0005Es%AB(gMN,G/A\u0007m_\u0006$W\rZ(gMN,G\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\rU;\u0006,\u0017.\\!\t1\u0006!D\u0001\f\u0011\u0015)s\u00011\u0001(\u0011\u0015\u0011t\u00011\u00014\u0011\u0015it\u00011\u0001?\u0011\u0015Iu\u00011\u0001?\u0011\u0015Qu\u00011\u0001M\u0003)\u0019\u0018M^3PM\u001a\u001cX\r\u001e\u000b\u0003=\"\u00042a\u00182e\u001b\u0005\u0001'BA1\u001b\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0003G\u0002\u0014aAR;ukJ,\u0007CA3g\u001b\u0005q\u0013BA4/\u0005\u0011!uN\\3\t\u000b%D\u0001\u0019\u0001'\u0002\r=4gm]3u\u00039\u0011\u0017N\u001c3TCZ,wJ\u001a4tKR$\"\u0001\\8\u0011\u0005Qj\u0017B\u000186\u00059\u0011u.\u001e8e'R\fG/Z7f]RDQ![\u0005A\u00021\u0003")
public final class CassandraOffsetDao
implements OffsetDao {
    private final CassandraSession session;
    private final PreparedStatement statement;
    private final String eventProcessorId;
    private final String tag;
    private final Offset loadedOffset;

    public Offset loadedOffset() {
        return this.loadedOffset;
    }

    public Future<Done> saveOffset(Offset offset) {
        return this.session.executeWrite((Statement)this.bindSaveOffset(offset));
    }

    public BoundStatement bindSaveOffset(Offset offset) {
        BoundStatement boundStatement;
        Offset offset2 = offset;
        if (NoOffset$.MODULE$.equals(offset2)) {
            boundStatement = this.statement.bind(new Object[]{this.eventProcessorId, this.tag, null, null});
        } else if (offset2 instanceof Sequence) {
            Sequence sequence = (Sequence)offset2;
            boundStatement = this.statement.bind(new Object[]{this.eventProcessorId, this.tag, null, sequence.value()});
        } else if (offset2 instanceof TimeBasedUUID) {
            TimeBasedUUID timeBasedUUID = (TimeBasedUUID)offset2;
            boundStatement = this.statement.bind(new Object[]{this.eventProcessorId, this.tag, timeBasedUUID.value(), null});
        } else {
            throw new MatchError((Object)offset2);
        }
        return boundStatement;
    }

    public CassandraOffsetDao(CassandraSession session, PreparedStatement statement, String eventProcessorId, String tag, Offset loadedOffset) {
        this.session = session;
        this.statement = statement;
        this.eventProcessorId = eventProcessorId;
        this.tag = tag;
        this.loadedOffset = loadedOffset;
    }
}

