/*
 * Decompiled with CFR 0.152.
 */
package com.lightbend.lagom.internal.persistence.cassandra;

import akka.Done;
import akka.Done$;
import akka.actor.ActorSystem;
import akka.persistence.cassandra.session.scaladsl.CassandraSession;
import akka.persistence.query.NoOffset$;
import akka.persistence.query.Offset;
import akka.persistence.query.Sequence;
import akka.persistence.query.TimeBasedUUID;
import akka.util.Timeout;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.Row;
import com.lightbend.lagom.internal.persistence.ReadSideConfig;
import com.lightbend.lagom.internal.persistence.cassandra.CassandraOffsetDao;
import com.lightbend.lagom.internal.persistence.cassandra.CassandraReadSideSettings;
import com.lightbend.lagom.internal.persistence.cluster.ClusterStartupTask;
import com.lightbend.lagom.internal.persistence.cluster.ClusterStartupTask$;
import com.lightbend.lagom.spi.persistence.OffsetStore;
import java.io.Serializable;
import java.util.UUID;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001dcA\u0002\b\u0010\u0003\u0003)2\u0004\u0003\u0005*\u0001\t\u0005\t\u0015!\u0003,\u0011!\u0019\u0004A!A!\u0002\u0013!\u0004\u0002C\u001f\u0001\u0005\u0003\u0005\u000b\u0011\u0002 \t\u0011\t\u0003!\u0011!Q\u0001\n\rCQa\u0012\u0001\u0005\u0002!CQA\u0014\u0001\u0005B=Cq\u0001\u001b\u0001C\u0002\u0013\u0005\u0011\u000e\u0003\u0004t\u0001\u0001\u0006IA\u001b\u0005\u0006i\u0002!I!\u001e\u0005\u0006w\u0002!\t\u0002 \u0005\b\u0003O\u0001A\u0011BA\u0015\u0011\u001d\ti\u0003\u0001C\u0005\u0003_Aq!a\u000e\u0001\t#\tID\u0001\u000bDCN\u001c\u0018M\u001c3sC>3gm]3u'R|'/\u001a\u0006\u0003!E\t\u0011bY1tg\u0006tGM]1\u000b\u0005I\u0019\u0012a\u00039feNL7\u000f^3oG\u0016T!\u0001F\u000b\u0002\u0011%tG/\u001a:oC2T!AF\f\u0002\u000b1\fwm\\7\u000b\u0005aI\u0012!\u00037jO\"$(-\u001a8e\u0015\u0005Q\u0012aA2p[N\u0019\u0001\u0001\b\u0012\u0011\u0005u\u0001S\"\u0001\u0010\u000b\u0003}\tQa]2bY\u0006L!!\t\u0010\u0003\r\u0005s\u0017PU3g!\t\u0019s%D\u0001%\u0015\t\u0011RE\u0003\u0002'+\u0005\u00191\u000f]5\n\u0005!\"#aC(gMN,Go\u0015;pe\u0016\faa]=ti\u0016l7\u0001\u0001\t\u0003YEj\u0011!\f\u0006\u0003]=\nQ!Y2u_JT\u0011\u0001M\u0001\u0005C.\\\u0017-\u0003\u00023[\tY\u0011i\u0019;peNK8\u000f^3n\u0003\u001d\u0019Xm]:j_:\u0004\"!N\u001e\u000e\u0003YR!a\u000e\u001d\u0002\u0011M\u001c\u0017\r\\1eg2T!aM\u001d\u000b\u0005AQ$B\u0001\n0\u0013\tadG\u0001\tDCN\u001c\u0018M\u001c3sCN+7o]5p]\u0006I2-Y:tC:$'/\u0019*fC\u0012\u001c\u0016\u000eZ3TKR$\u0018N\\4t!\ty\u0004)D\u0001\u0010\u0013\t\tuBA\rDCN\u001c\u0018M\u001c3sCJ+\u0017\rZ*jI\u0016\u001cV\r\u001e;j]\u001e\u001c\u0018AB2p]\u001aLw\r\u0005\u0002E\u000b6\t\u0011#\u0003\u0002G#\tq!+Z1e'&$WmQ8oM&<\u0017A\u0002\u001fj]&$h\bF\u0003J\u0015.cU\n\u0005\u0002@\u0001!)\u0011&\u0002a\u0001W!)1'\u0002a\u0001i!)Q(\u0002a\u0001}!)!)\u0002a\u0001\u0007\u00069\u0001O]3qCJ,Gc\u0001)ZMB\u0019\u0011\u000b\u0016,\u000e\u0003IS!a\u0015\u0010\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0002V%\n1a)\u001e;ve\u0016\u0004\"aP,\n\u0005a{!AE\"bgN\fg\u000e\u001a:b\u001f\u001a47/\u001a;EC>DQA\u0017\u0004A\u0002m\u000b\u0001#\u001a<f]R\u0004&o\\2fgN|'/\u00133\u0011\u0005q\u001bgBA/b!\tqf$D\u0001`\u0015\t\u0001'&\u0001\u0004=e>|GOP\u0005\u0003Ez\ta\u0001\u0015:fI\u00164\u0017B\u00013f\u0005\u0019\u0019FO]5oO*\u0011!M\b\u0005\u0006O\u001a\u0001\raW\u0001\u0004i\u0006<\u0017aC:uCJ$X\u000f\u001d+bg.,\u0012A\u001b\t\u0004;-l\u0017B\u00017\u001f\u0005\u0019y\u0005\u000f^5p]B\u0011a.]\u0007\u0002_*\u0011\u0001/E\u0001\bG2,8\u000f^3s\u0013\t\u0011xN\u0001\nDYV\u001cH/\u001a:Ti\u0006\u0014H/\u001e9UCN\\\u0017\u0001D:uCJ$X\u000f\u001d+bg.\u0004\u0013aC2sK\u0006$X\rV1cY\u0016$\u0012A\u001e\t\u0004#R;\bC\u0001=z\u001b\u0005y\u0013B\u0001>0\u0005\u0011!uN\\3\u0002\u0013\u0011|\u0007K]3qCJ,G#B?\u0002$\u0005\u0015\u0002cA)U}B1Qd`A\u0002\u0003\u001fI1!!\u0001\u001f\u0005\u0019!V\u000f\u001d7feA!\u0011QAA\u0006\u001b\t\t9AC\u0002\u0002\ni\nQ!];fefLA!!\u0004\u0002\b\t1qJ\u001a4tKR\u0004B!!\u0005\u0002 5\u0011\u00111\u0003\u0006\u0005\u0003+\t9\"\u0001\u0003d_J,'\u0002BA\r\u00037\ta\u0001\u001a:jm\u0016\u0014(bAA\u000f3\u0005AA-\u0019;bgR\f\u00070\u0003\u0003\u0002\"\u0005M!!\u0005)sKB\f'/\u001a3Ti\u0006$X-\\3oi\")!L\u0003a\u00017\")qM\u0003a\u00017\u0006\u0011\u0002O]3qCJ,wK]5uK>3gm]3u+\t\tY\u0003\u0005\u0003R)\u0006=\u0011A\u0003:fC\u0012|eMZ:fiR1\u0011\u0011GA\u001a\u0003k\u0001B!\u0015+\u0002\u0004!)!\f\u0004a\u00017\")q\r\u0004a\u00017\u0006iQ\r\u001f;sC\u000e$xJ\u001a4tKR$B!a\u0001\u0002<!9\u0011QH\u0007A\u0002\u0005}\u0012\u0001C7bs\n,'k\\<\u0011\tuY\u0017\u0011\t\t\u0005\u0003#\t\u0019%\u0003\u0003\u0002F\u0005M!a\u0001*po\u0002")
public abstract class CassandraOffsetStore
implements OffsetStore {
    private final ActorSystem system;
    private final CassandraSession session;
    private final CassandraReadSideSettings cassandraReadSideSettings;
    private final ReadSideConfig config;
    private final Option<ClusterStartupTask> startupTask;

    public Future<CassandraOffsetDao> prepare(String eventProcessorId, String tag) {
        Timeout timeout = new Timeout(this.config.globalPrepareTimeout());
        return this.doPrepare(eventProcessorId, tag).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Offset offset = (Offset)tuple2._1();
            PreparedStatement statement = (PreparedStatement)tuple2._2();
            CassandraOffsetDao cassandraOffsetDao = new CassandraOffsetDao($this.session, statement, eventProcessorId, tag, offset);
            return cassandraOffsetDao;
        }, (ExecutionContext)this.system.dispatcher());
    }

    public Option<ClusterStartupTask> startupTask() {
        return this.startupTask;
    }

    private Future<Done> createTable() {
        return this.session.executeCreateTable(new StringOps(Predef$.MODULE$.augmentString("\n                                  |CREATE TABLE IF NOT EXISTS offsetStore (\n                                  |  eventProcessorId text, tag text, timeUuidOffset timeuuid, sequenceOffset bigint,\n                                  |  PRIMARY KEY (eventProcessorId, tag)\n                                  |)")).stripMargin());
    }

    public Future<Tuple2<Offset, PreparedStatement>> doPrepare(String eventProcessorId, String tag) {
        Timeout timeout = new Timeout(this.config.globalPrepareTimeout());
        return ((Future)this.startupTask().fold((Function0 & Serializable & scala.Serializable)() -> Future$.MODULE$.successful((Object)Done$.MODULE$), (Function1 & Serializable & scala.Serializable)task -> task.askExecute(timeout))).flatMap((Function1 & Serializable & scala.Serializable)_ -> this.readOffset(eventProcessorId, tag).flatMap((Function1 & Serializable & scala.Serializable)offset -> this.prepareWriteOffset().map((Function1 & Serializable & scala.Serializable)statement -> new Tuple2(offset, statement), (ExecutionContext)$this.system.dispatcher()), (ExecutionContext)$this.system.dispatcher()), (ExecutionContext)this.system.dispatcher());
    }

    private Future<PreparedStatement> prepareWriteOffset() {
        return this.session.prepare("INSERT INTO offsetStore (eventProcessorId, tag, timeUuidOffset, sequenceOffset) VALUES (?, ?, ?, ?)").map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.setConsistencyLevel($this.cassandraReadSideSettings.writeConsistency()), (ExecutionContext)this.system.dispatcher());
    }

    private Future<Offset> readOffset(String eventProcessorId, String tag) {
        return this.session.selectOne("SELECT timeUuidOffset, sequenceOffset FROM offsetStore WHERE eventProcessorId = ? AND tag = ?", (Seq)Predef$.MODULE$.wrapRefArray(new Object[]{eventProcessorId, tag})).map((Function1 & Serializable & scala.Serializable)maybeRow -> this.extractOffset((Option<Row>)maybeRow), (ExecutionContext)this.system.dispatcher());
    }

    public Offset extractOffset(Option<Row> maybeRow) {
        NoOffset$ noOffset$;
        Option<Row> option = maybeRow;
        if (option instanceof Some) {
            Some some = (Some)option;
            Row row = (Row)some.value();
            UUID uuid = row.getUUID("timeUuidOffset");
            noOffset$ = uuid != null ? new TimeBasedUUID(uuid) : (row.isNull("sequenceOffset") ? NoOffset$.MODULE$ : new Sequence(row.getLong("sequenceOffset")));
        } else if (None$.MODULE$.equals(option)) {
            noOffset$ = NoOffset$.MODULE$;
        } else {
            throw new MatchError(option);
        }
        return noOffset$;
    }

    public CassandraOffsetStore(ActorSystem system, CassandraSession session, CassandraReadSideSettings cassandraReadSideSettings, ReadSideConfig config) {
        this.system = system;
        this.session = session;
        this.cassandraReadSideSettings = cassandraReadSideSettings;
        this.config = config;
        this.startupTask = cassandraReadSideSettings.autoCreateTables() ? new Some((Object)ClusterStartupTask$.MODULE$.apply(system, "cassandraOffsetStorePrepare", (Function0 & Serializable & scala.Serializable)() -> this.createTable(), config.globalPrepareTimeout(), config.role(), config.minBackoff(), config.maxBackoff(), config.randomBackoffFactor())) : None$.MODULE$;
    }
}

