/*
 * Decompiled with CFR 0.152.
 */
package com.lightbend.lagom.internal.persistence.jdbc;

import akka.Done$;
import akka.actor.CoordinatedShutdown;
import akka.actor.CoordinatedShutdown$;
import com.lightbend.lagom.internal.persistence.jdbc.AsyncExecutorConfig;
import com.lightbend.lagom.internal.persistence.jdbc.AsyncExecutorConfig$;
import com.typesafe.config.Config;
import java.io.Serializable;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import play.api.db.DBApi;
import play.api.db.Database;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Try$;
import slick.jdbc.JdbcBackend;
import slick.jdbc.JdbcBackend$;
import slick.util.AsyncExecutor$;

public final class SlickDbProvider$ {
    public static SlickDbProvider$ MODULE$;

    static {
        new SlickDbProvider$();
    }

    public void buildAndBindSlickDatabases(DBApi dbApi, Config config, CoordinatedShutdown coordinatedShutdown, ExecutionContext executionContext) {
        dbApi.databases().foreach((Function1 & Serializable & scala.Serializable)playDb -> {
            String dbName = playDb.name();
            return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> config.getConfig(new StringBuilder(3).append("db.").append(dbName).toString())).flatMap((Function1 & Serializable & scala.Serializable)dbConfig -> Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> AsyncExecutorConfig$.MODULE$.apply(dbConfig.getConfig("async-executor"))).map((Function1 & Serializable & scala.Serializable)asyncExecConfig -> {
                SlickDbProvider$.$anonfun$buildAndBindSlickDatabases$5(dbConfig, playDb, coordinatedShutdown, executionContext, asyncExecConfig);
                return BoxedUnit.UNIT;
            }));
        });
    }

    public void buildAndBindSlickDatabase(Database playDb, AsyncExecutorConfig asyncExecConfig, String jndiDbName, CoordinatedShutdown coordinatedShutdown, ExecutionContext executionContext) {
        JdbcBackend.DatabaseDef slickDb = this.buildSlickDatabase(playDb.dataSource(), asyncExecConfig);
        this.bindSlickDatabase(jndiDbName, slickDb, coordinatedShutdown, executionContext);
    }

    private JdbcBackend.DatabaseDef buildSlickDatabase(DataSource dataSource, AsyncExecutorConfig asyncExecConfig) {
        String x$1 = "AsyncExecutor.default";
        int x$2 = asyncExecConfig.minConnections();
        int x$3 = asyncExecConfig.numThreads();
        int x$4 = asyncExecConfig.queueSize();
        int x$5 = asyncExecConfig.maxConnections();
        boolean x$6 = asyncExecConfig.registerMbeans();
        Duration x$7 = AsyncExecutor$.MODULE$.apply$default$6();
        return JdbcBackend$.MODULE$.Database().forDataSource(dataSource, Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)asyncExecConfig.maxConnections())), AsyncExecutor$.MODULE$.apply(x$1, x$2, x$3, x$4, x$5, x$7, x$6), JdbcBackend$.MODULE$.Database().forDataSource$default$4());
    }

    private void bindSlickDatabase(String jndiDbName, JdbcBackend.DatabaseDef slickDb, CoordinatedShutdown coordinatedShutdown, ExecutionContext executionContext) {
        InitialContext namingContext = new InitialContext();
        namingContext.bind(jndiDbName, (Object)slickDb);
        coordinatedShutdown.addTask(CoordinatedShutdown$.MODULE$.PhaseServiceUnbind(), "unbind-slick-db-from-JNDI", (Function0 & Serializable & scala.Serializable)() -> {
            namingContext.unbind(jndiDbName);
            return Future$.MODULE$.successful((Object)Done$.MODULE$);
        });
        coordinatedShutdown.addTask(CoordinatedShutdown$.MODULE$.PhaseBeforeActorSystemTerminate(), "shutdown-managed-read-side-slick", (Function0 & Serializable & scala.Serializable)() -> slickDb.shutdown().map((Function1 & Serializable & scala.Serializable)x$1 -> Done$.MODULE$, executionContext));
    }

    public static final /* synthetic */ void $anonfun$buildAndBindSlickDatabases$5(Config dbConfig$1, Database playDb$1, CoordinatedShutdown coordinatedShutdown$1, ExecutionContext executionContext$1, AsyncExecutorConfig asyncExecConfig) {
        String jndiDbName = dbConfig$1.getString("jndiDbName");
        MODULE$.buildAndBindSlickDatabase(playDb$1, asyncExecConfig, jndiDbName, coordinatedShutdown$1, executionContext$1);
    }

    private SlickDbProvider$() {
        MODULE$ = this;
    }
}

