/*
 * Decompiled with CFR 0.152.
 */
package play.core.server;

import akka.actor.ActorRefFactory;
import akka.actor.ActorSystem;
import akka.actor.ActorSystem$;
import akka.stream.ActorMaterializer$;
import akka.stream.Materializer;
import com.typesafe.config.Config;
import java.io.File;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.InetAddress;
import play.api.Application;
import play.api.ApplicationLoader;
import play.api.ApplicationLoader$;
import play.api.Configuration$;
import play.api.Environment;
import play.api.LoggerConfigurator;
import play.api.LoggerConfigurator$;
import play.api.Mode;
import play.api.Play$;
import play.api.PlayException;
import play.api.UnexpectedException;
import play.api.UnexpectedException$;
import play.api.mvc.RequestHeader;
import play.core.ApplicationProvider;
import play.core.BuildLink;
import play.core.Execution$;
import play.core.SourceMapper;
import play.core.server.LagomReloadableDevServerStart$;
import play.core.server.LagomReloadableDevServerStart$$anon$1$;
import play.core.server.RealServerProcess;
import play.core.server.ReloadableServer;
import play.core.server.Server;
import play.core.server.ServerConfig;
import play.core.server.ServerConfig$;
import play.core.server.ServerProvider;
import play.core.server.ServerProvider$;
import play.utils.Colors$;
import play.utils.Threads$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.control.NonFatal$;

public final class LagomReloadableDevServerStart$ {
    public static LagomReloadableDevServerStart$ MODULE$;
    private final long startupWarningThreshold;

    static {
        new LagomReloadableDevServerStart$();
    }

    private long startupWarningThreshold() {
        return this.startupWarningThreshold;
    }

    public ReloadableServer mainDevOnlyHttpsMode(BuildLink buildLink, int httpsPort, String httpAddress) {
        return this.mainDev(buildLink, (Option<Object>)None$.MODULE$, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)httpsPort)), httpAddress);
    }

    public ReloadableServer mainDevHttpMode(BuildLink buildLink, int httpPort) {
        return this.mainDev(buildLink, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)httpPort)), (Option<Object>)None$.MODULE$, "0.0.0.0");
    }

    private ReloadableServer mainDev(BuildLink buildLink, Option<Object> httpPort, Option<Object> httpsPort, String httpAddress) {
        ClassLoader classLoader = this.getClass().getClassLoader();
        return (ReloadableServer)Threads$.MODULE$.withContextClassLoader(classLoader, (Function0 & Serializable & scala.Serializable)() -> {
            Server server;
            try {
                Boolean bl;
                RealServerProcess process = new RealServerProcess((Seq)Seq$.MODULE$.empty());
                File path = buildLink.projectPath();
                Map dirAndDevSettings = ServerConfig$.MODULE$.rootDirConfig(path).$plus$plus((GenTraversableOnce)((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(buildLink.settings()).asScala()).toMap(Predef$.MODULE$.$conforms())).$plus$plus((GenTraversableOnce)((TraversableOnce)httpPort.toList().map((Function1 & Serializable & scala.Serializable)x$1 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"play.server.http.port"), (Object)((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)x$1))).toString()), List$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"play.server.http.address"), (Object)httpAddress)).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"akka.cluster.jmx.multi-mbeans-in-same-jvm"), (Object)"on"));
                String string = System.getProperty("play.debug.classpath");
                String string2 = "true";
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    System.out.println("\n---- Current ClassLoader ----\n");
                    System.out.println(MODULE$.getClass().getClassLoader());
                    System.out.println("\n---- The where is Scala? test ----\n");
                    System.out.println(MODULE$.getClass().getClassLoader().getResource("scala/Predef$.class"));
                }
                long before = System.currentTimeMillis();
                InetAddress address = InetAddress.getLocalHost();
                long after = System.currentTimeMillis();
                if (after - before > MODULE$.startupWarningThreshold()) {
                    Predef$.MODULE$.println((Object)Colors$.MODULE$.red(new StringBuilder(102).append("WARNING: Retrieving local host name ").append(address).append(" took more than ").append(MODULE$.startupWarningThreshold()).append("ms, this can create problems at startup with Lagom").toString()));
                    Predef$.MODULE$.println((Object)Colors$.MODULE$.red("If you are using macOS, see https://thoeni.io/post/macos-sierra-java/ for a potential solution"));
                }
                try {
                    bl = BoxesRunTime.boxToBoolean((boolean)new File(path, "logs/application.log").delete());
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                    if (option.isEmpty()) {
                        throw throwable;
                    }
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    bl = boxedUnit;
                }
                Option option = LoggerConfigurator$.MODULE$.apply(classLoader);
                if (option instanceof Some) {
                    Some some = (Some)option;
                    LoggerConfigurator loggerConfigurator = (LoggerConfigurator)some.value();
                    loggerConfigurator.init(path, (Mode)Mode.Dev$.MODULE$);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (None$.MODULE$.equals(option)) {
                    Predef$.MODULE$.println((Object)"No play.logger.configurator found: logging must be configured entirely by the application.");
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    throw new MatchError((Object)option);
                }
                ApplicationProvider appProvider = new ApplicationProvider(buildLink, path, dirAndDevSettings){
                    private Try<Application> lastState;
                    public final BuildLink buildLink$1;
                    private final File path$1;
                    private final Map dirAndDevSettings$1;

                    public Try<Application> lastState() {
                        return this.lastState;
                    }

                    public void lastState_$eq(Try<Application> x$1) {
                        this.lastState = x$1;
                    }

                    public Option<Application> current() {
                        return this.lastState().toOption();
                    }

                    public synchronized Try<Application> get() {
                        ExecutionContextExecutor ec = Execution$.MODULE$.internalContext();
                        return (Try)Await$.MODULE$.result((Awaitable)Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
                            Success success;
                            Throwable throwable;
                            Option option;
                            Object object = $this.buildLink$1.reload();
                            if (object instanceof Throwable && !(option = NonFatal$.MODULE$.unapply(throwable = (Throwable)object)).isEmpty()) {
                                Throwable t = (Throwable)option.get();
                                success = new Failure(t);
                            } else if (object instanceof ClassLoader) {
                                ClassLoader classLoader = (ClassLoader)object;
                                success = new Success((Object)new Some((Object)classLoader));
                            } else if (object == null) {
                                success = new Success((Object)None$.MODULE$);
                            } else {
                                throw new MatchError(object);
                            }
                            Success reloaded = success;
                            return reloaded.flatMap((Function1 & Serializable & scala.Serializable)maybeClassLoader -> {
                                Option maybeApplication = maybeClassLoader.map((Function1 & Serializable & scala.Serializable)projectClassloader -> {
                                    Try<Application> try_;
                                    try {
                                        if (this.lastState().isSuccess()) {
                                            Predef$.MODULE$.println();
                                            Predef$.MODULE$.println((Object)Colors$.MODULE$.magenta("--- (RELOAD) ---"));
                                            Predef$.MODULE$.println();
                                        }
                                        this.lastState().foreach((Function1 & Serializable & scala.Serializable)app -> {
                                            anon.1.$anonfun$get$4(app);
                                            return BoxedUnit.UNIT;
                                        });
                                        Environment environment = new Environment($this.path$1, projectClassloader, (Mode)Mode.Dev$.MODULE$);
                                        SourceMapper sourceMapper = new SourceMapper(this){
                                            private final /* synthetic */ anon.1 $outer;

                                            public Option<Object> sourceOf$default$2() {
                                                return SourceMapper.sourceOf$default$2$((SourceMapper)this);
                                            }

                                            public Option<Tuple2<File, Option<Object>>> sourceFor(Throwable e) {
                                                return SourceMapper.sourceFor$((SourceMapper)this, (Throwable)e);
                                            }

                                            public Option<Tuple2<File, Option<Object>>> sourceOf(String className, Option<Object> line) {
                                                return Option$.MODULE$.apply((Object)this.$outer.buildLink$1.findSource(className, (Integer)line.map((Function1 & Serializable & scala.Serializable)x$2 -> anon$1$$anon$2.$anonfun$sourceOf$1(BoxesRunTime.unboxToInt((Object)x$2))).orNull(Predef$.MODULE$.$conforms()))).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                                                    Option option;
                                                    Object[] objectArray = x0$1;
                                                    Option option2 = Array$.MODULE$.unapplySeq((Object)objectArray);
                                                    if (!option2.isEmpty() && option2.get() != null && ((SeqLike)option2.get()).lengthCompare(2) == 0) {
                                                        Object file = ((SeqLike)option2.get()).apply(0);
                                                        Object object = ((SeqLike)option2.get()).apply(1);
                                                        if (file instanceof File) {
                                                            File file2 = (File)file;
                                                            if (object == null) return new Some((Object)new Tuple2((Object)file2, (Object)None$.MODULE$));
                                                        }
                                                    }
                                                    if ((option = Array$.MODULE$.unapplySeq((Object)objectArray)).isEmpty()) return None$.MODULE$;
                                                    if (option.get() == null) return None$.MODULE$;
                                                    if (((SeqLike)option.get()).lengthCompare(2) != 0) return None$.MODULE$;
                                                    Object file = ((SeqLike)option.get()).apply(0);
                                                    Object line = ((SeqLike)option.get()).apply(1);
                                                    if (!(file instanceof File)) return None$.MODULE$;
                                                    File file3 = (File)file;
                                                    if (!(line instanceof Integer)) return None$.MODULE$;
                                                    Integer n = (Integer)line;
                                                    return new Some((Object)new Tuple2((Object)file3, (Object)new Some((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(n)))));
                                                });
                                            }

                                            public static final /* synthetic */ Integer $anonfun$sourceOf$1(int x$2) {
                                                return BoxesRunTime.boxToInteger((int)x$2);
                                            }
                                            {
                                                if ($outer == null) {
                                                    throw null;
                                                }
                                                this.$outer = $outer;
                                                SourceMapper.$init$((SourceMapper)this);
                                            }

                                            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                                                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$sourceOf$1$adapted(java.lang.Object ), $anonfun$sourceOf$2(java.lang.Object[] )}, serializedLambda);
                                            }
                                        };
                                        Application newApplication = (Application)Threads$.MODULE$.withContextClassLoader(projectClassloader, (Function0 & Serializable & scala.Serializable)() -> {
                                            ApplicationLoader.Context context = ApplicationLoader$.MODULE$.createContext(environment, $this.dirAndDevSettings$1, (Option)new Some((Object)sourceMapper), ApplicationLoader$.MODULE$.createContext$default$4(), ApplicationLoader$.MODULE$.createContext$default$5());
                                            ApplicationLoader loader = ApplicationLoader$.MODULE$.apply(context);
                                            return loader.load(context);
                                        });
                                        Play$.MODULE$.start(newApplication);
                                        try_ = new Try<Application>((Object)newApplication);
                                    }
                                    catch (Throwable throwable) {
                                        Try<Application> try_2;
                                        Throwable throwable2 = throwable;
                                        String string = throwable2.getClass().getName();
                                        String string2 = "com.google.inject.CreationException";
                                        if (!(string == null ? string2 != null : !string.equals(string2))) {
                                            this.lastState_$eq((Try<Application>)new Failure(throwable2));
                                            String hint = "Hint: Maybe you have forgot to enable your service Module class via `play.modules.enabled`? (check in your project's application.conf)";
                                            this.logExceptionAndGetResult($this.path$1, throwable2, hint);
                                            try_2 = this.lastState();
                                        } else if (throwable2 instanceof PlayException) {
                                            PlayException playException = (PlayException)throwable2;
                                            this.lastState_$eq((Try<Application>)new Failure((Throwable)playException));
                                            this.logExceptionAndGetResult($this.path$1, (Throwable)playException, this.logExceptionAndGetResult$default$3());
                                            try_2 = this.lastState();
                                        } else {
                                            Option option = NonFatal$.MODULE$.unapply(throwable2);
                                            if (!option.isEmpty()) {
                                                Throwable e = (Throwable)option.get();
                                                Some x$1 = new Some((Object)e);
                                                Option x$2 = UnexpectedException$.MODULE$.apply$default$1();
                                                this.lastState_$eq((Try<Application>)new Failure((Throwable)new UnexpectedException(x$2, (Option)x$1)));
                                                this.logExceptionAndGetResult($this.path$1, e, this.logExceptionAndGetResult$default$3());
                                                try_2 = this.lastState();
                                            } else if (throwable2 instanceof LinkageError) {
                                                LinkageError linkageError = (LinkageError)throwable2;
                                                Some x$3 = new Some((Object)linkageError);
                                                Option x$4 = UnexpectedException$.MODULE$.apply$default$1();
                                                this.lastState_$eq((Try<Application>)new Failure((Throwable)new UnexpectedException(x$4, (Option)x$3)));
                                                this.logExceptionAndGetResult($this.path$1, linkageError, this.logExceptionAndGetResult$default$3());
                                                try_2 = this.lastState();
                                            } else {
                                                throw throwable;
                                            }
                                        }
                                        try_ = try_2;
                                    }
                                    return try_;
                                });
                                maybeApplication.flatMap((Function1 & Serializable & scala.Serializable)x$3 -> x$3.toOption()).foreach((Function1 & Serializable & scala.Serializable)app -> {
                                    anon.1.$anonfun$get$7(this, app);
                                    return BoxedUnit.UNIT;
                                });
                                return (Try)maybeApplication.getOrElse((Function0 & Serializable & scala.Serializable)() -> this.lastState());
                            });
                        }, (ExecutionContext)ec), (Duration)Duration$.MODULE$.Inf());
                    }

                    private void logExceptionAndGetResult(File path, Throwable e, String hint) {
                        e.printStackTrace();
                        Predef$.MODULE$.println();
                        Predef$.MODULE$.println((Object)Colors$.MODULE$.red(new StringBuilder(64).append("Stacktrace caused by project ").append(path.getName()).append(" (filesystem path to project is ").append(path.getAbsolutePath()).append(").\n").append(hint).toString()));
                    }

                    private String logExceptionAndGetResult$default$3() {
                        return "";
                    }

                    public None$ handleWebCommand(RequestHeader request) {
                        return None$.MODULE$;
                    }

                    public static final /* synthetic */ void $anonfun$get$4(Application app) {
                        Play$.MODULE$.stop(app);
                    }

                    public static final /* synthetic */ void $anonfun$get$7(anon.1 $this, Application app) {
                        $this.lastState_$eq((Try<Application>)new Success((Object)app));
                    }
                    {
                        this.buildLink$1 = buildLink$1;
                        this.path$1 = path$1;
                        this.dirAndDevSettings$1 = dirAndDevSettings$1;
                        ApplicationProvider.$init$((ApplicationProvider)this);
                        this.lastState = new Failure((Throwable)new PlayException("Not initialized", "?"));
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$get$1(play.core.server.LagomReloadableDevServerStart$$anon$1 ), $anonfun$get$4$adapted(play.api.Application ), $anonfun$get$5(play.core.server.LagomReloadableDevServerStart$$anon$1 play.api.Environment play.core.SourceMapper ), $anonfun$get$3(play.core.server.LagomReloadableDevServerStart$$anon$1 java.lang.ClassLoader ), $anonfun$get$6(scala.util.Try ), $anonfun$get$7$adapted(play.core.server.LagomReloadableDevServerStart$$anon$1 play.api.Application ), $anonfun$get$8(play.core.server.LagomReloadableDevServerStart$$anon$1 ), $anonfun$get$2(play.core.server.LagomReloadableDevServerStart$$anon$1 scala.Option )}, serializedLambda);
                    }
                };
                ServerConfig serverConfig = new ServerConfig(path, httpPort, httpsPort, httpAddress, (Mode)Mode.Dev$.MODULE$, process.properties(), Configuration$.MODULE$.load(classLoader, System.getProperties(), dirAndDevSettings, true));
                Config devModeAkkaConfig = serverConfig.configuration().underlying().getConfig("lagom.akka.dev-mode.config");
                String actorSystemName = serverConfig.configuration().underlying().getString("lagom.akka.dev-mode.actor-system.name");
                ActorSystem actorSystem = ActorSystem$.MODULE$.apply(actorSystemName, devModeAkkaConfig);
                ServerProvider.Context serverContext = new ServerProvider.Context(serverConfig, appProvider, actorSystem, (Materializer)ActorMaterializer$.MODULE$.apply(ActorMaterializer$.MODULE$.apply$default$1(), ActorMaterializer$.MODULE$.apply$default$2(), (ActorRefFactory)actorSystem), (Function0 & Serializable & scala.Serializable)() -> actorSystem.terminate());
                ServerProvider serverProvider = ServerProvider$.MODULE$.fromConfiguration(classLoader, serverConfig.configuration());
                server = serverProvider.createServer(serverContext);
            }
            catch (ExceptionInInitializerError e) {
                throw e.getCause();
            }
            return server;
        });
    }

    private LagomReloadableDevServerStart$() {
        MODULE$ = this;
        this.startupWarningThreshold = 1000L;
    }
}

