/*
 * Decompiled with CFR 0.152.
 */
package com.lightbend.lagom.scaladsl.api.transport;

import com.lightbend.lagom.scaladsl.api.transport.TransportErrorCode;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.runtime.BoxesRunTime;

public final class TransportErrorCode$
implements Serializable {
    public static TransportErrorCode$ MODULE$;
    private final TransportErrorCode ProtocolError;
    private final TransportErrorCode UnsupportedData;
    private final TransportErrorCode BadRequest;
    private final TransportErrorCode Forbidden;
    private final TransportErrorCode PolicyViolation;
    private final TransportErrorCode NotFound;
    private final TransportErrorCode MethodNotAllowed;
    private final TransportErrorCode NotAcceptable;
    private final TransportErrorCode PayloadTooLarge;
    private final TransportErrorCode UnsupportedMediaType;
    private final TransportErrorCode UnexpectedCondition;
    private final TransportErrorCode InternalServerError;
    private final TransportErrorCode ServiceUnavailable;
    private final TransportErrorCode GoingAway;
    private final Seq<TransportErrorCode> allErrorCodes;
    private final Map<Object, TransportErrorCode> HttpErrorCodeMap;
    private final Map<Object, TransportErrorCode> WebSocketErrorCodeMap;

    static {
        new TransportErrorCode$();
    }

    public TransportErrorCode apply(int http, int webSocket, String description) {
        return new TransportErrorCode.TransportErrorCodeImpl(http, webSocket, description);
    }

    public TransportErrorCode ProtocolError() {
        return this.ProtocolError;
    }

    public TransportErrorCode UnsupportedData() {
        return this.UnsupportedData;
    }

    public TransportErrorCode BadRequest() {
        return this.BadRequest;
    }

    public TransportErrorCode Forbidden() {
        return this.Forbidden;
    }

    public TransportErrorCode PolicyViolation() {
        return this.PolicyViolation;
    }

    public TransportErrorCode NotFound() {
        return this.NotFound;
    }

    public TransportErrorCode MethodNotAllowed() {
        return this.MethodNotAllowed;
    }

    public TransportErrorCode NotAcceptable() {
        return this.NotAcceptable;
    }

    public TransportErrorCode PayloadTooLarge() {
        return this.PayloadTooLarge;
    }

    public TransportErrorCode UnsupportedMediaType() {
        return this.UnsupportedMediaType;
    }

    public TransportErrorCode UnexpectedCondition() {
        return this.UnexpectedCondition;
    }

    public TransportErrorCode InternalServerError() {
        return this.InternalServerError;
    }

    public TransportErrorCode ServiceUnavailable() {
        return this.ServiceUnavailable;
    }

    public TransportErrorCode GoingAway() {
        return this.GoingAway;
    }

    private Seq<TransportErrorCode> allErrorCodes() {
        return this.allErrorCodes;
    }

    private Map<Object, TransportErrorCode> HttpErrorCodeMap() {
        return this.HttpErrorCodeMap;
    }

    private Map<Object, TransportErrorCode> WebSocketErrorCodeMap() {
        return this.WebSocketErrorCodeMap;
    }

    public TransportErrorCode fromHttp(int code) {
        TransportErrorCode transportErrorCode;
        boolean bl = false;
        Option option = null;
        Option option2 = this.HttpErrorCodeMap().get((Object)BoxesRunTime.boxToInteger((int)code));
        if (option2 instanceof Some) {
            TransportErrorCode errorCode;
            Some some = (Some)option2;
            transportErrorCode = errorCode = (TransportErrorCode)some.value();
        } else {
            if (None$.MODULE$.equals(option2)) {
                bl = true;
                option = option2;
                if (code > 599 || code < 100) {
                    throw new IllegalArgumentException(new StringBuilder(26).append("Invalid http status code: ").append(code).toString());
                }
            }
            if (bl && code < 400) {
                throw new IllegalArgumentException(new StringBuilder(25).append("Invalid http error code: ").append(code).toString());
            }
            if (bl) {
                transportErrorCode = this.apply(code, 4000 + code, "Unknown error code");
            } else {
                throw new MatchError((Object)option2);
            }
        }
        return transportErrorCode;
    }

    public TransportErrorCode fromWebSocket(int code) {
        TransportErrorCode transportErrorCode;
        boolean bl = false;
        Option option = null;
        Option option2 = this.WebSocketErrorCodeMap().get((Object)BoxesRunTime.boxToInteger((int)code));
        if (option2 instanceof Some) {
            TransportErrorCode errorCode;
            Some some = (Some)option2;
            transportErrorCode = errorCode = (TransportErrorCode)some.value();
        } else {
            if (None$.MODULE$.equals(option2)) {
                bl = true;
                option = option2;
                if (code < 0 || code > 65535) {
                    throw new IllegalArgumentException(new StringBuilder(31).append("Invalid WebSocket status code: ").append(code).toString());
                }
            }
            if (bl && code >= 4400 && code <= 4599) {
                transportErrorCode = this.apply(code - 4000, code, "Unknown error code");
            } else if (bl) {
                transportErrorCode = this.apply(404, code, "Unknown error code");
            } else {
                throw new MatchError((Object)option2);
            }
        }
        return transportErrorCode;
    }

    private Object readResolve() {
        return MODULE$;
    }

    private TransportErrorCode$() {
        MODULE$ = this;
        this.ProtocolError = this.apply(400, 1002, "Protocol Error/Bad Request");
        this.UnsupportedData = this.apply(400, 1003, "Unsupported Data/Bad Request");
        this.BadRequest = this.UnsupportedData();
        this.Forbidden = this.apply(403, 4403, "Forbidden");
        this.PolicyViolation = this.apply(404, 1008, "Policy Violation/Not Found");
        this.NotFound = this.PolicyViolation();
        this.MethodNotAllowed = this.apply(405, 4405, "Method Not Allowed");
        this.NotAcceptable = this.apply(406, 4406, "Not Acceptable");
        this.PayloadTooLarge = this.apply(413, 1009, "Payload Too Large");
        this.UnsupportedMediaType = this.apply(415, 4415, "Unsupported Media Type");
        this.UnexpectedCondition = this.apply(500, 1011, "Unexpected Condition/Internal Server Error");
        this.InternalServerError = this.UnexpectedCondition();
        this.ServiceUnavailable = this.apply(503, 1001, "Going Away/Service Unavailable");
        this.GoingAway = this.ServiceUnavailable();
        this.allErrorCodes = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TransportErrorCode[]{this.ProtocolError(), this.UnsupportedData(), this.Forbidden(), this.PolicyViolation(), this.MethodNotAllowed(), this.NotAcceptable(), this.PayloadTooLarge(), this.UnsupportedMediaType(), this.UnexpectedCondition(), this.ServiceUnavailable()}));
        this.HttpErrorCodeMap = ((TraversableOnce)this.allErrorCodes().map((Function1 & java.io.Serializable & Serializable)code -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)code.http())), code), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        this.WebSocketErrorCodeMap = ((TraversableOnce)this.allErrorCodes().map((Function1 & java.io.Serializable & Serializable)code -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)code.webSocket())), code), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }
}

