/*
 * Copyright (C) 2016-2019 Lightbend Inc. <https://www.lightbend.com>
 */
package com.lightbend.lagom.internal.scaladsl.broker.kafka

import akka.util.ByteString
import com.lightbend.lagom.scaladsl.api.deser.MessageSerializer.NegotiatedDeserializer
import com.lightbend.lagom.scaladsl.api.deser.MessageSerializer.NegotiatedSerializer
import org.apache.kafka.common.serialization.Deserializer
import org.apache.kafka.common.serialization.Serializer

/**
 * Adapts a Lagom NegotiatedDeserializer into a Kafka Deserializer so that messages
 * stored in Kafka can be deserialized into the expected application's type.
 */
private[lagom] class ScaladslKafkaDeserializer[T](deserializer: NegotiatedDeserializer[T, ByteString])
    extends Deserializer[T] {

  override def configure(configs: java.util.Map[String, _], isKey: Boolean): Unit = {
    () // ignore
  }

  override def deserialize(topic: String, data: Array[Byte]): T =
    deserializer.deserialize(ByteString(data))

  override def close(): Unit = () // nothing to do

}

/**
 * Adapts a Lagom NegotiatedSerializer into a Kafka Serializer so that application's
 * messages can be serialized into a byte array and published into Kafka.
 */
private[lagom] class ScaladslKafkaSerializer[T](serializer: NegotiatedSerializer[T, ByteString]) extends Serializer[T] {

  override def configure(configs: java.util.Map[String, _], isKey: Boolean): Unit = {
    () // ignore
  }

  override def serialize(topic: String, data: T): Array[Byte] =
    serializer.serialize(data).toArray

  override def close(): Unit = () // nothing to do

}
