/*
 * Decompiled with CFR 0.152.
 */
package com.lightbend.lagom.internal.scaladsl.persistence.cassandra;

import akka.Done;
import akka.NotUsed;
import akka.stream.ActorAttributes$;
import akka.stream.scaladsl.Flow;
import akka.stream.scaladsl.Flow$;
import com.datastax.driver.core.BatchStatement;
import com.datastax.driver.core.BoundStatement;
import com.lightbend.lagom.internal.scaladsl.persistence.cassandra.CassandraAutoReadSideHandler$;
import com.lightbend.lagom.scaladsl.persistence.AggregateEvent;
import com.lightbend.lagom.scaladsl.persistence.EventStreamElement;
import com.lightbend.lagom.scaladsl.persistence.ReadSideProcessor;
import com.lightbend.lagom.scaladsl.persistence.cassandra.CassandraSession;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001ddA\u0002\u0006\f\u0003\u0003Y\u0011\u0004\u0003\u0005B\u0001\t\u0005\t\u0015!\u0003C\u0011!9\u0005A!A!\u0002\u0013A\u0005\u0002C0\u0001\u0005\u0003\u0005\u000b\u0011\u00021\t\u0011\r\u0004!\u0011!Q\u0001\f\u0011DQA\u001b\u0001\u0005\u0002-Dq\u0001\u001f\u0001C\u0002\u0013%\u0011\u0010C\u0004\u0002\u0006\u0001\u0001\u000b\u0011\u0002>\t\u000f\u0005\u001d\u0001A\"\u0005\u0002\n!9\u00111\t\u0001\u0005B\u0005\u0015#\u0001G\"bgN\fg\u000e\u001a:b%\u0016\fGmU5eK\"\u000bg\u000e\u001a7fe*\u0011A\"D\u0001\nG\u0006\u001c8/\u00198ee\u0006T!AD\b\u0002\u0017A,'o]5ti\u0016t7-\u001a\u0006\u0003!E\t\u0001b]2bY\u0006$7\u000f\u001c\u0006\u0003%M\t\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0003)U\tQ\u0001\\1h_6T!AF\f\u0002\u00131Lw\r\u001b;cK:$'\"\u0001\r\u0002\u0007\r|W.F\u0002\u001bie\u001b\"\u0001A\u000e\u0011\u0007qy#G\u0004\u0002\u001eY9\u0011aD\u000b\b\u0003?%r!\u0001\t\u0015\u000f\u0005\u0005:cB\u0001\u0012'\u001b\u0005\u0019#B\u0001\u0013&\u0003\u0019a$o\\8u}\r\u0001\u0011\"\u0001\r\n\u0005Y9\u0012B\u0001\u000b\u0016\u0013\t\u00012#\u0003\u0002\u000fW)\u0011\u0001cE\u0005\u0003[9\n\u0011CU3bINKG-\u001a)s_\u000e,7o]8s\u0015\tq1&\u0003\u00021c\ty!+Z1e'&$W\rS1oI2,'O\u0003\u0002.]A\u00111\u0007\u000e\u0007\u0001\t\u0015)\u0004A1\u00017\u0005\u0015)e/\u001a8u#\t9T\b\u0005\u00029w5\t\u0011HC\u0001;\u0003\u0015\u00198-\u00197b\u0013\ta\u0014HA\u0004O_RD\u0017N\\4\u0011\u0007yz$'D\u0001/\u0013\t\u0001eF\u0001\bBO\u001e\u0014XmZ1uK\u00163XM\u001c;\u0002\u000fM,7o]5p]B\u00111)R\u0007\u0002\t*\u0011ABL\u0005\u0003\r\u0012\u0013\u0001cQ1tg\u0006tGM]1TKN\u001c\u0018n\u001c8\u0002\u0011!\fg\u000e\u001a7feN\u0004B!S'Q1:\u0011!j\u0013\t\u0003EeJ!\u0001T\u001d\u0002\rA\u0013X\rZ3g\u0013\tquJA\u0002NCBT!\u0001T\u001d1\u0005E+\u0006cA%S)&\u00111k\u0014\u0002\u0006\u00072\f7o\u001d\t\u0003gU#\u0011B\u0016\u0002\u0002\u0002\u0003\u0005)\u0011A,\u0003\u0007}#\u0013'\u0005\u00028eA\u00111'\u0017\u0003\u00065\u0002\u0011\ra\u0017\u0002\b\u0011\u0006tG\r\\3s#\t9D\f\u0005\u00029;&\u0011a,\u000f\u0002\u0004\u0003:L\u0018A\u00033jgB\fGo\u00195feB\u0011\u0011*Y\u0005\u0003E>\u0013aa\u0015;sS:<\u0017AA3d!\t)\u0007.D\u0001g\u0015\t9\u0017(\u0001\u0006d_:\u001cWO\u001d:f]RL!!\u001b4\u0003!\u0015CXmY;uS>t7i\u001c8uKb$\u0018A\u0002\u001fj]&$h\b\u0006\u0003maF<HCA7p!\u0011q\u0007A\r-\u000e\u0003-AQaY\u0003A\u0004\u0011DQ!Q\u0003A\u0002\tCQaR\u0003A\u0002I\u0004B!S't1B\u0012AO\u001e\t\u0004\u0013J+\bCA\u001aw\t%1\u0016/!A\u0001\u0002\u000b\u0005q\u000bC\u0003`\u000b\u0001\u0007\u0001-A\u0002m_\u001e,\u0012A\u001f\t\u0004w\u0006\u0005Q\"\u0001?\u000b\u0005ut\u0018!B:mMRR'\"A@\u0002\u0007=\u0014x-C\u0002\u0002\u0004q\u0014a\u0001T8hO\u0016\u0014\u0018\u0001\u00027pO\u0002\na!\u001b8w_.,GCBA\u0006\u0003k\tI\u0004E\u0003f\u0003\u001b\t\t\"C\u0002\u0002\u0010\u0019\u0014aAR;ukJ,\u0007CBA\n\u0003;\t\t#\u0004\u0002\u0002\u0016)!\u0011qCA\r\u0003%IW.\\;uC\ndWMC\u0002\u0002\u001ce\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\ty\"!\u0006\u0003\u0007M+\u0017\u000f\u0005\u0003\u0002$\u0005ERBAA\u0013\u0015\u0011\t9#!\u000b\u0002\t\r|'/\u001a\u0006\u0005\u0003W\ti#\u0001\u0004ee&4XM\u001d\u0006\u0004\u0003_9\u0012\u0001\u00033bi\u0006\u001cH/\u0019=\n\t\u0005M\u0012Q\u0005\u0002\u000f\u0005>,h\u000eZ*uCR,W.\u001a8u\u0011\u0019\t9\u0004\u0003a\u00011\u00069\u0001.\u00198eY\u0016\u0014\bbBA\u001e\u0011\u0001\u0007\u0011QH\u0001\u0006KZ,g\u000e\u001e\t\u0005}\u0005}\"'C\u0002\u0002B9\u0012!#\u0012<f]R\u001cFO]3b[\u0016cW-\\3oi\u00061\u0001.\u00198eY\u0016$\"!a\u0012\u0011\u0015\u0005%\u0013QKA\u001f\u00033\n\t'\u0004\u0002\u0002L)\u0019\u0001#!\u0014\u000b\t\u0005=\u0013\u0011K\u0001\u0007gR\u0014X-Y7\u000b\u0005\u0005M\u0013\u0001B1lW\u0006LA!a\u0016\u0002L\t!a\t\\8x!\u0011\tY&!\u0018\u000e\u0005\u0005E\u0013\u0002BA0\u0003#\u0012A\u0001R8oKB!\u00111LA2\u0013\u0011\t)'!\u0015\u0003\u000f9{G/V:fI\u0002")
public abstract class CassandraReadSideHandler<Event extends AggregateEvent<Event>, Handler>
extends ReadSideProcessor.ReadSideHandler<Event> {
    private final CassandraSession session;
    private final Map<Class<? extends Event>, Handler> handlers;
    private final String dispatcher;
    private final ExecutionContext ec;
    private final Logger log;

    private Logger log() {
        return this.log;
    }

    public abstract Future<scala.collection.immutable.Seq<BoundStatement>> invoke(Handler var1, EventStreamElement<Event> var2);

    public Flow<EventStreamElement<Event>, Done, NotUsed> handle() {
        return ((Flow)Flow$.MODULE$.apply().mapAsync(1, (Function1 & Serializable & scala.Serializable)elem -> {
            Class<?> eventClass = elem.event().getClass();
            Object handler = $this.handlers.getOrElse(eventClass, (Function0 & Serializable & scala.Serializable)() -> {
                block0: {
                    if (!this.log().isDebugEnabled()) break block0;
                    this.log().debug("Unhandled event [{}]", new Object[]{eventClass.getName()});
                }
                return CassandraAutoReadSideHandler$.MODULE$.emptyHandler();
            });
            return this.invoke((Object)handler, (EventStreamElement)elem).flatMap((Function1 & Serializable & scala.Serializable)statements -> this.executeStatements$1((Seq)statements), $this.ec);
        })).withAttributes(ActorAttributes$.MODULE$.dispatcher(this.dispatcher));
    }

    private final Future executeStatements$1(Seq statements) {
        BatchStatement batch = new BatchStatement();
        batch.addAll((Iterable)JavaConverters$.MODULE$.seqAsJavaListConverter(statements).asJava());
        return this.session.executeWriteBatch(batch);
    }

    public CassandraReadSideHandler(CassandraSession session, Map<Class<? extends Event>, Handler> handlers, String dispatcher, ExecutionContext ec) {
        this.session = session;
        this.handlers = handlers;
        this.dispatcher = dispatcher;
        this.ec = ec;
        this.log = LoggerFactory.getLogger((Class)this.getClass());
    }
}

