/*
 * Decompiled with CFR 0.152.
 */
package com.lightbend.lagom.internal.scaladsl.persistence;

import akka.Done;
import akka.Done$;
import akka.NotUsed;
import akka.actor.ActorSystem;
import akka.actor.Props;
import akka.cluster.Cluster;
import akka.cluster.Cluster$;
import akka.cluster.sharding.ClusterSharding;
import akka.cluster.sharding.ClusterSharding$;
import akka.cluster.sharding.ClusterShardingSettings;
import akka.cluster.sharding.ClusterShardingSettings$;
import akka.event.Logging$;
import akka.persistence.query.Offset;
import akka.persistence.query.PersistenceQuery;
import akka.persistence.query.PersistenceQuery$;
import akka.persistence.query.scaladsl.EventsByTagQuery;
import akka.stream.scaladsl.Source;
import com.lightbend.lagom.internal.scaladsl.persistence.PersistentEntityActor$;
import com.lightbend.lagom.scaladsl.persistence.AggregateEvent;
import com.lightbend.lagom.scaladsl.persistence.AggregateEventTag;
import com.lightbend.lagom.scaladsl.persistence.CommandEnvelope;
import com.lightbend.lagom.scaladsl.persistence.EventStreamElement;
import com.lightbend.lagom.scaladsl.persistence.PersistentEntity;
import com.lightbend.lagom.scaladsl.persistence.PersistentEntityRef;
import com.lightbend.lagom.scaladsl.persistence.PersistentEntityRegistry;
import com.typesafe.config.Config;
import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Set;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t=e\u0001\u0002\u0016,\u0001aB\u0001\"\u0012\u0001\u0003\u0002\u0003\u0006IA\u0012\u0005\u0006\u001d\u0002!\ta\u0014\u0005\b'\u0002\u0011\r\u0011\"\u0005U\u0011\u0019\u0019\u0007\u0001)A\u0005+\"9A\r\u0001b\u0001\n#)\u0007B\u00024\u0001A\u0003%\u0001\fC\u0004h\u0001\t\u0007I\u0011C3\t\r!\u0004\u0001\u0015!\u0003Y\u0011\u001dI\u0007A1A\u0005\u0012QCaA\u001b\u0001!\u0002\u0013)\u0006\u0002C6\u0001\u0011\u000b\u0007I\u0011\u00027\t\u000fY\u0004!\u0019!C\u0005o\"1q\u0010\u0001Q\u0001\naD\u0011\"!\u0001\u0001\u0005\u0004%I!a\u0001\t\u0011\u0005U\u0001\u0001)A\u0005\u0003\u000bA\u0011\"a\u0006\u0001\u0005\u0004%I!!\u0007\t\u0011\u0005\r\u0002\u0001)A\u0005\u00037A\u0011\"!\n\u0001\u0005\u0004%I!a\n\t\u0011\u0005%\u0002\u0001)A\u0005\u0003;A\u0001\"a\u000b\u0001\u0005\u0004%I\u0001\u0016\u0005\b\u0003[\u0001\u0001\u0015!\u0003V\u0011%\ty\u0003\u0001b\u0001\n\u0013\t\t\u0004\u0003\u0005\u0002D\u0001\u0001\u000b\u0011BA\u001a\u0011%\t)\u0005\u0001b\u0001\n\u0013\t9\u0005\u0003\u0005\u0002P\u0001\u0001\u000b\u0011BA%\u0011%\t\t\u0006\u0001b\u0001\n\u0013\t\u0019\u0006\u0003\u0005\u0002\\\u0001\u0001\u000b\u0011BA+\u0011%\ti\u0006\u0001b\u0001\n\u0013\ty\u0006\u0003\u0005\u0002p\u0001\u0001\u000b\u0011BA1\u0011%\t\t\b\u0001b\u0001\n\u0013\t\u0019\b\u0003\u0005\u0002|\u0001\u0001\u000b\u0011BA;\u0011%\ti\b\u0001b\u0001\n\u0013\ty\b\u0003\u0005\u0002*\u0002\u0001\u000b\u0011BAA\u0011%\tI\f\u0001b\u0001\n\u0013\tY\f\u0003\u0005\u0002J\u0002\u0001\u000b\u0011BA_\u0011\u001d\tY\r\u0001C\u0005\u0003\u001bDq!a6\u0001\t\u0003\nI\u000eC\u0004\u0002r\u0002!\t%a=\t\u000f\u0005U\u0007\u0001\"\u0003\u0003\"!9!1\u0007\u0001\u0005B\tU\u0002b\u0002B=\u0001\u0011\u0005#1\u0010\u0002!\u0003\n\u001cHO]1diB+'o]5ti\u0016tG/\u00128uSRL(+Z4jgR\u0014\u0018P\u0003\u0002-[\u0005Y\u0001/\u001a:tSN$XM\\2f\u0015\tqs&\u0001\u0005tG\u0006d\u0017\rZ:m\u0015\t\u0001\u0014'\u0001\u0005j]R,'O\\1m\u0015\t\u00114'A\u0003mC\u001e|WN\u0003\u00025k\u0005IA.[4ii\n,g\u000e\u001a\u0006\u0002m\u0005\u00191m\\7\u0004\u0001M\u0019\u0001!O \u0011\u0005ijT\"A\u001e\u000b\u0003q\nQa]2bY\u0006L!AP\u001e\u0003\r\u0005s\u0017PU3g!\t\u00015)D\u0001B\u0015\ta#I\u0003\u0002/c%\u0011A)\u0011\u0002\u0019!\u0016\u00148/[:uK:$XI\u001c;jif\u0014VmZ5tiJL\u0018AB:zgR,W\u000e\u0005\u0002H\u00196\t\u0001J\u0003\u0002J\u0015\u0006)\u0011m\u0019;pe*\t1*\u0001\u0003bW.\f\u0017BA'I\u0005-\t5\r^8s'f\u001cH/Z7\u0002\rqJg.\u001b;?)\t\u0001&\u000b\u0005\u0002R\u00015\t1\u0006C\u0003F\u0005\u0001\u0007a)\u0001\u0003oC6,W#A+\u0011\u0007i2\u0006,\u0003\u0002Xw\t1q\n\u001d;j_:\u0004\"!\u00171\u000f\u0005is\u0006CA.<\u001b\u0005a&BA/8\u0003\u0019a$o\\8u}%\u0011qlO\u0001\u0007!J,G-\u001a4\n\u0005\u0005\u0014'AB*ue&twM\u0003\u0002`w\u0005)a.Y7fA\u0005y!n\\;s]\u0006d\u0007\u000b\\;hS:LE-F\u0001Y\u0003AQw.\u001e:oC2\u0004F.^4j]&#\u0007%\u0001\tt]\u0006\u00048\u000f[8u!2,x-\u001b8JI\u0006\t2O\\1qg\"|G\u000f\u00157vO&t\u0017\n\u001a\u0011\u0002\u001bE,XM]=QYV<\u0017N\\%e\u00039\tX/\u001a:z!2,x-\u001b8JI\u0002\n\u0001#\u001a<f]R\u001c()\u001f+bOF+XM]=\u0016\u00035\u00042A\u000f,o!\tyG/D\u0001q\u0015\tq\u0013O\u0003\u0002sg\u0006)\u0011/^3ss*\u0011AFS\u0005\u0003kB\u0014\u0001#\u0012<f]R\u001c()\u001f+bOF+XM]=\u0002\u0011MD\u0017M\u001d3j]\u001e,\u0012\u0001\u001f\t\u0003svl\u0011A\u001f\u0006\u0003mnT!\u0001 &\u0002\u000f\rdWo\u001d;fe&\u0011aP\u001f\u0002\u0010\u00072,8\u000f^3s'\"\f'\u000fZ5oO\u0006I1\u000f[1sI&tw\rI\u0001\u0005G>tg-\u0006\u0002\u0002\u0006A!\u0011qAA\t\u001b\t\tIA\u0003\u0003\u0002\f\u00055\u0011AB2p]\u001aLwMC\u0002\u0002\u0010U\n\u0001\u0002^=qKN\fg-Z\u0005\u0005\u0003'\tIA\u0001\u0004D_:4\u0017nZ\u0001\u0006G>tg\rI\u0001\u000eg:\f\u0007o\u001d5pi\u00063G/\u001a:\u0016\u0005\u0005m\u0001\u0003\u0002\u001eW\u0003;\u00012AOA\u0010\u0013\r\t\tc\u000f\u0002\u0004\u0013:$\u0018AD:oCB\u001c\bn\u001c;BMR,'\u000fI\u0001\u0012[\u0006Dh*^7cKJ|em\u00155be\u0012\u001cXCAA\u000f\u0003Ii\u0017\r\u001f(v[\n,'o\u00144TQ\u0006\u0014Hm\u001d\u0011\u0002\tI|G.Z\u0001\u0006e>dW\rI\u0001\u001aa\u0006\u001c8/\u001b<bi\u0016\fe\r^3s\u0013\u0012dW\rV5nK>,H/\u0006\u0002\u00024A!\u0011QGA \u001b\t\t9D\u0003\u0003\u0002:\u0005m\u0012\u0001\u00033ve\u0006$\u0018n\u001c8\u000b\u0007\u0005u2(\u0001\u0006d_:\u001cWO\u001d:f]RLA!!\u0011\u00028\tAA)\u001e:bi&|g.\u0001\u000eqCN\u001c\u0018N^1uK\u00063G/\u001a:JI2,G+[7f_V$\b%\u0001\u0006bg.$\u0016.\\3pkR,\"!!\u0013\u0011\t\u0005U\u00121J\u0005\u0005\u0003\u001b\n9D\u0001\bGS:LG/\u001a#ve\u0006$\u0018n\u001c8\u0002\u0017\u0005\u001c8\u000eV5nK>,H\u000fI\u0001\u0011g\"\f'\u000fZ5oON+G\u000f^5oON,\"!!\u0016\u0011\u0007e\f9&C\u0002\u0002Zi\u0014qc\u00117vgR,'o\u00155be\u0012LgnZ*fiRLgnZ:\u0002#MD\u0017M\u001d3j]\u001e\u001cV\r\u001e;j]\u001e\u001c\b%A\bfqR\u0014\u0018m\u0019;F]RLG/_%e+\t\t\t\u0007\u0005\u0003\u0002d\u0005%dbA=\u0002f%\u0019\u0011q\r>\u0002\u0017MC\u0017M\u001d3SK\u001eLwN\\\u0005\u0005\u0003W\niGA\bFqR\u0014\u0018m\u0019;F]RLG/_%e\u0015\r\t9G_\u0001\u0011Kb$(/Y2u\u000b:$\u0018\u000e^=JI\u0002\na\"\u001a=ue\u0006\u001cGo\u00155be\u0012LE-\u0006\u0002\u0002vA!\u00111MA<\u0013\u0011\tI(!\u001c\u0003\u001d\u0015CHO]1diNC\u0017M\u001d3JI\u0006yQ\r\u001f;sC\u000e$8\u000b[1sI&#\u0007%A\nsK\u001eL7\u000f^3sK\u0012$\u0016\u0010]3OC6,7/\u0006\u0002\u0002\u0002B9\u00111QAH1\u0006MUBAAC\u0015\u0011\ti$a\"\u000b\t\u0005%\u00151R\u0001\u0005kRLGN\u0003\u0002\u0002\u000e\u0006!!.\u0019<b\u0013\u0011\t\t*!\"\u0003#\r{gnY;se\u0016tG\u000fS1tQ6\u000b\u0007\u000f\r\u0003\u0002\u0016\u0006\u0015\u0006CBAL\u0003;\u000b\t+\u0004\u0002\u0002\u001a*!\u00111TAF\u0003\u0011a\u0017M\\4\n\t\u0005}\u0015\u0011\u0014\u0002\u0006\u00072\f7o\u001d\t\u0005\u0003G\u000b)\u000b\u0004\u0001\u0005\u0017\u0005\u001d\u0016%!A\u0001\u0002\u000b\u0005\u00111\u0016\u0002\u0004?\u0012\n\u0014\u0001\u0006:fO&\u001cH/\u001a:fIRK\b/\u001a(b[\u0016\u001c\b%\u0005\u0003\u0002.\u0006M\u0006c\u0001\u001e\u00020&\u0019\u0011\u0011W\u001e\u0003\u000f9{G\u000f[5oOB\u0019!(!.\n\u0007\u0005]6HA\u0002B]f\fqB]3wKJ\u001cXMU3hSN$XM]\u000b\u0003\u0003{\u0003r!a!\u0002\u0010\u0006}\u0006\f\r\u0003\u0002B\u0006\u0015\u0007CBAL\u0003;\u000b\u0019\r\u0005\u0003\u0002$\u0006\u0015GaCAdG\u0005\u0005\t\u0011!B\u0001\u0003W\u00131a\u0018\u00133\u0003A\u0011XM^3sg\u0016\u0014VmZ5ti\u0016\u0014\b%A\u0006qe\u0016\u0004XM\u001c3OC6,G\u0003BAh\u0003'\u0004B!a&\u0002R&\u0019\u0011-!'\t\r\u0005UG\u00051\u0001Y\u00039)g\u000e^5usRK\b/\u001a(b[\u0016\f\u0001B]3hSN$XM\u001d\u000b\u0005\u00037\f\t\u000fE\u0002;\u0003;L1!a8<\u0005\u0011)f.\u001b;\t\u0011\u0005\rX\u0005\"a\u0001\u0003K\fQ\"\u001a8uSRLh)Y2u_JL\b#\u0002\u001e\u0002h\u0006-\u0018bAAuw\tAAHY=oC6,g\bE\u0002A\u0003[L1!a<B\u0005A\u0001VM]:jgR,g\u000e^#oi&$\u00180\u0001\u0004sK\u001a4uN]\u000b\u0005\u0003k\u0014\u0019\u0001\u0006\u0003\u0002x\nuA\u0003BA}\u0005\u001b\u0001R\u0001QA~\u0003\u007fL1!!@B\u0005M\u0001VM]:jgR,g\u000e^#oi&$\u0018PU3g!\u0011\u0011\tA!\u0003\u0011\t\u0005\r&1\u0001\u0003\b\u0005\u000b1#\u0019\u0001B\u0004\u0005\u0005\u0001\u0016\u0003BAW\u0003WLAAa\u0003\u0002n\n91i\\7nC:$\u0007\"\u0003B\bM\u0005\u0005\t9\u0001B\t\u0003))g/\u001b3f]\u000e,G%\r\t\u0007\u0005'\u0011IB!\u0001\u000e\u0005\tU!b\u0001B\fw\u00059!/\u001a4mK\u000e$\u0018\u0002\u0002B\u000e\u0005+\u0011\u0001b\u00117bgN$\u0016m\u001a\u0005\u0007\u0005?1\u0003\u0019\u0001-\u0002\u0011\u0015tG/\u001b;z\u0013\u0012$2\u0001\u0017B\u0012\u0011\u001d\u0011)c\na\u0001\u0005O\t1\"\u001a8uSRL8\t\\1tgB\"!\u0011\u0006B\u0018!\u0015I&1\u0006B\u0017\u0013\r\tyJ\u0019\t\u0005\u0003G\u0013y\u0003\u0002\u0007\u00032\t\r\u0012\u0011!A\u0001\u0006\u0003\tYKA\u0002`IM\n1\"\u001a<f]R\u001cFO]3b[V!!q\u0007B()\u0019\u0011IDa\u0019\u0003nAA!1\bB\"\u0005\u000f\u0012Y&\u0004\u0002\u0003>)\u0019aFa\u0010\u000b\u0007\t\u0005#*\u0001\u0004tiJ,\u0017-\\\u0005\u0005\u0005\u000b\u0012iD\u0001\u0004T_V\u00148-\u001a\t\u0006\u0001\n%#QJ\u0005\u0004\u0005\u0017\n%AE#wK:$8\u000b\u001e:fC6,E.Z7f]R\u0004B!a)\u0003P\u00119!\u0011\u000b\u0015C\u0002\tM#!B#wK:$\u0018\u0003BAW\u0005+\u0002R\u0001\u0011B,\u0005\u001bJ1A!\u0017B\u00059\tum\u001a:fO\u0006$X-\u0012<f]R\u0004BA!\u0018\u0003`5\t!*C\u0002\u0003b)\u0013qAT8u+N,G\rC\u0004\u0003f!\u0002\rAa\u001a\u0002\u0019\u0005<wM]3hCR,G+Y4\u0011\u000b\u0001\u0013IG!\u0014\n\u0007\t-\u0014IA\tBO\u001e\u0014XmZ1uK\u00163XM\u001c;UC\u001eDqAa\u001c)\u0001\u0004\u0011\t(\u0001\u0006ge>lwJ\u001a4tKR\u0004BAa\u001d\u0003v5\t\u0011/C\u0002\u0003xE\u0014aa\u00144gg\u0016$\u0018\u0001E4sC\u000e,g-\u001e7TQV$Hm\\<o)\u0011\u0011iHa#\u0011\r\t}$\u0011\u0011BC\u001b\t\tY$\u0003\u0003\u0003\u0004\u0006m\"A\u0002$viV\u0014X\r\u0005\u0003\u0003^\t\u001d\u0015b\u0001BE\u0015\n!Ai\u001c8f\u0011\u001d\u0011i)\u000ba\u0001\u0003\u0013\nq\u0001^5nK>,H\u000f")
public class AbstractPersistentEntityRegistry
implements PersistentEntityRegistry {
    private Option<EventsByTagQuery> eventsByTagQuery;
    private final ActorSystem system;
    private final Option<String> name;
    private final String journalPluginId;
    private final String snapshotPluginId;
    private final Option<String> queryPluginId;
    private final ClusterSharding sharding;
    private final Config conf;
    private final Option<Object> snapshotAfter;
    private final int maxNumberOfShards;
    private final Option<String> role;
    private final Duration passivateAfterIdleTimeout;
    private final FiniteDuration askTimeout;
    private final ClusterShardingSettings shardingSettings;
    private final PartialFunction<Object, Tuple2<String, Object>> extractEntityId;
    private final Function1<Object, String> extractShardId;
    private final ConcurrentHashMap<String, Class<?>> registeredTypeNames;
    private final ConcurrentHashMap<Class<?>, String> reverseRegister;
    private volatile boolean bitmap$0;

    public Option<String> name() {
        return this.name;
    }

    public String journalPluginId() {
        return this.journalPluginId;
    }

    public String snapshotPluginId() {
        return this.snapshotPluginId;
    }

    public Option<String> queryPluginId() {
        return this.queryPluginId;
    }

    private Option<EventsByTagQuery> eventsByTagQuery$lzycompute() {
        AbstractPersistentEntityRegistry abstractPersistentEntityRegistry = this;
        synchronized (abstractPersistentEntityRegistry) {
            if (!this.bitmap$0) {
                this.eventsByTagQuery = this.queryPluginId().map((Function1 & Serializable & scala.Serializable)id -> (EventsByTagQuery)((PersistenceQuery)PersistenceQuery$.MODULE$.apply($this.system)).readJournalFor(id));
                this.bitmap$0 = true;
            }
        }
        return this.eventsByTagQuery;
    }

    private Option<EventsByTagQuery> eventsByTagQuery() {
        return !this.bitmap$0 ? this.eventsByTagQuery$lzycompute() : this.eventsByTagQuery;
    }

    private ClusterSharding sharding() {
        return this.sharding;
    }

    private Config conf() {
        return this.conf;
    }

    private Option<Object> snapshotAfter() {
        return this.snapshotAfter;
    }

    private int maxNumberOfShards() {
        return this.maxNumberOfShards;
    }

    private Option<String> role() {
        return this.role;
    }

    private Duration passivateAfterIdleTimeout() {
        return this.passivateAfterIdleTimeout;
    }

    private FiniteDuration askTimeout() {
        return this.askTimeout;
    }

    private ClusterShardingSettings shardingSettings() {
        return this.shardingSettings;
    }

    private PartialFunction<Object, Tuple2<String, Object>> extractEntityId() {
        return this.extractEntityId;
    }

    private Function1<Object, String> extractShardId() {
        return this.extractShardId;
    }

    private ConcurrentHashMap<String, Class<?>> registeredTypeNames() {
        return this.registeredTypeNames;
    }

    private ConcurrentHashMap<Class<?>, String> reverseRegister() {
        return this.reverseRegister;
    }

    private String prependName(String entityTypeName) {
        return new StringBuilder(0).append((String)this.name().fold((Function0 & Serializable & scala.Serializable)() -> "", (Function1 & Serializable & scala.Serializable)x$1 -> new StringBuilder(1).append((String)x$1).append("-").toString())).append(entityTypeName).toString();
    }

    @Override
    public void register(Function0<PersistentEntity> entityFactory) {
        PersistentEntity proto = (PersistentEntity)entityFactory.apply();
        String entityTypeName = proto.entityTypeName();
        Class<?> entityClass = proto.getClass();
        Class<?> alreadyRegistered = this.registeredTypeNames().putIfAbsent(entityTypeName, entityClass);
        if (alreadyRegistered != null && !alreadyRegistered.equals(entityClass)) {
            throw new IllegalArgumentException(new StringBuilder(155).append("The entityTypeName [").append(entityTypeName).append("] for entity ").append("[").append(entityClass.getName()).append("] is not unique. It is already registered by [").append(alreadyRegistered.getName()).append("]. ").append("Override entityTypeName in the PersistentEntity to define a unique name.").toString());
        }
        this.reverseRegister().putIfAbsent(entityClass, entityTypeName);
        Set set = ((Cluster)Cluster$.MODULE$.apply(this.system)).selfRoles();
        if (this.role().forall((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)set.contains((Object)elem)))) {
            Props entityProps = PersistentEntityActor$.MODULE$.props(entityTypeName, (Option<String>)None$.MODULE$, entityFactory, this.snapshotAfter(), this.passivateAfterIdleTimeout(), this.journalPluginId(), this.snapshotPluginId());
            this.sharding().start(this.prependName(entityTypeName), entityProps, this.shardingSettings(), this.extractEntityId(), this.extractShardId());
        } else {
            this.sharding().startProxy(this.prependName(entityTypeName), this.role(), this.extractEntityId(), this.extractShardId());
        }
    }

    @Override
    public <P extends PersistentEntity> PersistentEntityRef<Object> refFor(String entityId, ClassTag<P> evidence$1) {
        Class entityClass = ((ClassTag)Predef$.MODULE$.implicitly(evidence$1)).runtimeClass();
        String entityName = this.reverseRegister().get(entityClass);
        if (entityName == null) {
            throw new IllegalArgumentException(new StringBuilder(26).append("[").append(entityClass.getName()).append(" must first be registered").toString());
        }
        return new PersistentEntityRef<Object>(entityId, this.sharding().shardRegion(this.prependName(entityName)), this.system, this.askTimeout());
    }

    private String entityTypeName(Class<?> entityClass) {
        return Logging$.MODULE$.simpleName(entityClass);
    }

    @Override
    public <Event extends AggregateEvent<Event>> Source<EventStreamElement<Event>, NotUsed> eventStream(AggregateEventTag<Event> aggregateTag, Offset fromOffset) {
        Option<EventsByTagQuery> option = this.eventsByTagQuery();
        if (!(option instanceof Some)) {
            if (None$.MODULE$.equals(option)) {
                throw new UnsupportedOperationException("The Lagom persistence plugin does not support streaming events by tag");
            }
            throw new MatchError(option);
        }
        Some some = (Some)option;
        EventsByTagQuery queries = (EventsByTagQuery)some.value();
        String tag = aggregateTag.tag();
        Source source = (Source)queries.eventsByTag(tag, fromOffset).map((Function1 & Serializable & scala.Serializable)env -> new EventStreamElement<AggregateEvent>(PersistentEntityActor$.MODULE$.extractEntityId(env.persistenceId()), (AggregateEvent)env.event(), env.offset()));
        return source;
    }

    @Override
    public Future<Done> gracefulShutdown(FiniteDuration timeout) {
        return Future$.MODULE$.successful((Object)Done$.MODULE$);
    }

    public AbstractPersistentEntityRegistry(ActorSystem system) {
        this.system = system;
        this.name = None$.MODULE$;
        this.journalPluginId = "";
        this.snapshotPluginId = "";
        this.queryPluginId = None$.MODULE$;
        this.sharding = (ClusterSharding)ClusterSharding$.MODULE$.apply(system);
        this.conf = system.settings().config().getConfig("lagom.persistence");
        String string = this.conf().getString("snapshot-after");
        Object object = "off".equals(string) ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToInteger((int)this.conf().getInt("snapshot-after")));
        this.snapshotAfter = object;
        this.maxNumberOfShards = this.conf().getInt("max-number-of-shards");
        String string2 = this.conf().getString("run-entities-on-role");
        Object object2 = "".equals(string2) ? None$.MODULE$ : new Some((Object)string2);
        this.role = object2;
        long durationMs = this.conf().getDuration("passivate-after-idle-timeout", TimeUnit.MILLISECONDS);
        this.passivateAfterIdleTimeout = durationMs == 0L ? Duration$.MODULE$.Undefined() : new package.DurationLong(scala.concurrent.duration.package$.MODULE$.DurationLong(durationMs)).millis();
        this.askTimeout = new package.DurationLong(scala.concurrent.duration.package$.MODULE$.DurationLong(this.conf().getDuration("ask-timeout", TimeUnit.MILLISECONDS))).millis();
        this.shardingSettings = ClusterShardingSettings$.MODULE$.apply(system).withRole(this.role());
        this.extractEntityId = new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof CommandEnvelope) {
                    CommandEnvelope commandEnvelope = (CommandEnvelope)A1;
                    String entityId = commandEnvelope.entityId();
                    Object payload = commandEnvelope.payload();
                    object = new Tuple2((Object)entityId, payload);
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Object x1) {
                Object object = x1;
                boolean bl = object instanceof CommandEnvelope;
                return bl;
            }
        };
        this.extractShardId = (Function1 & Serializable & scala.Serializable)x0$1 -> {
            Object object = x0$1;
            if (!(object instanceof CommandEnvelope)) {
                throw new MatchError(object);
            }
            CommandEnvelope commandEnvelope = (CommandEnvelope)object;
            String entityId = commandEnvelope.entityId();
            String string = ((Object)BoxesRunTime.boxToInteger((int)(package$.MODULE$.abs(entityId.hashCode()) % this.maxNumberOfShards()))).toString();
            return string;
        };
        this.registeredTypeNames = new ConcurrentHashMap();
        this.reverseRegister = new ConcurrentHashMap();
    }
}

