/*
 * Decompiled with CFR 0.152.
 */
package com.lightbend.lagom.internal.scaladsl.persistence;

import akka.actor.ActorSystem;
import akka.actor.Props;
import akka.cluster.Cluster;
import akka.cluster.Cluster$;
import akka.cluster.sharding.ClusterShardingSettings;
import akka.cluster.sharding.ClusterShardingSettings$;
import akka.persistence.query.Offset;
import akka.stream.Materializer;
import com.lightbend.lagom.internal.persistence.ReadSideConfig;
import com.lightbend.lagom.internal.persistence.cluster.ClusterDistribution;
import com.lightbend.lagom.internal.persistence.cluster.ClusterDistribution$;
import com.lightbend.lagom.internal.persistence.cluster.ClusterDistributionSettings;
import com.lightbend.lagom.internal.persistence.cluster.ClusterDistributionSettings$;
import com.lightbend.lagom.internal.persistence.cluster.ClusterStartupTask;
import com.lightbend.lagom.internal.persistence.cluster.ClusterStartupTask$;
import com.lightbend.lagom.internal.scaladsl.persistence.ReadSideActor$;
import com.lightbend.lagom.scaladsl.persistence.AggregateEvent;
import com.lightbend.lagom.scaladsl.persistence.AggregateEventTag;
import com.lightbend.lagom.scaladsl.persistence.PersistentEntityRegistry;
import com.lightbend.lagom.scaladsl.persistence.ReadSide;
import com.lightbend.lagom.scaladsl.persistence.ReadSideProcessor;
import java.io.Serializable;
import java.net.URLEncoder;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Ea!\u0002\u0006\f\u0001E9\u0002\u0002\u0003\u0013\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0014\t\u00119\u0002!\u0011!Q\u0001\n=B\u0001\u0002\u000e\u0001\u0003\u0002\u0003\u0006I!\u000e\u0005\tq\u0001\u0011\t\u0011)A\u0005s!Aq\t\u0001B\u0001B\u0003-\u0001\n\u0003\u0005O\u0001\t\u0005\t\u0015a\u0003P\u0011\u0015)\u0006\u0001\"\u0001W\u0011\u0015\u0001\u0007\u0001\"\u0011b\u0011\u0019I\b\u0001\"\u0001\u0012u\na!+Z1e'&$W-S7qY*\u0011A\"D\u0001\fa\u0016\u00148/[:uK:\u001cWM\u0003\u0002\u000f\u001f\u0005A1oY1mC\u0012\u001cHN\u0003\u0002\u0011#\u0005A\u0011N\u001c;fe:\fGN\u0003\u0002\u0013'\u0005)A.Y4p[*\u0011A#F\u0001\nY&<\u0007\u000e\u001e2f]\u0012T\u0011AF\u0001\u0004G>l7c\u0001\u0001\u0019=A\u0011\u0011\u0004H\u0007\u00025)\t1$A\u0003tG\u0006d\u0017-\u0003\u0002\u001e5\t1\u0011I\\=SK\u001a\u0004\"a\b\u0012\u000e\u0003\u0001R!\u0001D\u0011\u000b\u00059\t\u0012BA\u0012!\u0005!\u0011V-\u00193TS\u0012,\u0017AB:zgR,Wn\u0001\u0001\u0011\u0005\u001dbS\"\u0001\u0015\u000b\u0005%R\u0013!B1di>\u0014(\"A\u0016\u0002\t\u0005\\7.Y\u0005\u0003[!\u00121\"Q2u_J\u001c\u0016p\u001d;f[\u000611m\u001c8gS\u001e\u0004\"\u0001\r\u001a\u000e\u0003ER!\u0001D\b\n\u0005M\n$A\u0004*fC\u0012\u001c\u0016\u000eZ3D_:4\u0017nZ\u0001\te\u0016<\u0017n\u001d;ssB\u0011qDN\u0005\u0003o\u0001\u0012\u0001\u0004U3sg&\u001cH/\u001a8u\u000b:$\u0018\u000e^=SK\u001eL7\u000f\u001e:z\u0003\u0011q\u0017-\\3\u0011\u0007eQD(\u0003\u0002<5\t1q\n\u001d;j_:\u0004\"!\u0010#\u000f\u0005y\u0012\u0005CA \u001b\u001b\u0005\u0001%BA!&\u0003\u0019a$o\\8u}%\u00111IG\u0001\u0007!J,G-\u001a4\n\u0005\u00153%AB*ue&twM\u0003\u0002D5\u0005\u0011Qm\u0019\t\u0003\u00132k\u0011A\u0013\u0006\u0003\u0017j\t!bY8oGV\u0014(/\u001a8u\u0013\ti%J\u0001\tFq\u0016\u001cW\u000f^5p]\u000e{g\u000e^3yi\u0006\u0019Q.\u0019;\u0011\u0005A\u001bV\"A)\u000b\u0005IS\u0013AB:ue\u0016\fW.\u0003\u0002U#\naQ*\u0019;fe&\fG.\u001b>fe\u00061A(\u001b8jiz\"Ra\u0016/^=~#2\u0001\u0017.\\!\tI\u0006!D\u0001\f\u0011\u00159u\u0001q\u0001I\u0011\u0015qu\u0001q\u0001P\u0011\u0015!s\u00011\u0001'\u0011\u0015qs\u00011\u00010\u0011\u0015!t\u00011\u00016\u0011\u0015At\u00011\u0001:\u0003!\u0011XmZ5ti\u0016\u0014XC\u00012q)\t\u0019g\r\u0005\u0002\u001aI&\u0011QM\u0007\u0002\u0005+:LG\u000f\u0003\u0004h\u0011\u0011\u0005\r\u0001[\u0001\u0011aJ|7-Z:t_J4\u0015m\u0019;pef\u00042!G5l\u0013\tQ'D\u0001\u0005=Eft\u0017-\\3?!\ryBN\\\u0005\u0003[\u0002\u0012\u0011CU3bINKG-\u001a)s_\u000e,7o]8s!\ty\u0007\u000f\u0004\u0001\u0005\u000bED!\u0019\u0001:\u0003\u000b\u00153XM\u001c;\u0012\u0005M4\bCA\ru\u0013\t)(DA\u0004O_RD\u0017N\\4\u0011\u0007}9h.\u0003\u0002yA\tq\u0011iZ4sK\u001e\fG/Z#wK:$\u0018a\u0004:fO&\u001cH/\u001a:GC\u000e$xN]=\u0016\u0007m\fY\u0001\u0006\u0002}\u007fB\u0011\u0011$`\u0005\u0003}j\u00111!\u00118z\u0011\u00199\u0017\u00021\u0001\u0002\u0002A)\u0011$a\u0001\u0002\b%\u0019\u0011Q\u0001\u000e\u0003\u0013\u0019+hn\u0019;j_:\u0004\u0004\u0003B\u0010m\u0003\u0013\u00012a\\A\u0006\t\u0019\t\u0018B1\u0001\u0002\u000eE\u00191/a\u0004\u0011\t}9\u0018\u0011\u0002")
public class ReadSideImpl
implements ReadSide {
    private final ActorSystem system;
    private final ReadSideConfig config;
    private final PersistentEntityRegistry registry;
    private final Option<String> name;
    private final Materializer mat;

    @Override
    public <Event extends AggregateEvent<Event>> void register(Function0<ReadSideProcessor<Event>> processorFactory) {
        this.registerFactory(processorFactory);
    }

    public <Event extends AggregateEvent<Event>> Object registerFactory(Function0<ReadSideProcessor<Event>> processorFactory) {
        BoxedUnit boxedUnit;
        Set set = ((Cluster)Cluster$.MODULE$.apply(this.system)).selfRoles();
        if (this.config.role().forall((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)set.contains((Object)elem)))) {
            ReadSideProcessor proto = (ReadSideProcessor)processorFactory.apply();
            String readSideName = new StringBuilder(0).append((String)this.name.fold((Function0 & Serializable & scala.Serializable)() -> "", (Function1 & Serializable & scala.Serializable)x$1 -> new StringBuilder(1).append((String)x$1).append("-").toString())).append(proto.readSideName()).toString();
            String encodedReadSideName = URLEncoder.encode(readSideName, "utf-8");
            Set tags = proto.aggregateTags();
            Set entityIds = (Set)tags.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.tag(), Set$.MODULE$.canBuildFrom());
            Option option = tags.headOption();
            if (!(option instanceof Some)) {
                if (None$.MODULE$.equals(option)) {
                    throw new IllegalArgumentException(new StringBuilder(34).append("ReadSideProcessor ").append(proto.getClass().getName()).append(" returned 0 tags").toString());
                }
                throw new MatchError((Object)option);
            }
            Some some = (Some)option;
            AggregateEventTag tag = (AggregateEventTag)some.value();
            Class clazz = tag.eventType();
            Class eventClass = clazz;
            ClusterStartupTask globalPrepareTask = ClusterStartupTask$.MODULE$.apply(this.system, new StringBuilder(22).append("readSideGlobalPrepare-").append(encodedReadSideName).toString(), (Function0 & Serializable & scala.Serializable)() -> ((ReadSideProcessor)processorFactory.apply()).buildHandler().globalPrepare(), this.config.globalPrepareTimeout(), this.config.role(), this.config.minBackoff(), this.config.maxBackoff(), this.config.randomBackoffFactor());
            Props readSideProps = ReadSideActor$.MODULE$.props(this.config, eventClass, globalPrepareTask, (Function2 & Serializable & scala.Serializable)(aggregateTag, fromOffset) -> $this.registry.eventStream(aggregateTag, (Offset)fromOffset), processorFactory, this.mat);
            ClusterShardingSettings shardingSettings = ClusterShardingSettings$.MODULE$.apply(this.system).withRole(this.config.role());
            ClusterDistributionSettings qual$1 = ClusterDistributionSettings$.MODULE$.apply(this.system);
            ClusterShardingSettings x$12 = shardingSettings;
            FiniteDuration x$22 = qual$1.copy$default$2();
            boxedUnit = ((ClusterDistribution)ClusterDistribution$.MODULE$.apply(this.system)).start(readSideName, readSideProps, entityIds, qual$1.copy(x$12, x$22));
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return boxedUnit;
    }

    public ReadSideImpl(ActorSystem system, ReadSideConfig config, PersistentEntityRegistry registry, Option<String> name, ExecutionContext ec, Materializer mat) {
        this.system = system;
        this.config = config;
        this.registry = registry;
        this.name = name;
        this.mat = mat;
    }
}

