/*
 * Decompiled with CFR 0.152.
 */
package com.lightbend.lagom.discovery;

import com.google.inject.Module;
import com.lightbend.lagom.discovery.impl.ServiceRegistryModule;
import com.lightbend.lagom.gateway.AkkaHttpServiceGatewayFactory;
import com.lightbend.lagom.gateway.NettyServiceGatewayFactory;
import com.lightbend.lagom.gateway.ServiceGatewayConfig;
import java.io.Closeable;
import java.io.File;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.Map;
import java.util.Properties;
import play.api.Application;
import play.api.Logger;
import play.api.Logger$;
import play.api.MarkerContext$;
import play.api.Mode;
import play.api.Play$;
import play.api.inject.guice.GuiceApplicationBuilder;
import play.api.inject.guice.GuiceableModule;
import play.api.inject.guice.GuiceableModule$;
import play.core.server.ReloadableServer;
import play.core.server.ServerConfig;
import play.core.server.ServerConfig$;
import play.core.server.ServerProvider;
import play.core.server.ServerProvider$;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.sys.package$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005=b\u0001\u0002\t\u0012\u0001iAQ!\u000b\u0001\u0005\u0002)Bq!\f\u0001C\u0002\u0013%a\u0006\u0003\u00048\u0001\u0001\u0006Ia\f\u0005\nq\u0001\u0001\r\u00111A\u0005\neB\u0011\"\u0011\u0001A\u0002\u0003\u0007I\u0011\u0002\"\t\u0013-\u0003\u0001\u0019!A!B\u0013Q\u0004\"\u0003)\u0001\u0001\u0004\u0005\r\u0011\"\u0003R\u0011%A\u0006\u00011AA\u0002\u0013%\u0011\fC\u0005\\\u0001\u0001\u0007\t\u0011)Q\u0005%\")Q\f\u0001C\u0001=\")1\u0010\u0001C\u0005y\"9\u00111\u0003\u0001\u0005\n\u0005U\u0001bBA\u0010\u0001\u0011\u0005\u0013\u0011\u0005\u0005\b\u0003G\u0001A\u0011AA\u0013\u0011\u001d\ti\u0003\u0001C\u0001\u0003K\u0011AcU3sm&\u001cW\rT8dCR|'oU3sm\u0016\u0014(B\u0001\n\u0014\u0003%!\u0017n]2pm\u0016\u0014\u0018P\u0003\u0002\u0015+\u0005)A.Y4p[*\u0011acF\u0001\nY&<\u0007\u000e\u001e2f]\u0012T\u0011\u0001G\u0001\u0004G>l7\u0001A\n\u0004\u0001m\u0019\u0003C\u0001\u000f\"\u001b\u0005i\"B\u0001\u0010 \u0003\u0011a\u0017M\\4\u000b\u0003\u0001\nAA[1wC&\u0011!%\b\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005\u0011:S\"A\u0013\u000b\u0005\u0019z\u0012AA5p\u0013\tASEA\u0005DY>\u001cX-\u00192mK\u00061A(\u001b8jiz\"\u0012a\u000b\t\u0003Y\u0001i\u0011!E\u0001\u0007Y><w-\u001a:\u0016\u0003=\u0002\"\u0001M\u001b\u000e\u0003ER!AM\u001a\u0002\u0007\u0005\u0004\u0018NC\u00015\u0003\u0011\u0001H.Y=\n\u0005Y\n$A\u0002'pO\u001e,'/A\u0004m_\u001e<WM\u001d\u0011\u0002\rM,'O^3s+\u0005Q\u0004CA\u001e@\u001b\u0005a$B\u0001\u001d>\u0015\tq4'\u0001\u0003d_J,\u0017B\u0001!=\u0005A\u0011V\r\\8bI\u0006\u0014G.Z*feZ,'/\u0001\u0006tKJ4XM]0%KF$\"aQ%\u0011\u0005\u0011;U\"A#\u000b\u0003\u0019\u000bQa]2bY\u0006L!\u0001S#\u0003\tUs\u0017\u000e\u001e\u0005\b\u0015\u0016\t\t\u00111\u0001;\u0003\rAH%M\u0001\bg\u0016\u0014h/\u001a:!Q\t1Q\n\u0005\u0002E\u001d&\u0011q*\u0012\u0002\tm>d\u0017\r^5mK\u0006qq-\u0019;fo\u0006L\u0018\t\u001a3sKN\u001cX#\u0001*\u0011\u0005M3V\"\u0001+\u000b\u0005U{\u0012a\u00018fi&\u0011q\u000b\u0016\u0002\u0012\u0013:,GoU8dW\u0016$\u0018\t\u001a3sKN\u001c\u0018AE4bi\u0016<\u0018-_!eIJ,7o]0%KF$\"a\u0011.\t\u000f)C\u0011\u0011!a\u0001%\u0006yq-\u0019;fo\u0006L\u0018\t\u001a3sKN\u001c\b\u0005\u000b\u0002\n\u001b\u0006)1\u000f^1siR)1i\u00183gs\")\u0001M\u0003a\u0001C\u0006\u00112/\u001a:wS\u000e,Gj\\2bi>\u0014\bk\u001c:u!\t!%-\u0003\u0002d\u000b\n\u0019\u0011J\u001c;\t\u000b\u0015T\u0001\u0019A1\u0002%M,'O^5dK\u001e\u000bG/Z<bsB{'\u000f\u001e\u0005\u0006O*\u0001\r\u0001[\u0001\u0012k:l\u0017M\\1hK\u0012\u001cVM\u001d<jG\u0016\u001c\b\u0003B5m]:l\u0011A\u001b\u0006\u0003W~\tA!\u001e;jY&\u0011QN\u001b\u0002\u0004\u001b\u0006\u0004\bCA8w\u001d\t\u0001H\u000f\u0005\u0002r\u000b6\t!O\u0003\u0002t3\u00051AH]8pizJ!!^#\u0002\rA\u0013X\rZ3g\u0013\t9\bP\u0001\u0004TiJLgn\u001a\u0006\u0003k\u0016CQA\u001f\u0006A\u00029\f1bZ1uK^\f\u00170S7qY\u0006\t2M]3bi\u0016\f\u0005\u000f\u001d7jG\u0006$\u0018n\u001c8\u0015\u000bu\f\t!!\u0005\u0011\u0005Ar\u0018BA@2\u0005-\t\u0005\u000f\u001d7jG\u0006$\u0018n\u001c8\t\u000f\u0005\r1\u00021\u0001\u0002\u0006\u0005!2/\u001a:wS\u000e,w)\u0019;fo\u0006L8i\u001c8gS\u001e\u0004B!a\u0002\u0002\u000e5\u0011\u0011\u0011\u0002\u0006\u0004\u0003\u0017\u0019\u0012aB4bi\u0016<\u0018-_\u0005\u0005\u0003\u001f\tIA\u0001\u000bTKJ4\u0018nY3HCR,w/Y=D_:4\u0017n\u001a\u0005\u0006O.\u0001\r\u0001[\u0001\rGJ,\u0017\r^3TKJ4XM\u001d\u000b\u0006u\u0005]\u00111\u0004\u0005\u0007\u00033a\u0001\u0019A?\u0002\u0017\u0005\u0004\b\u000f\\5dCRLwN\u001c\u0005\u0007\u0003;a\u0001\u0019A1\u0002\tA|'\u000f^\u0001\u0006G2|7/\u001a\u000b\u0002\u0007\u0006)2/\u001a:wS\u000e,Gj\\2bi>\u0014\u0018\t\u001a3sKN\u001cXCAA\u0014!\r\u0019\u0016\u0011F\u0005\u0004\u0003W!&aA+S\u0013\u0006)2/\u001a:wS\u000e,w)\u0019;fo\u0006L\u0018\t\u001a3sKN\u001c\b")
public class ServiceLocatorServer
implements Closeable {
    private final Logger logger = Logger$.MODULE$.apply(this.getClass());
    private volatile ReloadableServer server;
    private volatile InetSocketAddress gatewayAddress;

    private Logger logger() {
        return this.logger;
    }

    private ReloadableServer server() {
        return this.server;
    }

    private void server_$eq(ReloadableServer x$1) {
        this.server = x$1;
    }

    private InetSocketAddress gatewayAddress() {
        return this.gatewayAddress;
    }

    private void gatewayAddress_$eq(InetSocketAddress x$1) {
        this.gatewayAddress = x$1;
    }

    public synchronized void start(int serviceLocatorPort, int serviceGatewayPort, Map<String, String> unmanagedServices, String gatewayImpl) {
        Predef$.MODULE$.require(this.server() == null, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Service locator is already running on ").append(this.server().mainAddress()).toString());
        Application application = this.createApplication(new ServiceGatewayConfig(serviceGatewayPort), unmanagedServices);
        Play$.MODULE$.start(application);
        try {
            this.server_$eq(this.createServer(application, serviceLocatorPort));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                throw new RuntimeException(new StringBuilder(40).append("Unable to start service locator on port ").append(serviceLocatorPort).toString(), e);
            }
            throw throwable;
        }
        try {
            InetSocketAddress inetSocketAddress;
            String string = gatewayImpl;
            if ("netty".equals(string)) {
                inetSocketAddress = ((NettyServiceGatewayFactory)application.injector().instanceOf(ClassTag$.MODULE$.apply(NettyServiceGatewayFactory.class))).start().address();
            } else if ("akka-http".equals(string)) {
                inetSocketAddress = ((AkkaHttpServiceGatewayFactory)application.injector().instanceOf(ClassTag$.MODULE$.apply(AkkaHttpServiceGatewayFactory.class))).start();
            } else {
                throw package$.MODULE$.error(new StringBuilder(32).append("Unknown gateway implementation: ").append(string).toString());
            }
            this.gatewayAddress_$eq(inetSocketAddress);
        }
        catch (Throwable throwable) {
            Throwable throwable3 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable3);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                throw new RuntimeException(new StringBuilder(40).append("Unable to start service gateway on port ").append(serviceGatewayPort).toString(), e);
            }
            throw throwable;
        }
        this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Service locator can be reached at ").append(this.serviceLocatorAddress()).toString(), MarkerContext$.MODULE$.NoMarker());
        this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Service gateway can be reached at ").append(this.serviceGatewayAddress()).toString(), MarkerContext$.MODULE$.NoMarker());
    }

    private Application createApplication(ServiceGatewayConfig serviceGatewayConfig, Map<String, String> unmanagedServices) {
        return ((GuiceApplicationBuilder)new GuiceApplicationBuilder().overrides((Seq)Predef$.MODULE$.wrapRefArray((Object[])new GuiceableModule[]{GuiceableModule$.MODULE$.fromGuiceModule((Module)new ServiceRegistryModule(serviceGatewayConfig, unmanagedServices))}))).build();
    }

    private ReloadableServer createServer(Application application, int port) {
        Some x$1 = new Some((Object)BoxesRunTime.boxToInteger((int)port));
        Mode.Test$ x$2 = Mode.Test$.MODULE$;
        ClassLoader x$3 = ServerConfig$.MODULE$.apply$default$1();
        File x$4 = ServerConfig$.MODULE$.apply$default$2();
        Option x$5 = ServerConfig$.MODULE$.apply$default$4();
        String x$6 = ServerConfig$.MODULE$.apply$default$5();
        Properties x$7 = ServerConfig$.MODULE$.apply$default$7();
        ServerConfig config = ServerConfig$.MODULE$.apply(x$3, x$4, (Option)x$1, x$5, x$6, (Mode)x$2, x$7);
        ServerProvider provider = (ServerProvider)Predef$.MODULE$.implicitly((Object)ServerProvider$.MODULE$.defaultServerProvider());
        return provider.createServer(config, application);
    }

    @Override
    public synchronized void close() {
        if (this.server() == null) {
            Logger$.MODULE$.logger().debug("Service locator was already stopped");
        } else {
            this.logger().debug((Function0 & Serializable & scala.Serializable)() -> "Stopping service locator...", MarkerContext$.MODULE$.NoMarker());
            this.server().stop();
            this.server_$eq(null);
            this.logger().info((Function0 & Serializable & scala.Serializable)() -> "Service locator stopped", MarkerContext$.MODULE$.NoMarker());
        }
    }

    public URI serviceLocatorAddress() {
        return new URI(new StringBuilder(17).append("http://localhost:").append(this.server().mainAddress().getPort()).toString());
    }

    public URI serviceGatewayAddress() {
        return new URI(new StringBuilder(17).append("http://localhost:").append(this.gatewayAddress().getPort()).toString());
    }
}

