/*
 * Decompiled with CFR 0.152.
 */
package com.lightbend.lagom.discovery.impl;

import akka.NotUsed;
import akka.actor.ActorRef;
import akka.pattern.PatternsCS;
import akka.util.Timeout;
import com.google.inject.Inject;
import com.lightbend.lagom.discovery.ServiceRegistryActor;
import com.lightbend.lagom.discovery.ServiceRegistryActor$GetRegisteredServices$;
import com.lightbend.lagom.internal.javadsl.registry.RegisteredService;
import com.lightbend.lagom.internal.javadsl.registry.ServiceRegistry;
import com.lightbend.lagom.internal.javadsl.registry.ServiceRegistryService;
import com.lightbend.lagom.javadsl.api.ServiceCall;
import com.lightbend.lagom.javadsl.api.transport.NotFound;
import java.net.URI;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import javax.inject.Named;
import org.pcollections.PSequence;
import play.Logger;
import scala.Option;
import scala.compat.java8.OptionConverters;
import scala.concurrent.duration.Duration;

public class ServiceRegistryImpl
implements ServiceRegistry {
    private static final Logger.ALogger LOGGER = Logger.of(ServiceRegistryImpl.class);
    private final Timeout timeout = new Timeout(Duration.create((long)5L, (TimeUnit)TimeUnit.SECONDS));
    private final ActorRef registry;

    @Inject
    public ServiceRegistryImpl(@Named(value="serviceRegistryActor") ActorRef actorRef) {
        this.registry = actorRef;
    }

    public ServiceCall<ServiceRegistryService, NotUsed> register(String string) {
        return serviceRegistryService -> {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("register invoked, name=[" + string + "], request=[" + serviceRegistryService + "]");
            }
            return PatternsCS.ask((ActorRef)this.registry, (Object)new ServiceRegistryActor.Register(string, (ServiceRegistryService)serviceRegistryService), (Timeout)this.timeout).thenApply(object -> NotUsed.getInstance());
        };
    }

    public ServiceCall<NotUsed, NotUsed> unregister(String string) {
        return notUsed -> {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("unregister invoked, name=[" + string + "], request=[" + notUsed + "]");
            }
            this.registry.tell((Object)new ServiceRegistryActor.Remove(string), null);
            return CompletableFuture.completedFuture(NotUsed.getInstance());
        };
    }

    public ServiceCall<NotUsed, URI> lookup(String string) {
        return notUsed -> {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("locate invoked, name=[" + string + "], request=[" + notUsed + "]");
            }
            return PatternsCS.ask((ActorRef)this.registry, (Object)new ServiceRegistryActor.Lookup(string), (Timeout)this.timeout).thenApply(object -> {
                Optional optional = OptionConverters.toJava((Option)((Option)object));
                this.logServiceLookupResult(string, optional);
                if (optional.isPresent()) {
                    return (URI)optional.get();
                }
                throw new NotFound(string);
            });
        };
    }

    public ServiceCall<NotUsed, PSequence<RegisteredService>> registeredServices() {
        return notUsed -> PatternsCS.ask((ActorRef)this.registry, (Object)ServiceRegistryActor$GetRegisteredServices$.MODULE$, (Timeout)this.timeout).thenApply(object -> {
            ServiceRegistryActor.RegisteredServices registeredServices = (ServiceRegistryActor.RegisteredServices)object;
            return registeredServices.services();
        });
    }

    private void logServiceLookupResult(String string, Optional<URI> optional) {
        if (LOGGER.isDebugEnabled()) {
            if (optional.isPresent()) {
                LOGGER.debug("Location of service name=[" + string + "] is " + optional.get());
            } else {
                LOGGER.debug("Service name=[" + string + "] has not been registered");
            }
        }
    }
}

