/*
 * Decompiled with CFR 0.152.
 */
package com.lightbend.lagom.discovery.impl;

import com.google.inject.AbstractModule;
import com.lightbend.lagom.discovery.ServiceRegistryActor;
import com.lightbend.lagom.discovery.UnmanagedServices;
import com.lightbend.lagom.discovery.impl.ServiceRegistryImpl;
import com.lightbend.lagom.gateway.ServiceGatewayConfig;
import com.lightbend.lagom.internal.javadsl.registry.NoServiceLocator;
import com.lightbend.lagom.internal.javadsl.registry.ServiceRegistry;
import com.lightbend.lagom.javadsl.api.ServiceLocator;
import com.lightbend.lagom.javadsl.server.ServiceGuiceSupport;
import java.util.Collections;
import java.util.Map;
import play.libs.akka.AkkaGuiceSupport;

public class ServiceRegistryModule
extends AbstractModule
implements ServiceGuiceSupport,
AkkaGuiceSupport {
    private final ServiceGatewayConfig serviceGatewayConfig;
    private final Map<String, String> unmanagedServices;
    public static final String SERVICE_REGISTRY_ACTOR = "serviceRegistryActor";

    public ServiceRegistryModule(ServiceGatewayConfig serviceGatewayConfig, Map<String, String> map) {
        this.serviceGatewayConfig = serviceGatewayConfig;
        this.unmanagedServices = Collections.unmodifiableMap(map);
    }

    protected void configure() {
        this.bindService(ServiceRegistry.class, ServiceRegistryImpl.class);
        this.bindActor(ServiceRegistryActor.class, SERVICE_REGISTRY_ACTOR);
        this.bind(ServiceGatewayConfig.class).toInstance((Object)this.serviceGatewayConfig);
        this.bind(UnmanagedServices.class).toInstance((Object)UnmanagedServices.apply(this.unmanagedServices));
        this.bind(ServiceLocator.class).to(NoServiceLocator.class);
    }
}

