/*
 * Decompiled with CFR 0.152.
 */
package com.lightbend.lagom.registry.impl;

import com.google.inject.Module;
import com.lightbend.lagom.gateway.AkkaHttpServiceGatewayFactory;
import com.lightbend.lagom.gateway.NettyServiceGatewayFactory;
import com.lightbend.lagom.gateway.ServiceGatewayConfig;
import com.lightbend.lagom.registry.impl.ServiceRegistryModule;
import java.io.Closeable;
import java.io.File;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.Map;
import java.util.Properties;
import play.api.Application;
import play.api.Configuration$;
import play.api.Environment;
import play.api.Environment$;
import play.api.Logger;
import play.api.Logger$;
import play.api.MarkerContext$;
import play.api.Mode;
import play.api.Play$;
import play.api.inject.guice.GuiceApplicationBuilder;
import play.api.inject.guice.GuiceApplicationBuilder$;
import play.api.inject.guice.GuiceableModule;
import play.api.inject.guice.GuiceableModule$;
import play.core.server.Server;
import play.core.server.ServerConfig;
import play.core.server.ServerConfig$;
import play.core.server.ServerProvider;
import play.core.server.ServerProvider$;
import scala.Function0;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.sys.package$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005mb\u0001\u0002\t\u0012\u0001qAQa\u000b\u0001\u0005\u00021Bqa\f\u0001C\u0002\u0013%\u0001\u0007\u0003\u0004:\u0001\u0001\u0006I!\r\u0005\nu\u0001\u0001\r\u00111A\u0005\nmB\u0011b\u0011\u0001A\u0002\u0003\u0007I\u0011\u0002#\t\u00135\u0003\u0001\u0019!A!B\u0013a\u0004\"\u0003*\u0001\u0001\u0004\u0005\r\u0011\"\u0003T\u0011%Q\u0006\u00011AA\u0002\u0013%1\fC\u0005^\u0001\u0001\u0007\t\u0011)Q\u0005)\")q\f\u0001C\u0001A\"9\u00111\u0001\u0001\u0005\n\u0005\u0015\u0001bBA\u0010\u0001\u0011%\u0011\u0011\u0005\u0005\b\u0003_\u0001A\u0011IA\u0019\u0011\u0019\u0011\u0007\u0001\"\u0001\u00024!1A\u000f\u0001C\u0001\u0003g\u0011AcU3sm&\u001cW\rT8dCR|'oU3sm\u0016\u0014(B\u0001\n\u0014\u0003\u0011IW\u000e\u001d7\u000b\u0005Q)\u0012\u0001\u0003:fO&\u001cHO]=\u000b\u0005Y9\u0012!\u00027bO>l'B\u0001\r\u001a\u0003%a\u0017n\u001a5uE\u0016tGMC\u0001\u001b\u0003\r\u0019w.\\\u0002\u0001'\r\u0001Q$\n\t\u0003=\rj\u0011a\b\u0006\u0003A\u0005\nA\u0001\\1oO*\t!%\u0001\u0003kCZ\f\u0017B\u0001\u0013 \u0005\u0019y%M[3diB\u0011a%K\u0007\u0002O)\u0011\u0001&I\u0001\u0003S>L!AK\u0014\u0003\u0013\rcwn]3bE2,\u0017A\u0002\u001fj]&$h\bF\u0001.!\tq\u0003!D\u0001\u0012\u0003\u0019awnZ4feV\t\u0011\u0007\u0005\u00023o5\t1G\u0003\u00025k\u0005\u0019\u0011\r]5\u000b\u0003Y\nA\u0001\u001d7bs&\u0011\u0001h\r\u0002\u0007\u0019><w-\u001a:\u0002\u000f1|wmZ3sA\u000511/\u001a:wKJ,\u0012\u0001\u0010\t\u0003{\u0005k\u0011A\u0010\u0006\u0003u}R!\u0001Q\u001b\u0002\t\r|'/Z\u0005\u0003\u0005z\u0012aaU3sm\u0016\u0014\u0018AC:feZ,'o\u0018\u0013fcR\u0011Qi\u0013\t\u0003\r&k\u0011a\u0012\u0006\u0002\u0011\u0006)1oY1mC&\u0011!j\u0012\u0002\u0005+:LG\u000fC\u0004M\u000b\u0005\u0005\t\u0019\u0001\u001f\u0002\u0007a$\u0013'A\u0004tKJ4XM\u001d\u0011)\u0005\u0019y\u0005C\u0001$Q\u0013\t\tvI\u0001\u0005w_2\fG/\u001b7f\u000399\u0017\r^3xCf\fE\r\u001a:fgN,\u0012\u0001\u0016\t\u0003+bk\u0011A\u0016\u0006\u0003/\u0006\n1A\\3u\u0013\tIfKA\tJ]\u0016$8k\\2lKR\fE\r\u001a:fgN\f!cZ1uK^\f\u00170\u00113ee\u0016\u001c8o\u0018\u0013fcR\u0011Q\t\u0018\u0005\b\u0019\"\t\t\u00111\u0001U\u0003=9\u0017\r^3xCf\fE\r\u001a:fgN\u0004\u0003FA\u0005P\u0003\u0015\u0019H/\u0019:u)\u001d)\u0015M\\:vo~DQA\u0019\u0006A\u0002\r\fQc]3sm&\u001cW\rT8dCR|'/\u00113ee\u0016\u001c8\u000f\u0005\u0002eW:\u0011Q-\u001b\t\u0003M\u001ek\u0011a\u001a\u0006\u0003Qn\ta\u0001\u0010:p_Rt\u0014B\u00016H\u0003\u0019\u0001&/\u001a3fM&\u0011A.\u001c\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005)<\u0005\"B8\u000b\u0001\u0004\u0001\u0018AE:feZL7-\u001a'pG\u0006$xN\u001d)peR\u0004\"AR9\n\u0005I<%aA%oi\")AO\u0003a\u0001G\u0006)2/\u001a:wS\u000e,w)\u0019;fo\u0006L\u0018\t\u001a3sKN\u001c\b\"\u0002<\u000b\u0001\u0004\u0001\u0018AF:feZL7-Z$bi\u0016<\u0018-\u001f%uiB\u0004vN\u001d;\t\u000baT\u0001\u0019A=\u0002#UtW.\u00198bO\u0016$7+\u001a:wS\u000e,7\u000f\u0005\u0003{{\u000e\u001cW\"A>\u000b\u0005q\f\u0013\u0001B;uS2L!A`>\u0003\u00075\u000b\u0007\u000f\u0003\u0004\u0002\u0002)\u0001\raY\u0001\fO\u0006$Xm^1z\u00136\u0004H.A\tde\u0016\fG/Z!qa2L7-\u0019;j_:$b!a\u0002\u0002\u000e\u0005u\u0001c\u0001\u001a\u0002\n%\u0019\u00111B\u001a\u0003\u0017\u0005\u0003\b\u000f\\5dCRLwN\u001c\u0005\b\u0003\u001fY\u0001\u0019AA\t\u0003Q\u0019XM\u001d<jG\u0016<\u0015\r^3xCf\u001cuN\u001c4jOB!\u00111CA\r\u001b\t\t)BC\u0002\u0002\u0018U\tqaZ1uK^\f\u00170\u0003\u0003\u0002\u001c\u0005U!\u0001F*feZL7-Z$bi\u0016<\u0018-_\"p]\u001aLw\rC\u0003y\u0017\u0001\u0007\u00110\u0001\u0007de\u0016\fG/Z*feZ,'\u000fF\u0004=\u0003G\t9#a\u000b\t\u000f\u0005\u0015B\u00021\u0001\u0002\b\u0005Y\u0011\r\u001d9mS\u000e\fG/[8o\u0011\u0019\tI\u0003\u0004a\u0001G\u0006!\u0001n\\:u\u0011\u0019\ti\u0003\u0004a\u0001a\u0006!\u0001o\u001c:u\u0003\u0015\u0019Gn\\:f)\u0005)UCAA\u001b!\r)\u0016qG\u0005\u0004\u0003s1&aA+S\u0013\u0002")
public class ServiceLocatorServer
implements Closeable {
    private final Logger logger = Logger$.MODULE$.apply(this.getClass());
    private volatile Server server;
    private volatile InetSocketAddress gatewayAddress;

    private Logger logger() {
        return this.logger;
    }

    private Server server() {
        return this.server;
    }

    private void server_$eq(Server x$1) {
        this.server = x$1;
    }

    private InetSocketAddress gatewayAddress() {
        return this.gatewayAddress;
    }

    private void gatewayAddress_$eq(InetSocketAddress x$1) {
        this.gatewayAddress = x$1;
    }

    public synchronized void start(String serviceLocatorAddress, int serviceLocatorPort, String serviceGatewayAddress, int serviceGatewayHttpPort, Map<String, String> unmanagedServices, String gatewayImpl) {
        Predef$.MODULE$.require(this.server() == null, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Service locator is already running on ").append(this.server().mainAddress()).toString());
        Application application = this.createApplication(new ServiceGatewayConfig(serviceGatewayAddress, serviceGatewayHttpPort), unmanagedServices);
        Play$.MODULE$.start(application);
        try {
            this.server_$eq(this.createServer(application, serviceLocatorAddress, serviceLocatorPort));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                throw new RuntimeException(new StringBuilder(40).append("Unable to start service locator on port ").append(serviceLocatorPort).toString(), e);
            }
            throw throwable;
        }
        try {
            InetSocketAddress inetSocketAddress;
            String string = gatewayImpl;
            if ("netty".equals(string)) {
                inetSocketAddress = ((NettyServiceGatewayFactory)application.injector().instanceOf(ClassTag$.MODULE$.apply(NettyServiceGatewayFactory.class))).start().address();
            } else if ("akka-http".equals(string)) {
                inetSocketAddress = ((AkkaHttpServiceGatewayFactory)application.injector().instanceOf(ClassTag$.MODULE$.apply(AkkaHttpServiceGatewayFactory.class))).start();
            } else {
                throw package$.MODULE$.error(new StringBuilder(32).append("Unknown gateway implementation: ").append(string).toString());
            }
            this.gatewayAddress_$eq(inetSocketAddress);
        }
        catch (Throwable throwable) {
            Throwable throwable3 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable3);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                throw new RuntimeException(new StringBuilder(41).append("Unable to start service gateway on port: ").append(serviceGatewayHttpPort).toString(), e);
            }
            throw throwable;
        }
        this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Service locator can be reached at ").append(serviceLocatorAddress).toString(), MarkerContext$.MODULE$.NoMarker());
        this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Service gateway can be reached at ").append(serviceGatewayAddress).toString(), MarkerContext$.MODULE$.NoMarker());
    }

    private Application createApplication(ServiceGatewayConfig serviceGatewayConfig, Map<String, String> unmanagedServices) {
        scala.collection.immutable.Map initialSettings = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl-config.loose.disableHostnameVerification"), (Object)"true")}));
        Environment environment = Environment$.MODULE$.simple(Environment$.MODULE$.simple$default$1(), Environment$.MODULE$.simple$default$2());
        return ((GuiceApplicationBuilder)new GuiceApplicationBuilder(environment, Configuration$.MODULE$.load(environment, initialSettings), GuiceApplicationBuilder$.MODULE$.$lessinit$greater$default$3(), GuiceApplicationBuilder$.MODULE$.$lessinit$greater$default$4(), GuiceApplicationBuilder$.MODULE$.$lessinit$greater$default$5(), GuiceApplicationBuilder$.MODULE$.$lessinit$greater$default$6(), GuiceApplicationBuilder$.MODULE$.$lessinit$greater$default$7(), GuiceApplicationBuilder$.MODULE$.$lessinit$greater$default$8(), GuiceApplicationBuilder$.MODULE$.$lessinit$greater$default$9()).overrides((Seq)Predef$.MODULE$.wrapRefArray((Object[])new GuiceableModule[]{GuiceableModule$.MODULE$.fromGuiceModule((Module)new ServiceRegistryModule(serviceGatewayConfig, unmanagedServices))}))).build();
    }

    private Server createServer(Application application, String host, int port) {
        String x$1 = host;
        Some x$2 = new Some((Object)BoxesRunTime.boxToInteger((int)port));
        Mode.Test$ x$3 = Mode.Test$.MODULE$;
        ClassLoader x$4 = ServerConfig$.MODULE$.apply$default$1();
        File x$5 = ServerConfig$.MODULE$.apply$default$2();
        Option x$6 = ServerConfig$.MODULE$.apply$default$4();
        Properties x$7 = ServerConfig$.MODULE$.apply$default$7();
        ServerConfig config = ServerConfig$.MODULE$.apply(x$4, x$5, (Option)x$2, x$6, x$1, (Mode)x$3, x$7);
        ServerProvider provider = (ServerProvider)Predef$.MODULE$.implicitly((Object)ServerProvider$.MODULE$.defaultServerProvider());
        return provider.createServer(config, application);
    }

    @Override
    public synchronized void close() {
        if (this.server() == null) {
            this.logger().debug((Function0 & Serializable & scala.Serializable)() -> "Service locator was already stopped", MarkerContext$.MODULE$.NoMarker());
        } else {
            this.logger().debug((Function0 & Serializable & scala.Serializable)() -> "Stopping service locator...", MarkerContext$.MODULE$.NoMarker());
            this.server().stop();
            this.server_$eq(null);
            this.logger().info((Function0 & Serializable & scala.Serializable)() -> "Service locator stopped", MarkerContext$.MODULE$.NoMarker());
        }
    }

    public URI serviceLocatorAddress() {
        return new URI(new StringBuilder(8).append("http://").append(this.server().mainAddress().getAddress().getHostAddress()).append(":").append(this.server().mainAddress().getPort()).toString());
    }

    public URI serviceGatewayAddress() {
        return new URI(new StringBuilder(8).append("http://").append(this.server().mainAddress().getAddress().getHostAddress()).append(":").append(this.gatewayAddress().getPort()).toString());
    }
}

