/*
 * Decompiled with CFR 0.152.
 */
package com.lightbend.lagom.internal.javadsl.registry;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.lightbend.lagom.internal.javadsl.registry.AbstractRegisteredService;
import java.net.URI;
import java.util.ArrayList;

public final class RegisteredService
implements AbstractRegisteredService {
    private final String name;
    private final URI url;

    private RegisteredService(String string, URI uRI) {
        this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"name");
        this.url = (URI)Preconditions.checkNotNull((Object)uRI, (Object)"url");
    }

    private RegisteredService(RegisteredService registeredService, String string, URI uRI) {
        this.name = string;
        this.url = uRI;
    }

    @Override
    @JsonProperty
    public String name() {
        return this.name;
    }

    @Override
    @JsonProperty
    public URI url() {
        return this.url;
    }

    public final RegisteredService withName(String string) {
        if (this.name == string) {
            return this;
        }
        String string2 = (String)Preconditions.checkNotNull((Object)string, (Object)"name");
        return new RegisteredService(this, string2, this.url);
    }

    public final RegisteredService withUrl(URI uRI) {
        if (this.url == uRI) {
            return this;
        }
        URI uRI2 = (URI)Preconditions.checkNotNull((Object)uRI, (Object)"url");
        return new RegisteredService(this, this.name, uRI2);
    }

    public boolean equals(Object object) {
        return this == object || object instanceof RegisteredService && this.equalTo((RegisteredService)object);
    }

    private boolean equalTo(RegisteredService registeredService) {
        return this.name.equals(registeredService.name) && this.url.equals(registeredService.url);
    }

    public int hashCode() {
        int n = 31;
        n = n * 17 + this.name.hashCode();
        n = n * 17 + this.url.hashCode();
        return n;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"RegisteredService").add("name", (Object)this.name).add("url", (Object)this.url).toString();
    }

    @Deprecated
    @JsonCreator
    static RegisteredService fromJson(Json json) {
        Builder builder = RegisteredService.builder();
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.url != null) {
            builder.url(json.url);
        }
        return builder.build();
    }

    public static RegisteredService of(String string, URI uRI) {
        return new RegisteredService(string, uRI);
    }

    public static RegisteredService copyOf(AbstractRegisteredService abstractRegisteredService) {
        if (abstractRegisteredService instanceof RegisteredService) {
            return (RegisteredService)abstractRegisteredService;
        }
        return RegisteredService.builder().from(abstractRegisteredService).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_URL = 2L;
        private long initBits = 3L;
        private String name;
        private URI url;

        private Builder() {
        }

        public final Builder from(AbstractRegisteredService abstractRegisteredService) {
            Preconditions.checkNotNull((Object)abstractRegisteredService, (Object)"instance");
            this.name(abstractRegisteredService.name());
            this.url(abstractRegisteredService.url());
            return this;
        }

        public final Builder name(String string) {
            this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder url(URI uRI) {
            this.url = (URI)Preconditions.checkNotNull((Object)uRI, (Object)"url");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public RegisteredService build() throws IllegalStateException {
            this.checkRequiredAttributes();
            return new RegisteredService(null, this.name, this.url);
        }

        private boolean nameIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean urlIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private void checkRequiredAttributes() throws IllegalStateException {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList arrayList = Lists.newArrayList();
            if (!this.nameIsSet()) {
                arrayList.add("name");
            }
            if (!this.urlIsSet()) {
                arrayList.add("url");
            }
            return "Cannot build RegisteredService, some of required attributes are not set " + arrayList;
        }
    }

    @Deprecated
    @JsonDeserialize
    static final class Json
    implements AbstractRegisteredService {
        String name;
        URI url;

        Json() {
        }

        public void setName(String string) {
            this.name = string;
        }

        public void setUrl(URI uRI) {
            this.url = uRI;
        }

        @Override
        public String name() {
            throw new UnsupportedOperationException();
        }

        @Override
        public URI url() {
            throw new UnsupportedOperationException();
        }
    }
}

