/*
 * Decompiled with CFR 0.152.
 */
package com.lightbend.lagom.internal.javadsl.registry;

import com.google.inject.AbstractModule;
import com.lightbend.lagom.internal.javadsl.registry.ServiceRegistry;
import com.lightbend.lagom.internal.javadsl.registry.ServiceRegistryClientProvider;
import com.lightbend.lagom.internal.javadsl.registry.ServiceRegistryServiceLocator;
import com.lightbend.lagom.javadsl.api.ServiceLocator;
import com.typesafe.config.Config;
import java.net.URI;
import javax.inject.Provider;
import play.api.Configuration;
import play.api.Environment;
import play.api.Logger;
import play.api.Logger$;
import play.api.MarkerContext$;
import play.api.Mode;
import scala.Function0;
import scala.Serializable;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001%3A\u0001C\u0005\u0001-!Aq\u0004\u0001B\u0001B\u0003%\u0001\u0005\u0003\u0005)\u0001\t\u0005\t\u0015!\u0003*\u0011\u0015a\u0003\u0001\"\u0001.\u0011\u001d\u0011\u0004A1A\u0005\nMBaa\u000e\u0001!\u0002\u0013!\u0004\"\u0002\u001d\u0001\t\u0003J\u0004\"\u0002!\u0001\t#\t%!F*feZL7-\u001a*fO&\u001cHO]=N_\u0012,H.\u001a\u0006\u0003\u0015-\t\u0001B]3hSN$(/\u001f\u0006\u0003\u00195\tqA[1wC\u0012\u001cHN\u0003\u0002\u000f\u001f\u0005A\u0011N\u001c;fe:\fGN\u0003\u0002\u0011#\u0005)A.Y4p[*\u0011!cE\u0001\nY&<\u0007\u000e\u001e2f]\u0012T\u0011\u0001F\u0001\u0004G>l7\u0001A\n\u0003\u0001]\u0001\"\u0001G\u000f\u000e\u0003eQ!AG\u000e\u0002\r%t'.Z2u\u0015\ta2#\u0001\u0004h_><G.Z\u0005\u0003=e\u0011a\"\u00112tiJ\f7\r^'pIVdW-A\u0006f]ZL'o\u001c8nK:$\bCA\u0011'\u001b\u0005\u0011#BA\u0012%\u0003\r\t\u0007/\u001b\u0006\u0002K\u0005!\u0001\u000f\\1z\u0013\t9#EA\u0006F]ZL'o\u001c8nK:$\u0018!D2p]\u001aLw-\u001e:bi&|g\u000e\u0005\u0002\"U%\u00111F\t\u0002\u000e\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0002\rqJg.\u001b;?)\rq\u0003'\r\t\u0003_\u0001i\u0011!\u0003\u0005\u0006?\r\u0001\r\u0001\t\u0005\u0006Q\r\u0001\r!K\u0001\u0007Y><w-\u001a:\u0016\u0003Q\u0002\"!I\u001b\n\u0005Y\u0012#A\u0002'pO\u001e,'/A\u0004m_\u001e<WM\u001d\u0011\u0002\u0013\r|gNZ5hkJ,G#\u0001\u001e\u0011\u0005mrT\"\u0001\u001f\u000b\u0003u\nQa]2bY\u0006L!a\u0010\u001f\u0003\tUs\u0017\u000e^\u0001\u001eGJ,\u0017\r^3EKZ\u001cVM\u001d<jG\u0016dunY1u_J\u001cuN\u001c4jOV\t!\t\u0005\u0002D\r:\u0011q\u0006R\u0005\u0003\u000b&\tQdU3sm&\u001cWMU3hSN$(/_*feZL7-\u001a'pG\u0006$xN]\u0005\u0003\u000f\"\u0013AcU3sm&\u001cW\rT8dCR|'oQ8oM&<'BA#\n\u0001")
public class ServiceRegistryModule
extends AbstractModule {
    private final Environment environment;
    private final Configuration configuration;
    private final Logger logger;

    private Logger logger() {
        return this.logger;
    }

    public void configure() {
        Mode mode = this.environment.mode();
        Mode.Dev$ dev$ = Mode.Dev$.MODULE$;
        if (!(mode != null ? !mode.equals(dev$) : dev$ != null)) {
            this.bind(ServiceRegistryServiceLocator.ServiceLocatorConfig.class).toInstance((Object)this.createDevServiceLocatorConfig());
            this.bind(ServiceRegistry.class).toProvider((Provider)new ServiceRegistryClientProvider());
            this.bind(ServiceLocator.class).to(ServiceRegistryServiceLocator.class);
            this.logger().debug((Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(154).append("Running in ").append($this.environment.mode()).append(" mode. The ").append(ServiceLocator.class.getName()).append(" interface was ").append("bound to an implementation that will query the embedded Service Locator. This is fine to use ").append("only during development.").toString(), MarkerContext$.MODULE$.NoMarker());
        } else {
            this.logger().debug((Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(211).append("Running in ").append($this.environment.mode()).append(" mode, hence Lagom is not binding the ").append(ServiceLocator.class.getName()).append(" ").append("interface to a default concrete implementation as it's expected that the production ").append("environment you are using provides a custom implementation of this interface.").toString(), MarkerContext$.MODULE$.NoMarker());
        }
    }

    public ServiceRegistryServiceLocator.ServiceLocatorConfig createDevServiceLocatorConfig() {
        String serviceLocatorURLKey = "lagom.service-locator.url";
        Config config = this.configuration.underlying();
        String url = config.getString(serviceLocatorURLKey);
        return new ServiceRegistryServiceLocator.ServiceLocatorConfig(new URI(url));
    }

    public ServiceRegistryModule(Environment environment, Configuration configuration) {
        this.environment = environment;
        this.configuration = configuration;
        this.logger = Logger$.MODULE$.apply(this.getClass());
    }
}

