/*
 * Decompiled with CFR 0.152.
 */
package com.lightbend.lagom.internal.javadsl.registry;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.lightbend.lagom.internal.javadsl.registry.Method;
import com.lightbend.lagom.internal.javadsl.registry.ServiceAcl;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public class ServiceRegistryService {
    private final List<URI> uris;
    private final List<ServiceAcl> acls;

    public static ServiceRegistryService of(URI uRI, List<com.lightbend.lagom.javadsl.api.ServiceAcl> list) {
        return ServiceRegistryService.of(Collections.singletonList(uRI), list);
    }

    public static ServiceRegistryService of(List<URI> list, List<com.lightbend.lagom.javadsl.api.ServiceAcl> list2) {
        List<ServiceAcl> list3 = list2.stream().map(serviceAcl -> {
            Optional<Method> optional = serviceAcl.method().map(method -> new Method(method.name()));
            return new ServiceAcl(optional, serviceAcl.pathRegex());
        }).collect(Collectors.toList());
        return new ServiceRegistryService(list, list3);
    }

    public ServiceRegistryService(URI uRI) {
        this(uRI, Collections.emptyList());
    }

    public ServiceRegistryService(URI uRI, List<ServiceAcl> list) {
        this(Arrays.asList(uRI), list);
    }

    @JsonCreator
    public ServiceRegistryService(List<URI> list, List<ServiceAcl> list2) {
        this.uris = list;
        this.acls = list2;
    }

    public List<URI> uris() {
        return this.uris;
    }

    public List<ServiceAcl> acls() {
        return this.acls;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ServiceRegistryService)) {
            return false;
        }
        ServiceRegistryService serviceRegistryService = (ServiceRegistryService)object;
        if (!this.uris.equals(serviceRegistryService.uris)) {
            return false;
        }
        return this.acls.equals(serviceRegistryService.acls);
    }

    public int hashCode() {
        return Objects.hash(this.uris, this.acls);
    }

    public String toString() {
        return "ServiceRegistryService{uri='" + this.uris + '\'' + ", acls=" + this.acls + '}';
    }
}

