/*
 * Decompiled with CFR 0.152.
 */
package com.lightstep.tracer.shared;

import com.lightstep.tracer.grpc.ReportRequest;
import com.lightstep.tracer.grpc.ReportResponse;
import com.lightstep.tracer.shared.AbstractTracer;
import com.lightstep.tracer.shared.CollectorClient;
import com.lightstep.tracer.shared.Options;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.URL;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import lightstep.okhttp3.Dns;
import lightstep.okhttp3.MediaType;
import lightstep.okhttp3.OkHttpClient;
import lightstep.okhttp3.Request;
import lightstep.okhttp3.RequestBody;
import lightstep.okhttp3.Response;
import lightstep.okhttp3.ResponseBody;

class HttpCollectorClient
extends CollectorClient {
    private static final MediaType protoMediaType = MediaType.parse("application/octet-stream");
    private final AtomicReference<OkHttpClient> client;
    private final AbstractTracer tracer;
    private final URL collectorURL;
    private final long deadlineMillis;
    private final Options.OkHttpDns dns;

    HttpCollectorClient(AbstractTracer tracer, URL collectorURL, long deadlineMillis, Options.OkHttpDns dns) {
        this.client = new AtomicReference<OkHttpClient>(HttpCollectorClient.start(deadlineMillis, dns));
        this.tracer = tracer;
        this.collectorURL = collectorURL;
        this.deadlineMillis = deadlineMillis;
        this.dns = dns;
    }

    ReportResponse report(ReportRequest request) {
        try {
            return this.fromResponse(this.client().newCall(this.toRequest(request)).execute());
        }
        catch (Exception e) {
            this.tracer.error("Exception sending report to collector: ", (Throwable)e);
            return null;
        }
    }

    void reconnect() {
        HttpCollectorClient.shutdown(this.client.getAndSet(HttpCollectorClient.start(this.deadlineMillis, this.dns)));
    }

    void shutdown() {
        HttpCollectorClient.shutdown(this.client());
    }

    private OkHttpClient client() {
        return this.client.get();
    }

    private Request toRequest(ReportRequest request) {
        return new Request.Builder().url(this.collectorURL).post(RequestBody.create(protoMediaType, request.toByteArray())).addHeader("Lightstep-Access-Token", request.getAuth().getAccessToken()).build();
    }

    private ReportResponse fromResponse(Response response) throws IOException {
        try {
            if (!response.isSuccessful()) {
                this.tracer.error(String.format("Collector returned non-successful http code %d, message: %s", response.code(), response.message()));
                ReportResponse reportResponse = null;
                return reportResponse;
            }
            ReportResponse reportResponse = this.fromResponseBody(response.body());
            return reportResponse;
        }
        finally {
            response.close();
        }
    }

    private ReportResponse fromResponseBody(ResponseBody body) throws IOException {
        if (body == null) {
            this.tracer.error("Collector returned an empty body");
            return null;
        }
        return ReportResponse.parseFrom((InputStream)body.byteStream());
    }

    private static void shutdown(OkHttpClient client) {
        client.dispatcher().executorService().shutdown();
    }

    private static OkHttpClient start(long deadlineMillis, Options.OkHttpDns dns) {
        OkHttpClient.Builder builder = new OkHttpClient.Builder().connectTimeout(deadlineMillis, TimeUnit.MILLISECONDS);
        if (dns != null) {
            builder.dns(new CustomDns(dns));
        }
        return builder.build();
    }

    static class CustomDns
    implements Dns {
        final Options.OkHttpDns dns;

        public CustomDns(Options.OkHttpDns dns) {
            this.dns = dns;
        }

        @Override
        public List<InetAddress> lookup(String hostname) {
            return this.dns.lookup(hostname);
        }
    }
}

