/*
 * Decompiled with CFR 0.152.
 */
package lightstep.okhttp3.internal.http;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ProtocolException;
import java.net.Proxy;
import java.net.SocketTimeoutException;
import java.security.cert.CertificateException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLPeerUnverifiedException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import lightstep.okhttp3.HttpUrl;
import lightstep.okhttp3.Interceptor;
import lightstep.okhttp3.OkHttpClient;
import lightstep.okhttp3.Request;
import lightstep.okhttp3.RequestBody;
import lightstep.okhttp3.Response;
import lightstep.okhttp3.ResponseBody;
import lightstep.okhttp3.Route;
import lightstep.okhttp3.internal.Util;
import lightstep.okhttp3.internal.connection.Exchange;
import lightstep.okhttp3.internal.connection.RealConnection;
import lightstep.okhttp3.internal.connection.RouteException;
import lightstep.okhttp3.internal.connection.Transmitter;
import lightstep.okhttp3.internal.http.HttpMethod;
import lightstep.okhttp3.internal.http.RealInterceptorChain;
import lightstep.okhttp3.internal.http2.ConnectionShutdownException;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u001c\u0010\u000b\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002J\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0012H\u0002J(\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u0006H\u0002J\u0018\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u0006H\u0002J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u001cH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Llightstep/okhttp3/internal/http/RetryAndFollowUpInterceptor;", "Llightstep/okhttp3/Interceptor;", "client", "Llightstep/okhttp3/OkHttpClient;", "(Lokhttp3/OkHttpClient;)V", "buildRedirectRequest", "Llightstep/okhttp3/Request;", "userResponse", "Llightstep/okhttp3/Response;", "method", "", "followUpRequest", "route", "Llightstep/okhttp3/Route;", "intercept", "chain", "Llightstep/okhttp3/Interceptor$Chain;", "isRecoverable", "", "e", "Ljava/io/IOException;", "requestSendStarted", "recover", "transmitter", "Llightstep/okhttp3/internal/connection/Transmitter;", "userRequest", "requestIsOneShot", "retryAfter", "", "defaultDelay", "Companion", "okhttp"})
public final class RetryAndFollowUpInterceptor
implements Interceptor {
    private final OkHttpClient client;
    private static final int MAX_FOLLOW_UPS = 20;
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)chain, (String)"chain");
        Request request = chain.request();
        RealInterceptorChain realChain = (RealInterceptorChain)chain;
        Transmitter transmitter = realChain.transmitter();
        int followUpCount = 0;
        Response priorResponse = null;
        while (true) {
            Exchange exchange;
            Object object;
            Route route;
            Request followUp;
            transmitter.prepareToConnect(request);
            if (transmitter.isCanceled()) {
                throw (Throwable)new IOException("Canceled");
            }
            Response response = null;
            boolean success = false;
            try {
                response = realChain.proceed(request, transmitter, null);
                success = true;
            }
            catch (RouteException e) {
                if (!this.recover(e.getLastConnectException(), transmitter, false, request)) {
                    throw (Throwable)e.getFirstConnectException();
                }
                transmitter.exchangeDoneDueToException();
            }
            catch (IOException e2222) {
                boolean requestSendStarted;
                boolean bl = requestSendStarted = !(e2222 instanceof ConnectionShutdownException);
                if (!this.recover(e2222, transmitter, requestSendStarted, request)) {
                    throw (Throwable)e2222;
                }
                transmitter.exchangeDoneDueToException();
                {
                    catch (Throwable e2222) {
                        transmitter.exchangeDoneDueToException();
                        throw e2222;
                    }
                }
            }
            if (priorResponse != null) {
                response = response.newBuilder().priorResponse(priorResponse.newBuilder().body(null).build()).build();
            }
            if ((followUp = this.followUpRequest(response, route = (object = (exchange = response.exchange())) != null && (object = ((Exchange)object).connection()) != null ? ((RealConnection)object).route() : null)) == null) {
                if (exchange != null && exchange.isDuplex()) {
                    transmitter.timeoutEarlyExit();
                }
                return response;
            }
            RequestBody followUpBody = followUp.body();
            if (followUpBody != null && followUpBody.isOneShot()) {
                return response;
            }
            ResponseBody responseBody = response.body();
            if (responseBody != null) {
                Util.closeQuietly(responseBody);
            }
            if (transmitter.hasExchange()) {
                Exchange exchange2 = exchange;
                if (exchange2 != null) {
                    exchange2.detachWithViolence();
                }
            }
            if (++followUpCount > 20) {
                throw (Throwable)new ProtocolException("Too many follow-up requests: " + followUpCount);
            }
            request = followUp;
            priorResponse = response;
        }
    }

    private final boolean recover(IOException e, Transmitter transmitter, boolean requestSendStarted, Request userRequest) {
        if (!this.client.retryOnConnectionFailure()) {
            return false;
        }
        if (requestSendStarted && this.requestIsOneShot(e, userRequest)) {
            return false;
        }
        if (!this.isRecoverable(e, requestSendStarted)) {
            return false;
        }
        return transmitter.canRetry();
    }

    private final boolean requestIsOneShot(IOException e, Request userRequest) {
        RequestBody requestBody = userRequest.body();
        return requestBody != null && requestBody.isOneShot() || e instanceof FileNotFoundException;
    }

    private final boolean isRecoverable(IOException e, boolean requestSendStarted) {
        if (e instanceof ProtocolException) {
            return false;
        }
        if (e instanceof InterruptedIOException) {
            return e instanceof SocketTimeoutException && !requestSendStarted;
        }
        if (e instanceof SSLHandshakeException && e.getCause() instanceof CertificateException) {
            return false;
        }
        return !(e instanceof SSLPeerUnverifiedException);
    }

    private final Request followUpRequest(Response userResponse, Route route) throws IOException {
        int responseCode = userResponse.code();
        String method = userResponse.request().method();
        switch (responseCode) {
            case 407: {
                Proxy selectedProxy;
                Route route2 = route;
                if (route2 == null) {
                    Intrinsics.throwNpe();
                }
                if ((selectedProxy = route2.proxy()).type() != Proxy.Type.HTTP) {
                    throw (Throwable)new ProtocolException("Received HTTP_PROXY_AUTH (407) code while not using proxy");
                }
                return this.client.proxyAuthenticator().authenticate(route, userResponse);
            }
            case 401: {
                return this.client.authenticator().authenticate(route, userResponse);
            }
            case 307: 
            case 308: {
                if (Intrinsics.areEqual((Object)method, (Object)"GET") ^ true && Intrinsics.areEqual((Object)method, (Object)"HEAD") ^ true) {
                    return null;
                }
                return this.buildRedirectRequest(userResponse, method);
            }
            case 300: 
            case 301: 
            case 302: 
            case 303: {
                return this.buildRedirectRequest(userResponse, method);
            }
            case 408: {
                if (!this.client.retryOnConnectionFailure()) {
                    return null;
                }
                RequestBody requestBody = userResponse.request().body();
                if (requestBody != null && requestBody.isOneShot()) {
                    return null;
                }
                Response priorResponse = userResponse.priorResponse();
                if (priorResponse != null && priorResponse.code() == 408) {
                    return null;
                }
                if (this.retryAfter(userResponse, 0) > 0) {
                    return null;
                }
                return userResponse.request();
            }
            case 503: {
                Response priorResponse = userResponse.priorResponse();
                if (priorResponse != null && priorResponse.code() == 503) {
                    return null;
                }
                if (this.retryAfter(userResponse, Integer.MAX_VALUE) == 0) {
                    return userResponse.request();
                }
                return null;
            }
        }
        return null;
    }

    private final Request buildRedirectRequest(Response userResponse, String method) {
        if (!this.client.followRedirects()) {
            return null;
        }
        String string = Response.header$default(userResponse, "Location", null, 2, null);
        if (string == null) {
            return null;
        }
        String location = string;
        HttpUrl httpUrl = userResponse.request().url().resolve(location);
        if (httpUrl == null) {
            return null;
        }
        HttpUrl url = httpUrl;
        boolean sameScheme = Intrinsics.areEqual((Object)url.scheme(), (Object)userResponse.request().url().scheme());
        if (!sameScheme && !this.client.followSslRedirects()) {
            return null;
        }
        Request.Builder requestBuilder = userResponse.request().newBuilder();
        if (HttpMethod.permitsRequestBody(method)) {
            boolean maintainBody = HttpMethod.INSTANCE.redirectsWithBody(method);
            if (HttpMethod.INSTANCE.redirectsToGet(method)) {
                requestBuilder.method("GET", null);
            } else {
                RequestBody requestBody = maintainBody ? userResponse.request().body() : null;
                requestBuilder.method(method, requestBody);
            }
            if (!maintainBody) {
                requestBuilder.removeHeader("Transfer-Encoding");
                requestBuilder.removeHeader("Content-Length");
                requestBuilder.removeHeader("Content-Type");
            }
        }
        if (!Util.canReuseConnectionFor(userResponse.request().url(), url)) {
            requestBuilder.removeHeader("Authorization");
        }
        return requestBuilder.url(url).build();
    }

    private final int retryAfter(Response userResponse, int defaultDelay) {
        String string = Response.header$default(userResponse, "Retry-After", null, 2, null);
        if (string == null) {
            return defaultDelay;
        }
        String header = string;
        CharSequence charSequence = header;
        String string2 = "\\d+";
        boolean bl = false;
        string2 = new Regex(string2);
        bl = false;
        if (string2.matches(charSequence)) {
            Integer n = Integer.valueOf(header);
            Intrinsics.checkExpressionValueIsNotNull((Object)n, (String)"Integer.valueOf(header)");
            return n;
        }
        return Integer.MAX_VALUE;
    }

    public RetryAndFollowUpInterceptor(@NotNull OkHttpClient client) {
        Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
        this.client = client;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Llightstep/okhttp3/internal/http/RetryAndFollowUpInterceptor$Companion;", "", "()V", "MAX_FOLLOW_UPS", "", "okhttp"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

