/*
 * Decompiled with CFR 0.152.
 */
package lightstep.okhttp3.internal.publicsuffix;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.IDN;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import lightstep.okhttp3.internal.Util;
import lightstep.okhttp3.internal.platform.Platform;
import lightstep.okio.BufferedSource;
import lightstep.okio.GzipSource;
import lightstep.okio.Okio;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002J\u0010\u0010\u000e\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000f\u001a\u00020\fJ\b\u0010\u0010\u001a\u00020\u0011H\u0002J\b\u0010\u0012\u001a\u00020\u0011H\u0002J\u0016\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Llightstep/okhttp3/internal/publicsuffix/PublicSuffixDatabase;", "", "()V", "listRead", "Ljava/util/concurrent/atomic/AtomicBoolean;", "publicSuffixExceptionListBytes", "", "publicSuffixListBytes", "readCompleteLatch", "Ljava/util/concurrent/CountDownLatch;", "findMatchingRule", "", "", "domainLabels", "getEffectiveTldPlusOne", "domain", "readTheList", "", "readTheListUninterruptibly", "setListBytes", "Companion", "okhttp"})
public final class PublicSuffixDatabase {
    private final AtomicBoolean listRead = new AtomicBoolean(false);
    private final CountDownLatch readCompleteLatch = new CountDownLatch(1);
    private byte[] publicSuffixListBytes;
    private byte[] publicSuffixExceptionListBytes;
    @NotNull
    public static final String PUBLIC_SUFFIX_RESOURCE = "publicsuffixes.gz";
    private static final byte[] WILDCARD_LABEL;
    private static final List<String> PREVAILING_RULE;
    private static final char EXCEPTION_MARKER = '!';
    private static final PublicSuffixDatabase instance;
    public static final Companion Companion;

    @Nullable
    public final String getEffectiveTldPlusOne(@NotNull String domain) {
        String unicodeDomain;
        Intrinsics.checkParameterIsNotNull((Object)domain, (String)"domain");
        String string = unicodeDomain = IDN.toUnicode(domain);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"unicodeDomain");
        List domainLabels = StringsKt.split$default((CharSequence)string, (char[])new char[]{'.'}, (boolean)false, (int)0, (int)6, null);
        List<String> rule = this.findMatchingRule(domainLabels);
        if (domainLabels.size() == rule.size() && rule.get(0).charAt(0) != '!') {
            return null;
        }
        int firstLabelOffset = rule.get(0).charAt(0) == '!' ? domainLabels.size() - rule.size() : domainLabels.size() - (rule.size() + 1);
        return SequencesKt.joinToString$default((Sequence)SequencesKt.drop((Sequence)CollectionsKt.asSequence((Iterable)StringsKt.split$default((CharSequence)domain, (char[])new char[]{'.'}, (boolean)false, (int)0, (int)6, null)), (int)firstLabelOffset), (CharSequence)".", null, null, (int)0, null, null, (int)62, null);
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> findMatchingRule(List<String> domainLabels) {
        Object object;
        Object exactRuleLabels;
        String rule;
        int n;
        if (!this.listRead.get() && this.listRead.compareAndSet(false, true)) {
            this.readTheListUninterruptibly();
        } else {
            try {
                this.readCompleteLatch.await();
            }
            catch (InterruptedException _) {
                Thread.currentThread().interrupt();
            }
        }
        boolean _ = this.publicSuffixListBytes != null;
        int n2 = 0;
        boolean bl = false;
        if (!_) {
            boolean bl2 = false;
            String string = "Unable to load publicsuffixes.gz resource from the classpath.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        n2 = domainLabels.size();
        byte[][] byArrayArray = new byte[n2][];
        int bl2 = 0;
        while (bl2 < n2) {
            byte[] byArray;
            Charset charset;
            void i;
            int n3 = bl2;
            int n4 = bl2++;
            byte[][] byArrayArray2 = byArrayArray;
            n = 0;
            String string = domainLabels.get((int)i);
            Intrinsics.checkExpressionValueIsNotNull((Object)StandardCharsets.UTF_8, (String)"UTF_8");
            boolean bl3 = false;
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)string2.getBytes(charset), (String)"(this as java.lang.String).getBytes(charset)");
            byArrayArray2[n4] = byArray;
        }
        byte[][] domainLabelsUtf8Bytes = byArrayArray;
        String exactMatch = null;
        int n5 = 0;
        bl2 = domainLabelsUtf8Bytes.length;
        while (n5 < bl2) {
            void i;
            String rule2;
            if (this.publicSuffixListBytes == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"publicSuffixListBytes");
            }
            if ((rule2 = PublicSuffixDatabase.Companion.binarySearch(this.publicSuffixListBytes, domainLabelsUtf8Bytes, (int)i)) != null) {
                exactMatch = rule2;
                break;
            }
            ++i;
        }
        String wildcardMatch = null;
        if (((Object[])domainLabelsUtf8Bytes).length > 1) {
            byte[][] labelsWithWildcard = (byte[][])((Object[])domainLabelsUtf8Bytes).clone();
            int rule2 = 0;
            n = ((Object[])labelsWithWildcard).length - 1;
            while (rule2 < n) {
                void labelIndex;
                labelsWithWildcard[labelIndex] = WILDCARD_LABEL;
                if (this.publicSuffixListBytes == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"publicSuffixListBytes");
                }
                if ((rule = PublicSuffixDatabase.Companion.binarySearch(this.publicSuffixListBytes, labelsWithWildcard, (int)labelIndex)) != null) {
                    wildcardMatch = rule;
                    break;
                }
                ++labelIndex;
            }
        }
        String exception = null;
        if (wildcardMatch != null) {
            n = ((Object[])domainLabelsUtf8Bytes).length - 1;
            for (int labelIndex = 0; labelIndex < n; ++labelIndex) {
                if (this.publicSuffixExceptionListBytes == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"publicSuffixExceptionListBytes");
                }
                if ((rule = PublicSuffixDatabase.Companion.binarySearch(this.publicSuffixExceptionListBytes, domainLabelsUtf8Bytes, labelIndex)) == null) continue;
                exception = rule;
                break;
            }
        }
        if (exception != null) {
            exception = '!' + exception;
            return StringsKt.split$default((CharSequence)exception, (char[])new char[]{'.'}, (boolean)false, (int)0, (int)6, null);
        }
        if (exactMatch == null && wildcardMatch == null) {
            return PREVAILING_RULE;
        }
        Object object2 = exactMatch;
        if (object2 == null || (object2 = StringsKt.split$default((CharSequence)((CharSequence)object2), (char[])new char[]{'.'}, (boolean)false, (int)0, (int)6, null)) == null) {
            n = 0;
            object2 = exactRuleLabels = CollectionsKt.emptyList();
        }
        if ((object = wildcardMatch) == null || (object = StringsKt.split$default((CharSequence)((CharSequence)object), (char[])new char[]{'.'}, (boolean)false, (int)0, (int)6, null)) == null) {
            boolean bl4 = false;
            object = CollectionsKt.emptyList();
        }
        Object wildcardRuleLabels = object;
        return exactRuleLabels.size() > wildcardRuleLabels.size() ? exactRuleLabels : wildcardRuleLabels;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void readTheListUninterruptibly() {
        boolean interrupted = false;
        {
            while (true) {
                try {
                    this.readTheList();
                    if (interrupted) {
                        Thread.currentThread().interrupt();
                    }
                    return;
                }
                catch (InterruptedIOException _) {
                    Thread.interrupted();
                    interrupted = true;
                }
                catch (IOException e) {
                    Platform.Companion.get().log("Failed to read public suffix list", 5, e);
                    return;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void readTheList() throws IOException {
        byte[] publicSuffixListBytes = null;
        byte[] publicSuffixExceptionListBytes = null;
        InputStream inputStream2 = PublicSuffixDatabase.class.getResourceAsStream(PUBLIC_SUFFIX_RESOURCE);
        if (inputStream2 == null) {
            return;
        }
        InputStream resource = inputStream2;
        Object object = Okio.buffer(new GzipSource(Okio.source(resource)));
        boolean bl = false;
        Throwable throwable = null;
        try {
            BufferedSource bufferedSource = (BufferedSource)object;
            boolean bl2 = false;
            int totalBytes = bufferedSource.readInt();
            publicSuffixListBytes = bufferedSource.readByteArray(totalBytes);
            int totalExceptionBytes = bufferedSource.readInt();
            publicSuffixExceptionListBytes = bufferedSource.readByteArray(totalExceptionBytes);
            bufferedSource = Unit.INSTANCE;
        }
        catch (Throwable bufferedSource) {
            throwable = bufferedSource;
            throw bufferedSource;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
        object = this;
        bl = false;
        boolean bl3 = false;
        synchronized (object) {
            boolean bl4 = false;
            if (publicSuffixListBytes == null) {
                Intrinsics.throwNpe();
            }
            this.publicSuffixListBytes = publicSuffixListBytes;
            if (publicSuffixExceptionListBytes == null) {
                Intrinsics.throwNpe();
            }
            this.publicSuffixExceptionListBytes = publicSuffixExceptionListBytes;
            Unit unit = Unit.INSTANCE;
        }
        this.readCompleteLatch.countDown();
    }

    public final void setListBytes(@NotNull byte[] publicSuffixListBytes, @NotNull byte[] publicSuffixExceptionListBytes) {
        Intrinsics.checkParameterIsNotNull((Object)publicSuffixListBytes, (String)"publicSuffixListBytes");
        Intrinsics.checkParameterIsNotNull((Object)publicSuffixExceptionListBytes, (String)"publicSuffixExceptionListBytes");
        this.publicSuffixListBytes = publicSuffixListBytes;
        this.publicSuffixExceptionListBytes = publicSuffixExceptionListBytes;
        this.listRead.set(true);
        this.readCompleteLatch.countDown();
    }

    static {
        Companion = new Companion(null);
        WILDCARD_LABEL = new byte[]{(byte)42};
        PREVAILING_RULE = CollectionsKt.listOf((Object)"*");
        instance = new PublicSuffixDatabase();
    }

    public static final /* synthetic */ byte[] access$getPublicSuffixListBytes$p(PublicSuffixDatabase $this) {
        if ($this.publicSuffixListBytes == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"publicSuffixListBytes");
        }
        return $this.publicSuffixListBytes;
    }

    public static final /* synthetic */ void access$setPublicSuffixListBytes$p(PublicSuffixDatabase $this, byte[] byArray) {
        $this.publicSuffixListBytes = byArray;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\f\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\r\u001a\u00020\fJ)\u0010\u000e\u001a\u0004\u0018\u00010\u0007*\u00020\n2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u00a2\u0006\u0002\u0010\u0013R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Llightstep/okhttp3/internal/publicsuffix/PublicSuffixDatabase$Companion;", "", "()V", "EXCEPTION_MARKER", "", "PREVAILING_RULE", "", "", "PUBLIC_SUFFIX_RESOURCE", "WILDCARD_LABEL", "", "instance", "Llightstep/okhttp3/internal/publicsuffix/PublicSuffixDatabase;", "get", "binarySearch", "labels", "", "labelIndex", "", "([B[[BI)Ljava/lang/String;", "okhttp"})
    public static final class Companion {
        @NotNull
        public final PublicSuffixDatabase get() {
            return instance;
        }

        /*
         * WARNING - void declaration
         */
        private final String binarySearch(@NotNull byte[] $this$binarySearch, byte[][] labels, int labelIndex) {
            int low = 0;
            int high = $this$binarySearch.length;
            String match = null;
            while (low < high) {
                int mid;
                for (mid = (low + high) / 2; mid > -1 && $this$binarySearch[mid] != (byte)10; --mid) {
                }
                ++mid;
                int end = 1;
                while ($this$binarySearch[mid + end] != (byte)10) {
                    ++end;
                }
                int publicSuffixLength = mid + end - mid;
                int compareResult = 0;
                int currentLabelIndex = labelIndex;
                int currentLabelByteIndex = 0;
                int publicSuffixByteIndex = 0;
                boolean expectDot = false;
                while (true) {
                    int byte0 = 0;
                    if (expectDot) {
                        byte0 = 46;
                        expectDot = false;
                    } else {
                        byte0 = Util.and(labels[currentLabelIndex][currentLabelByteIndex], 255);
                    }
                    int byte1 = Util.and($this$binarySearch[mid + publicSuffixByteIndex], 255);
                    compareResult = byte0 - byte1;
                    if (compareResult != 0) break;
                    ++currentLabelByteIndex;
                    if (++publicSuffixByteIndex == publicSuffixLength) break;
                    if (labels[currentLabelIndex].length != currentLabelByteIndex) continue;
                    if (currentLabelIndex == ((Object[])labels).length - 1) break;
                    ++currentLabelIndex;
                    currentLabelByteIndex = -1;
                    expectDot = true;
                }
                if (compareResult < 0) {
                    high = mid - 1;
                    continue;
                }
                if (compareResult > 0) {
                    low = mid + end + 1;
                    continue;
                }
                int publicSuffixBytesLeft = publicSuffixLength - publicSuffixByteIndex;
                int labelBytesLeft = labels[currentLabelIndex].length - currentLabelByteIndex;
                int n = currentLabelIndex + 1;
                int n2 = ((Object[])labels).length;
                while (n < n2) {
                    void i;
                    labelBytesLeft += labels[i].length;
                    ++i;
                }
                if (labelBytesLeft < publicSuffixBytesLeft) {
                    high = mid - 1;
                    continue;
                }
                if (labelBytesLeft > publicSuffixBytesLeft) {
                    low = mid + end + 1;
                    continue;
                }
                Charset charset = StandardCharsets.UTF_8;
                Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"UTF_8");
                Charset charset2 = charset;
                n2 = 0;
                match = new String($this$binarySearch, mid, publicSuffixLength, charset2);
                break;
            }
            return match;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

