/*
 * Decompiled with CFR 0.152.
 */
package ammonite.sshd;

import ammonite.ops.BasePathImpl;
import ammonite.ops.Internals;
import ammonite.ops.Path;
import ammonite.ops.RelPath$;
import ammonite.ops.exists$;
import ammonite.ops.write$;
import ammonite.sshd.ShellSession;
import ammonite.sshd.SshServerConfig;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import org.apache.sshd.SshServer;
import org.apache.sshd.agent.SshAgentFactory;
import org.apache.sshd.common.Factory;
import org.apache.sshd.common.FactoryManager;
import org.apache.sshd.common.KeyPairProvider;
import org.apache.sshd.common.Session;
import org.apache.sshd.common.file.FileSystemFactory;
import org.apache.sshd.common.session.ConnectionService;
import org.apache.sshd.server.Command;
import org.apache.sshd.server.CommandFactory;
import org.apache.sshd.server.PasswordAuthenticator;
import org.apache.sshd.server.keyprovider.SimpleGeneratorHostKeyProvider;
import org.apache.sshd.server.session.ServerSession;
import scala.Array$;
import scala.Function0;
import scala.Function2;
import scala.Serializable;
import scala.Symbol;
import scala.Symbol$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.Null$;

public final class SshServer$ {
    public static final SshServer$ MODULE$;
    private static Symbol symbol$1;
    private static Symbol symbol$2;
    private static Symbol symbol$3;

    static {
        symbol$1 = Symbol$.MODULE$.apply("cache");
        symbol$2 = Symbol$.MODULE$.apply("ssh");
        symbol$3 = Symbol$.MODULE$.apply("hostkeys");
        new SshServer$();
    }

    public SshServer apply(SshServerConfig options, Function2<InputStream, OutputStream, BoxedUnit> shellServer) {
        SshServer sshServer = SshServer.setUpDefaultServer();
        sshServer.setHost(options.address());
        sshServer.setPort(options.port());
        sshServer.setPasswordAuthenticator(this.passwordAuthenticator(options.username(), options.password()));
        sshServer.setKeyPairProvider((KeyPairProvider)this.keyPairProvider(options));
        sshServer.setShellFactory((Factory)new Factory<Command>(shellServer){
            private final Function2 shellServer$1;

            public Command create() {
                return new ShellSession((Function2<InputStream, OutputStream, BoxedUnit>)this.shellServer$1);
            }
            {
                this.shellServer$1 = shellServer$1;
            }
        });
        return this.disableUnsupportedChannels(sshServer);
    }

    public SimpleGeneratorHostKeyProvider keyPairProvider(SshServerConfig options) {
        Path hostKeyFile = this.touch((Path)options.hostKeyFile().getOrElse((Function0)new Serializable(options){
            public static final long serialVersionUID = 0L;
            private final SshServerConfig options$1;

            public final Path apply() {
                return SshServer$.MODULE$.ammonite$sshd$SshServer$$fallbackHostkeyFilePath(this.options$1);
            }
            {
                this.options$1 = options$1;
            }
        }));
        return new SimpleGeneratorHostKeyProvider(hostKeyFile.toString(), "RSA");
    }

    private SshServer disableUnsupportedChannels(SshServer sshServer) {
        sshServer.setCommandFactory(new CommandFactory(){

            public Command createCommand(String command) {
                throw new IllegalArgumentException("exec is not supported");
            }
        });
        sshServer.setSubsystemFactories(Collections.emptyList());
        sshServer.setTcpipForwardingFilter(null);
        sshServer.setAgentFactory(new SshAgentFactory(){

            public Null$ createServer(ConnectionService service) {
                return null;
            }

            public Null$ createClient(FactoryManager manager) {
                return null;
            }

            public Null$ getChannelForwardingFactory() {
                return null;
            }
        });
        sshServer.setFileSystemFactory(new FileSystemFactory(){

            public Null$ createFileSystemView(Session session) {
                return null;
            }
        });
        return sshServer;
    }

    public Path ammonite$sshd$SshServer$$fallbackHostkeyFilePath(SshServerConfig options) {
        return (Path)((BasePathImpl)((BasePathImpl)options.ammoniteHome().$div(RelPath$.MODULE$.SymPath(symbol$1))).$div(RelPath$.MODULE$.SymPath(symbol$2))).$div(RelPath$.MODULE$.SymPath(symbol$3));
    }

    public Path touch(Path file) {
        if (!exists$.MODULE$.apply(file)) {
            write$.MODULE$.apply(file, Internals.Writable$.MODULE$.WritableBytes((byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())));
        }
        return file;
    }

    private PasswordAuthenticator passwordAuthenticator(String correctUsername, String correctPassword) {
        return new PasswordAuthenticator(correctUsername, correctPassword){
            private final String correctUsername$1;
            private final String correctPassword$1;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean authenticate(String username, String password, ServerSession session) {
                String string = username;
                String string2 = this.correctUsername$1;
                if (string == null) {
                    if (string2 != null) {
                        return false;
                    }
                } else if (!string.equals(string2)) return false;
                String string3 = password;
                String string4 = this.correctPassword$1;
                if (string3 == null) {
                    if (string4 == null) return true;
                    return false;
                } else {
                    if (!string3.equals(string4)) return false;
                    return true;
                }
            }
            {
                this.correctUsername$1 = correctUsername$1;
                this.correctPassword$1 = correctPassword$1;
            }
        };
    }

    private SshServer$() {
        MODULE$ = this;
    }
}

