/*
 * Decompiled with CFR 0.152.
 */
package upickle.core;

import java.nio.charset.StandardCharsets;
import upickle.core.ByteBuilder;
import upickle.core.CharBuilder;

public final class RenderUtils$ {
    public static RenderUtils$ MODULE$;
    private final int[] hexChars;

    static {
        new RenderUtils$();
    }

    public final int[] hexChars() {
        return this.hexChars;
    }

    public int hex(int i) {
        return this.hexChars()[i];
    }

    private char toHex(int nibble) {
        return (char)(nibble + (nibble >= 10 ? 87 : 48));
    }

    public final void escapeByte(CharBuilder unicodeCharBuilder, ByteBuilder sb, CharSequence s, boolean unicode, boolean wrapQuotes) {
        int i = 0;
        int len = s.length();
        int naiveOutLen = len + (wrapQuotes ? 2 : 0);
        sb.ensureLength(naiveOutLen);
        if (wrapQuotes) {
            sb.appendUnsafe((byte)34);
        }
        while (i < len) {
            char c = s.charAt(i);
            switch (c) {
                case '\"': {
                    this.escapeSingleByte(sb, i, naiveOutLen, '\"');
                    break;
                }
                case '\\': {
                    this.escapeSingleByte(sb, i, naiveOutLen, '\\');
                    break;
                }
                case '\b': {
                    this.escapeSingleByte(sb, i, naiveOutLen, 'b');
                    break;
                }
                case '\f': {
                    this.escapeSingleByte(sb, i, naiveOutLen, 'f');
                    break;
                }
                case '\n': {
                    this.escapeSingleByte(sb, i, naiveOutLen, 'n');
                    break;
                }
                case '\r': {
                    this.escapeSingleByte(sb, i, naiveOutLen, 'r');
                    break;
                }
                case '\t': {
                    this.escapeSingleByte(sb, i, naiveOutLen, 't');
                    break;
                }
                default: {
                    boolean notUnicodeChar;
                    boolean notControlChar = c >= ' ';
                    boolean bl = notUnicodeChar = c <= '~';
                    if (notControlChar && notUnicodeChar) {
                        sb.append(c);
                        break;
                    }
                    if (!notControlChar || !notUnicodeChar && unicode) {
                        this.escapeSingleByteUnicodeEscape(sb, i, naiveOutLen, c);
                        break;
                    }
                    this.escapeSingleByteUnicodeRaw(unicodeCharBuilder, sb, s, unicode, i, len, naiveOutLen, wrapQuotes);
                    return;
                }
            }
            ++i;
        }
        if (wrapQuotes) {
            sb.appendUnsafe((byte)34);
            return;
        }
    }

    public void escapeSingleByteUnicodeRaw(CharBuilder unicodeCharBuilder, ByteBuilder sb, CharSequence s, boolean unicode, int i, int len, int naiveOutLen, boolean wrapQuotes) {
        unicodeCharBuilder.reset();
        this.escapeChar0(i, naiveOutLen, len, unicodeCharBuilder, s, unicode, wrapQuotes);
        byte[] bytes = unicodeCharBuilder.makeString().getBytes(StandardCharsets.UTF_8);
        sb.appendAll(bytes, bytes.length);
    }

    public void escapeSingleByteUnicodeEscape(ByteBuilder sb, int i, int naiveOutLen, char c) {
        sb.ensureLength(naiveOutLen - i + 5);
        sb.appendUnsafeC('\\');
        sb.appendUnsafeC('u');
        sb.appendUnsafeC(this.toHex(c >> 12 & 0xF));
        sb.appendUnsafeC(this.toHex(c >> 8 & 0xF));
        sb.appendUnsafeC(this.toHex(c >> 4 & 0xF));
        sb.appendUnsafeC(this.toHex(c & 0xF));
    }

    public void escapeSingleByte(ByteBuilder sb, int i, int naiveOutLen, char c) {
        sb.ensureLength(naiveOutLen - i + 1);
        sb.appendUnsafeC('\\');
        sb.appendUnsafeC(c);
    }

    public CharBuilder escapeChar(CharBuilder unicodeCharBuilder, CharBuilder sb, CharSequence s, boolean unicode, boolean wrapQuotes) {
        int len = s.length();
        int naiveOutLen = len + (wrapQuotes ? 2 : 0);
        sb.ensureLength(naiveOutLen);
        if (wrapQuotes) {
            sb.appendUnsafe('\"');
        }
        return this.escapeChar0(0, naiveOutLen, len, sb, s, unicode, wrapQuotes);
    }

    public final CharBuilder escapeChar0(int i0, int naiveOutLen, int len, CharBuilder sb, CharSequence s, boolean unicode, boolean wrapQuotes) {
        sb.ensureLength(naiveOutLen);
        block9: for (int i = i0; i < len; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\"': {
                    this.escapeSingleChar(sb, naiveOutLen, i, '\"');
                    continue block9;
                }
                case '\\': {
                    this.escapeSingleChar(sb, naiveOutLen, i, '\\');
                    continue block9;
                }
                case '\b': {
                    this.escapeSingleChar(sb, naiveOutLen, i, 'b');
                    continue block9;
                }
                case '\f': {
                    this.escapeSingleChar(sb, naiveOutLen, i, 'f');
                    continue block9;
                }
                case '\n': {
                    this.escapeSingleChar(sb, naiveOutLen, i, 'n');
                    continue block9;
                }
                case '\r': {
                    this.escapeSingleChar(sb, naiveOutLen, i, 'r');
                    continue block9;
                }
                case '\t': {
                    this.escapeSingleChar(sb, naiveOutLen, i, 't');
                    continue block9;
                }
                default: {
                    if (c < ' ' || c > '~' && unicode) {
                        this.escapeSingleCharUnicodeEscape(naiveOutLen, sb, i, c);
                        continue block9;
                    }
                    sb.append(c);
                }
            }
        }
        if (wrapQuotes) {
            sb.appendUnsafe('\"');
        }
        return sb;
    }

    public void escapeSingleCharUnicodeEscape(int naiveOutLen, CharBuilder sb, int i, char c) {
        sb.ensureLength(naiveOutLen - i + 5);
        sb.appendUnsafeC('\\');
        sb.appendUnsafeC('u');
        sb.appendUnsafeC(this.toHex(c >> 12 & 0xF));
        sb.appendUnsafeC(this.toHex(c >> 8 & 0xF));
        sb.appendUnsafeC(this.toHex(c >> 4 & 0xF));
        sb.appendUnsafeC(this.toHex(c & 0xF));
    }

    public void escapeSingleChar(CharBuilder sb, int naiveOutLen, int i, char c) {
        sb.ensureLength(naiveOutLen - i + 1);
        sb.appendUnsafeC('\\');
        sb.appendUnsafeC(c);
    }

    /*
     * WARNING - void declaration
     */
    private RenderUtils$() {
        void var1_1;
        int i;
        MODULE$ = this;
        int[] arr = new int[128];
        for (i = 0; i < 10; ++i) {
            arr[i + 48] = i;
        }
        for (i = 0; i < 16; ++i) {
            arr[i + 97] = 10 + i;
            arr[i + 65] = 10 + i;
        }
        this.hexChars = var1_1;
    }
}

