/*
 * Decompiled with CFR 0.152.
 */
package upickle.core;

import upickle.core.ByteBuilder;
import upickle.core.ByteUtils$;
import upickle.core.CharBuilder;
import upickle.core.CharUtils$;

public final class RenderUtils$ {
    public static RenderUtils$ MODULE$;
    private final int[] hexChars;

    static {
        new RenderUtils$();
    }

    public final int[] hexChars() {
        return this.hexChars;
    }

    public int hex(int i) {
        return this.hexChars()[i];
    }

    public char toHex(int nibble) {
        return (char)(nibble + (nibble >= 10 ? 87 : 48));
    }

    public final void escapeByte(CharBuilder unicodeCharBuilder, ByteBuilder sb, CharSequence s, boolean escapeUnicode, boolean wrapQuotes) {
        int i;
        int len = s.length();
        if (wrapQuotes) {
            sb.append(34);
        }
        if (escapeUnicode) {
            for (i = 0; i < len; ++i) {
                char c = s.charAt(i);
                if (ByteUtils$.MODULE$.appendEscapedByte(sb, c, i)) continue;
                if (c < ' ' || c > '\u007f') {
                    ByteUtils$.MODULE$.escapeSingleByteUnicodeEscape(sb, i, c);
                    continue;
                }
                i = ByteUtils$.MODULE$.appendSimpleStringSectionNoUnicode(sb, i, len, s);
            }
        } else {
            while (i < len) {
                char c = s.charAt(i);
                if (!ByteUtils$.MODULE$.appendEscapedByte(sb, c, i)) {
                    if (c < ' ') {
                        ByteUtils$.MODULE$.escapeSingleByteUnicodeEscape(sb, i, c);
                    } else if (c <= '~') {
                        i = ByteUtils$.MODULE$.appendSimpleStringSectionNoUnicode(sb, i, len, s);
                    } else {
                        this.escapeSingleByteUnicodeRaw(unicodeCharBuilder, sb, s, false, i, len, wrapQuotes);
                        return;
                    }
                }
                ++i;
            }
        }
        if (wrapQuotes) {
            sb.append(34);
            return;
        }
    }

    public void escapeSingleByteUnicodeRaw(CharBuilder unicodeCharBuilder, ByteBuilder sb, CharSequence s, boolean escapeUnicode, int i0, int len0, boolean wrapQuotes) {
        unicodeCharBuilder.reset();
        this.escapeChar0(i0, len0, unicodeCharBuilder, s, escapeUnicode, wrapQuotes);
        char[] xs = unicodeCharBuilder.arr();
        int len = unicodeCharBuilder.length();
        sb.ensureLength(len * 3);
        byte[] ys = sb.arr();
        int i = 0;
        int j = sb.length();
        while (i < len) {
            char c = xs[i];
            if (c < '\u0080') {
                ys[j] = (byte)c;
                ++i;
                ++j;
                continue;
            }
            if (c < '\u0800') {
                ys[j] = (byte)(0xC0 | c >> 6);
                ys[j + 1] = (byte)(0x80 | c & 0x3F);
                ++i;
                j += 2;
                continue;
            }
            if (Character.isHighSurrogate(c)) {
                if (len - i < 2) {
                    throw new Exception("overflow");
                }
                char d = xs[i + 1];
                if (!Character.isLowSurrogate(d)) {
                    throw new Exception("malformed");
                }
                int uc = Character.toCodePoint(c, d);
                ys[j] = (byte)(0xF0 | uc >> 18);
                ys[j + 1] = (byte)(0x80 | uc >> 12 & 0x3F);
                ys[j + 2] = (byte)(0x80 | uc >> 6 & 0x3F);
                ys[j + 3] = (byte)(0x80 | uc & 0x3F);
                i += 2;
                j += 4;
                continue;
            }
            if (Character.isLowSurrogate(c)) {
                throw new Exception("malformed");
            }
            ys[j] = (byte)(0xE0 | c >> 12);
            ys[j + 1] = (byte)(0x80 | c >> 6 & 0x3F);
            ys[j + 2] = (byte)(0x80 | c & 0x3F);
            ++i;
            j += 3;
        }
        sb.length_$eq(j);
    }

    public CharBuilder escapeChar(CharBuilder unicodeCharBuilder, CharBuilder sb, CharSequence s, boolean escapeUnicode, boolean wrapQuotes) {
        int len = s.length();
        if (wrapQuotes) {
            sb.append('\"');
        }
        return this.escapeChar0(0, len, sb, s, escapeUnicode, wrapQuotes);
    }

    public final CharBuilder escapeChar0(int i0, int len, CharBuilder sb, CharSequence s, boolean escapeUnicode, boolean wrapQuotes) {
        int i;
        if (escapeUnicode) {
            for (i = i0; i < len; ++i) {
                char c = s.charAt(i);
                if (CharUtils$.MODULE$.appendEscapedChar(sb, c, i)) continue;
                if (c < ' ' || c > '\u007f') {
                    CharUtils$.MODULE$.escapeSingleCharUnicodeEscape(sb, i, c);
                    continue;
                }
                i = CharUtils$.MODULE$.appendSimpleStringSectionNoUnicode(sb, i, len, s);
            }
        } else {
            while (i < len) {
                char c = s.charAt(i);
                if (!CharUtils$.MODULE$.appendEscapedChar(sb, c, i)) {
                    if (c < ' ') {
                        CharUtils$.MODULE$.escapeSingleCharUnicodeEscape(sb, i, c);
                    } else {
                        i = CharUtils$.MODULE$.appendSimpleStringSection(sb, i, len, s);
                    }
                }
                ++i;
            }
        }
        if (wrapQuotes) {
            sb.append('\"');
        }
        return sb;
    }

    public int intStringSize(int x0) {
        int x = x0;
        int d = 1;
        if (x0 >= 0) {
            d = 0;
            x = -x0;
        }
        int p = -10;
        for (int i = 1; i <= 10; ++i) {
            if (x > p) {
                return i + d;
            }
            p = 10 * p;
        }
        return 10 + d;
    }

    public int longStringSize(long x0) {
        long x = x0;
        int d = 1;
        if (x0 >= 0L) {
            d = 0;
            x = -x0;
        }
        long p = -10L;
        for (int i = 1; i <= 18; ++i) {
            if (x > p) {
                return i + d;
            }
            p = 10L * p;
        }
        return 19 + d;
    }

    /*
     * WARNING - void declaration
     */
    private RenderUtils$() {
        void var1_1;
        int i;
        MODULE$ = this;
        int[] arr = new int[128];
        for (i = 0; i < 10; ++i) {
            arr[i + 48] = i;
        }
        for (i = 0; i < 16; ++i) {
            arr[i + 97] = 10 + i;
            arr[i + 65] = 10 + i;
        }
        this.hexChars = var1_1;
    }
}

