/*
 * Decompiled with CFR 0.152.
 */
package com.maciejwalkowiak.wiremock.spring;

import com.github.tomakehurst.wiremock.WireMockServer;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.test.context.junit.jupiter.SpringExtension;

enum Store {
    INSTANCE;

    private static final Logger LOGGER;
    private final Map<ApplicationContext, Map<String, WireMockServer>> store = new ConcurrentHashMap<ApplicationContext, Map<String, WireMockServer>>();

    WireMockServer findWireMockInstance(ApplicationContext applicationContext, String name) {
        return this.resolve(applicationContext).get(name);
    }

    WireMockServer findRequiredWireMockInstance(ExtensionContext extensionContext, String name) {
        WireMockServer wiremock = this.resolve(extensionContext).get(name);
        if (wiremock == null) {
            throw new IllegalStateException("WireMockServer with name '" + name + "' not registered. Perhaps you forgot to configure it first with @ConfigureWireMock?");
        }
        return wiremock;
    }

    void store(ApplicationContext applicationContext, String name, WireMockServer wireMockServer) {
        this.resolve(applicationContext).put(name, wireMockServer);
    }

    Collection<WireMockServer> findAllInstances(ExtensionContext extensionContext) {
        return this.resolve(extensionContext).values();
    }

    private Map<String, WireMockServer> resolve(ExtensionContext extensionContext) {
        return this.resolve(SpringExtension.getApplicationContext((ExtensionContext)extensionContext));
    }

    private Map<String, WireMockServer> resolve(ApplicationContext applicationContext) {
        LOGGER.info("Resolving store from context: {}", (Object)applicationContext.getId());
        return this.store.computeIfAbsent(applicationContext, ctx -> new ConcurrentHashMap());
    }

    static {
        LOGGER = LoggerFactory.getLogger(Store.class);
    }
}

