/*
 * Decompiled with CFR 0.152.
 */
package com.maciejwalkowiak.wiremock.spring;

import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.common.Notifier;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.maciejwalkowiak.wiremock.spring.ConfigureWireMock;
import com.maciejwalkowiak.wiremock.spring.Store;
import com.maciejwalkowiak.wiremock.spring.WireMockConfigurationCustomizer;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.junit.platform.commons.util.ReflectionUtils;
import org.junit.platform.commons.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.test.util.TestPropertyValues;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.test.context.ContextCustomizer;
import org.springframework.test.context.MergedContextConfiguration;

public class WireMockContextCustomizer
implements ContextCustomizer {
    private static final Logger LOGGER = LoggerFactory.getLogger(WireMockContextCustomizer.class);
    private final List<ConfigureWireMock> configuration;

    public WireMockContextCustomizer(List<ConfigureWireMock> configurations) {
        this.configuration = configurations;
    }

    public WireMockContextCustomizer(ConfigureWireMock[] configurations) {
        this(Arrays.asList(configurations));
    }

    public void customizeContext(ConfigurableApplicationContext context, MergedContextConfiguration mergedConfig) {
        for (ConfigureWireMock configureWiremock : this.configuration) {
            this.resolveOrCreateWireMockServer(context, configureWiremock);
        }
    }

    private void resolveOrCreateWireMockServer(ConfigurableApplicationContext context, ConfigureWireMock options) {
        WireMockServer wireMockServer = Store.INSTANCE.findWireMockInstance((ApplicationContext)context, options.name());
        if (wireMockServer == null) {
            WireMockConfiguration serverOptions = WireMockConfiguration.options().usingFilesUnderClasspath(this.resolveStubLocation(options)).port(options.port()).notifier((Notifier)new Slf4jNotifier(true));
            if (options.extensions().length > 0) {
                serverOptions.extensions((Class[])options.extensions());
            }
            WireMockContextCustomizer.applyCustomizers(options, serverOptions);
            LOGGER.info("Configuring WireMockServer with name '{}' on port: {}", (Object)options.name(), (Object)serverOptions.portNumber());
            WireMockServer newServer = new WireMockServer((Options)serverOptions);
            newServer.start();
            LOGGER.info("Started WireMockServer with name '{}':{}", (Object)options.name(), (Object)newServer.baseUrl());
            Store.INSTANCE.store((ApplicationContext)context, options.name(), newServer);
            context.addApplicationListener(event -> {
                if (event instanceof ContextClosedEvent) {
                    LOGGER.info("Stopping WireMockServer with name '{}'", (Object)options.name());
                    newServer.stop();
                }
            });
            List<String> propertyNames = StringUtils.isNotBlank((String)options.property()) ? List.of(options.property()) : Arrays.stream(options.properties()).filter(StringUtils::isNotBlank).collect(Collectors.toList());
            propertyNames.forEach(propertyName -> {
                String property = propertyName + "=" + newServer.baseUrl();
                LOGGER.debug("Adding property '{}' to Spring application context", (Object)property);
                TestPropertyValues.of((String[])new String[]{property}).applyTo(context.getEnvironment());
            });
        } else {
            LOGGER.info("WireMockServer with name '{}' is already configured", (Object)options.name());
        }
    }

    private static void applyCustomizers(ConfigureWireMock options, WireMockConfiguration serverOptions) {
        for (Class<? extends WireMockConfigurationCustomizer> customizer : options.configurationCustomizers()) {
            try {
                ((WireMockConfigurationCustomizer)ReflectionUtils.newInstance(customizer, (Object[])new Object[0])).customize(serverOptions, options);
            }
            catch (Exception e) {
                if (e instanceof NoSuchMethodException) {
                    LOGGER.error("Customizer {} must have a no-arg constructor", customizer, (Object)e);
                }
                throw e;
            }
        }
    }

    private String resolveStubLocation(ConfigureWireMock options) {
        return StringUtils.isBlank((String)options.stubLocation()) ? "wiremock/" + options.name() : options.stubLocation();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WireMockContextCustomizer that = (WireMockContextCustomizer)o;
        return Objects.equals(this.configuration, that.configuration);
    }

    public int hashCode() {
        return Objects.hash(this.configuration);
    }

    static class Slf4jNotifier
    implements Notifier {
        private static final Logger log = LoggerFactory.getLogger((String)"WireMock");
        private final boolean verbose;

        Slf4jNotifier(boolean verbose) {
            this.verbose = verbose;
        }

        public void info(String message) {
            if (this.verbose) {
                log.info(message);
            }
        }

        public void error(String message) {
            log.error(message);
        }

        public void error(String message, Throwable t) {
            log.error(message, t);
        }
    }
}

