/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.mail.queue;

import com.manydesigns.mail.queue.MailQueue;
import com.manydesigns.mail.queue.QueueException;
import com.manydesigns.mail.queue.model.Email;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class LockingMailQueue
implements MailQueue {
    public static final String copyright = "Copyright (C) 2005-2019 ManyDesigns srl";
    protected final MailQueue mailQueue;
    protected final ReadWriteLock lock = new ReentrantReadWriteLock(true);

    public LockingMailQueue(MailQueue mailQueue) {
        this.mailQueue = mailQueue;
    }

    @Override
    public String enqueue(Email email) throws QueueException {
        this.lock.writeLock().lock();
        try {
            String string = this.mailQueue.enqueue(email);
            return string;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public List<String> getEnqueuedEmailIds() throws QueueException {
        this.lock.readLock().lock();
        try {
            List<String> list = this.mailQueue.getEnqueuedEmailIds();
            return list;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public Email loadEmail(String id) throws QueueException {
        this.lock.readLock().lock();
        try {
            Email email = this.mailQueue.loadEmail(id);
            return email;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public void markSent(String id) throws QueueException {
        this.lock.writeLock().lock();
        try {
            this.mailQueue.markSent(id);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void markFailed(String id) throws QueueException {
        this.lock.writeLock().lock();
        try {
            this.mailQueue.markFailed(id);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void setKeepSent(boolean keepSent) {
        this.mailQueue.setKeepSent(keepSent);
    }

    @Override
    public boolean isKeepSent() {
        return this.mailQueue.isKeepSent();
    }
}

