/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.mail.sender;

import com.manydesigns.mail.sender.MailSender;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailSenderRunnable
implements Runnable {
    public static final String copyright = "Copyright (C) 2005-2019 ManyDesigns srl";
    protected final MailSender sender;
    protected boolean alive;
    protected int pollInterval = 1000;
    public static final Logger logger = LoggerFactory.getLogger(MailSenderRunnable.class);

    public MailSenderRunnable(MailSender sender) {
        this.sender = sender;
    }

    @Override
    public void run() {
        this.alive = true;
        try {
            this.mainLoop();
        }
        catch (InterruptedException e) {
            this.stop();
        }
    }

    protected void mainLoop() throws InterruptedException {
        HashSet<String> idsToMarkAsSent = new HashSet<String>();
        int pollIntervalMultiplier = 1;
        while (this.alive) {
            long sleep;
            long now = System.currentTimeMillis();
            int serverErrors = this.sender.runOnce(idsToMarkAsSent);
            if (serverErrors < 0) continue;
            if (serverErrors > 0) {
                if (pollIntervalMultiplier < 10) {
                    logger.debug("{} server errors, increased poll interval multiplier to {}", (Object)serverErrors, (Object)(++pollIntervalMultiplier));
                }
            } else {
                pollIntervalMultiplier = 1;
                logger.debug("No server errors, poll interval multiplier reset");
            }
            if ((sleep = (long)(this.pollInterval * pollIntervalMultiplier) - (System.currentTimeMillis() - now)) <= 0L) continue;
            logger.debug("Sleeping for {}ms", (Object)sleep);
            Thread.sleep(sleep);
        }
    }

    public void stop() {
        this.alive = false;
    }

    public int getPollInterval() {
        return this.pollInterval;
    }

    public void setPollInterval(int pollInterval) {
        this.pollInterval = pollInterval;
    }

    public boolean isAlive() {
        return this.alive;
    }
}

