/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.i18n;

import com.manydesigns.portofino.i18n.ConfigurationResourceBundle;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.configuration.reloading.FileChangedReloadingStrategy;
import org.apache.commons.configuration.reloading.ReloadingStrategy;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceBundleManager {
    public static final String copyright = "Copyright (C) 2005-2019 ManyDesigns srl";
    protected LinkedList<String> searchPaths = new LinkedList();
    protected final ConcurrentMap<Locale, ConfigurationResourceBundle> resourceBundles = new ConcurrentHashMap<Locale, ConfigurationResourceBundle>();
    public static final Logger logger = LoggerFactory.getLogger(ResourceBundleManager.class);

    protected String getBundleFileName(String baseName, Locale locale) {
        return this.getBundleName(baseName, locale) + ".properties";
    }

    protected String getBundleName(String baseName, Locale locale) {
        String language = locale.getLanguage();
        String country = locale.getCountry();
        String variant = locale.getVariant();
        if (StringUtils.isBlank((String)language) && StringUtils.isBlank((String)country) && StringUtils.isBlank((String)variant)) {
            return baseName;
        }
        String name = baseName + "_";
        name = !StringUtils.isBlank((String)variant) ? name + language + "_" + country + "_" + variant : (!StringUtils.isBlank((String)country) ? name + language + "_" + country : name + language);
        return name;
    }

    public ResourceBundle getBundle(Locale locale) {
        ConfigurationResourceBundle bundle = (ConfigurationResourceBundle)this.resourceBundles.get(locale);
        if (bundle == null) {
            CompositeConfiguration configuration = new CompositeConfiguration();
            Iterator<String> iterator = this.searchPaths.descendingIterator();
            while (iterator.hasNext()) {
                PropertiesConfiguration conf;
                String path = iterator.next();
                int index = path.lastIndexOf(47) + 1;
                String basePath = path.substring(0, index);
                int suffixIndex = path.length() - ".properties".length();
                String resourceBundleBaseName = path.substring(index, suffixIndex);
                String bundleName = this.getBundleFileName(resourceBundleBaseName, locale);
                try {
                    conf = new PropertiesConfiguration();
                    conf.setFileName(basePath + bundleName);
                    conf.setDelimiterParsingDisabled(true);
                    conf.load();
                }
                catch (ConfigurationException e) {
                    logger.debug("Couldn't load resource bundle for locale " + locale + " from " + basePath, (Throwable)e);
                    try {
                        String defaultBundleName = basePath + resourceBundleBaseName + ".properties";
                        conf = new PropertiesConfiguration();
                        conf.setFileName(defaultBundleName);
                        conf.setDelimiterParsingDisabled(true);
                        conf.load();
                    }
                    catch (ConfigurationException e1) {
                        logger.debug("Couldn't load default resource bundle from " + basePath, (Throwable)e1);
                        conf = null;
                    }
                }
                if (conf == null) continue;
                FileChangedReloadingStrategy reloadingStrategy = new FileChangedReloadingStrategy();
                conf.setReloadingStrategy((ReloadingStrategy)reloadingStrategy);
                configuration.addConfiguration((Configuration)conf);
            }
            bundle = new ConfigurationResourceBundle((Configuration)configuration, locale);
            this.resourceBundles.put(locale, bundle);
        }
        return bundle;
    }

    public void addSearchPath(String searchPath) {
        if (this.searchPaths.contains(searchPath)) {
            logger.debug("Not adding search path: {}", (Object)searchPath);
            return;
        }
        logger.info("Adding search path: {}", (Object)searchPath);
        LinkedList<String> newSearchPaths = new LinkedList<String>(this.searchPaths);
        newSearchPaths.add(searchPath);
        this.searchPaths = newSearchPaths;
        this.resourceBundles.clear();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString() + " search paths: \n");
        for (String s : this.searchPaths) {
            sb.append(s + "\n");
        }
        return sb.toString();
    }
}

