/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.modules;

import com.manydesigns.mail.quartz.MailScheduler;
import com.manydesigns.mail.queue.MailQueue;
import com.manydesigns.mail.sender.MailSender;
import com.manydesigns.mail.setup.MailQueueSetup;
import com.manydesigns.portofino.PortofinoProperties;
import com.manydesigns.portofino.modules.Module;
import com.manydesigns.portofino.modules.ModuleStatus;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.servlet.ServletContext;
import org.apache.commons.configuration.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;

public class MailModule
implements Module {
    public static final String copyright = "Copyright (C) 2005-2019 ManyDesigns srl";
    @Autowired
    public ServletContext servletContext;
    @Autowired
    public Configuration configuration;
    protected MailQueueSetup mailQueueSetup;
    protected ModuleStatus status = ModuleStatus.CREATED;
    public static final Logger logger = LoggerFactory.getLogger(MailModule.class);

    @Override
    public String getModuleVersion() {
        return PortofinoProperties.getPortofinoVersion();
    }

    @Override
    public String getName() {
        return "Mail";
    }

    @PostConstruct
    public void init() {
        this.mailQueueSetup = new MailQueueSetup(this.configuration);
        this.mailQueueSetup.setup();
        try {
            MailScheduler.setupMailScheduler(this.mailQueueSetup);
        }
        catch (NoClassDefFoundError e) {
            logger.debug(e.getMessage(), (Throwable)e);
            logger.info("Quartz is not available, mail scheduler not started");
        }
        this.status = ModuleStatus.STARTED;
    }

    @PreDestroy
    public void destroy() {
        this.status = ModuleStatus.DESTROYED;
    }

    @Bean
    public MailQueue getMailQueue() {
        return this.mailQueueSetup.getMailQueue();
    }

    @Bean
    public MailSender getMailSender() {
        return this.mailQueueSetup.getMailSender();
    }

    @Override
    public ModuleStatus getStatus() {
        return this.status;
    }
}

