/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.modules;

import com.manydesigns.elements.util.ElementsFileUtils;
import com.manydesigns.portofino.PortofinoProperties;
import com.manydesigns.portofino.actions.ActionLogic;
import com.manydesigns.portofino.cache.CacheResetEvent;
import com.manydesigns.portofino.cache.CacheResetListener;
import com.manydesigns.portofino.cache.CacheResetListenerRegistry;
import com.manydesigns.portofino.code.CodeBase;
import com.manydesigns.portofino.modules.Module;
import com.manydesigns.portofino.modules.ModuleStatus;
import com.manydesigns.portofino.resourceactions.custom.CustomAction;
import com.manydesigns.portofino.resourceactions.form.FormAction;
import com.manydesigns.portofino.resourceactions.form.TableFormAction;
import com.manydesigns.portofino.resourceactions.registry.ActionRegistry;
import com.manydesigns.portofino.shiro.SecurityClassRealm;
import com.manydesigns.portofino.shiro.SelfRegisteringShiroFilter;
import io.jsonwebtoken.io.Encoders;
import java.io.File;
import java.util.UUID;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.servlet.ServletContext;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.apache.shiro.mgt.RealmSecurityManager;
import org.apache.shiro.realm.Realm;
import org.apache.shiro.realm.SimpleAccountRealm;
import org.apache.shiro.util.Initializable;
import org.apache.shiro.util.LifecycleUtils;
import org.apache.shiro.web.env.EnvironmentLoader;
import org.apache.shiro.web.env.WebEnvironment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;

public class ResourceActionsModule
implements Module,
ApplicationContextAware {
    public static final String copyright = "Copyright (C) 2005-2019 ManyDesigns srl";
    @Autowired
    public ServletContext servletContext;
    @Autowired
    public Configuration configuration;
    @Autowired
    @Qualifier(value="applicationDirectory")
    public File applicationDirectory;
    @Autowired
    public CodeBase codeBase;
    @Autowired
    public CacheResetListenerRegistry cacheResetListenerRegistry;
    protected EnvironmentLoader environmentLoader = new EnvironmentLoader();
    protected ApplicationContext applicationContext;
    protected ModuleStatus status = ModuleStatus.CREATED;
    public static final Logger logger = LoggerFactory.getLogger(ResourceActionsModule.class);

    @Override
    public String getModuleVersion() {
        return PortofinoProperties.getPortofinoVersion();
    }

    @Override
    public String getName() {
        return "ResourceActions";
    }

    @PostConstruct
    public void init() {
        logger.debug("Initializing dispatcher");
        ActionLogic.init(this.configuration);
        File actionsDirectory = new File(this.applicationDirectory, "actions");
        logger.info("Pages directory: " + actionsDirectory);
        ElementsFileUtils.ensureDirectoryExistsAndWarnIfNotWritable((File)actionsDirectory);
        if (this.configuration.getBoolean("groovy.preloadPages", false)) {
            logger.info("Preloading pages");
            this.preloadResourceActions(actionsDirectory);
        }
        if (this.configuration.getBoolean("groovy.preloadClasses", false)) {
            logger.info("Preloading Groovy classes");
            this.preloadClasses(this.codeBase.getRoot());
        }
        this.cacheResetListenerRegistry.getCacheResetListeners().add(new ConfigurationCacheResetListener());
        if (!this.configuration.containsKey("jwt.secret")) {
            String jwtSecret = (String)Encoders.BASE64.encode((Object)(UUID.randomUUID() + UUID.randomUUID().toString()).getBytes());
            logger.warn("No jwt.secret property was set, so we generated one: {}. It will only be valid until the application stops.", (Object)jwtSecret);
            this.configuration.setProperty("jwt.secret", (Object)jwtSecret);
        }
        logger.info("Initializing Shiro environment");
        WebEnvironment environment = this.environmentLoader.initEnvironment(this.servletContext);
        RealmSecurityManager rsm = (RealmSecurityManager)environment.getWebSecurityManager();
        SelfRegisteringShiroFilter shiroFilter = SelfRegisteringShiroFilter.get(this.servletContext);
        if (shiroFilter != null) {
            try {
                shiroFilter.init();
            }
            catch (Exception e) {
                logger.error("Could not initialize the Shiro filter", (Throwable)e);
                this.status = ModuleStatus.FAILED;
                return;
            }
        }
        logger.debug("Creating SecurityClassRealm");
        try {
            SecurityClassRealm realm = new SecurityClassRealm(this.codeBase, "Security", this.applicationContext);
            LifecycleUtils.init((Object)realm);
            rsm.setRealm((Realm)realm);
            this.status = ModuleStatus.STARTED;
        }
        catch (Exception e) {
            logger.error("Security class not found or invalid; installing dummy realm", (Throwable)e);
            SimpleAccountRealm realm = new SimpleAccountRealm();
            LifecycleUtils.init((Initializable)realm);
            rsm.setRealm((Realm)realm);
            this.status = ModuleStatus.FAILED;
        }
    }

    @Bean
    public ActionRegistry getResourceActionRegistry() {
        logger.debug("Creating pageactions registry");
        ActionRegistry actionRegistry = new ActionRegistry();
        actionRegistry.register(CustomAction.class);
        actionRegistry.register(FormAction.class);
        actionRegistry.register(TableFormAction.class);
        return actionRegistry;
    }

    protected void preloadResourceActions(File directory) {
    }

    protected void preloadClasses(FileObject directory) {
        try {
            for (FileObject file : directory.getChildren()) {
                logger.debug("visit {}", (Object)file);
                if (file.getType() == FileType.FOLDER) {
                    if (file.equals(directory) || file.equals(directory.getParent())) continue;
                    this.preloadClasses(file);
                    continue;
                }
                String extension = file.getName().getExtension();
                String className = file.getName().getRelativeName(this.codeBase.getRoot().getName());
                if (!StringUtils.isEmpty((CharSequence)extension)) {
                    className = className.substring(0, className.length() - extension.length() - 1);
                }
                logger.debug("Preloading " + className);
                try {
                    this.codeBase.loadClass(className);
                }
                catch (Throwable t) {
                    logger.warn("Class preload failed for " + className, t);
                }
            }
        }
        catch (FileSystemException e) {
            logger.warn("Could not preload classes under " + directory, (Throwable)e);
        }
    }

    @PreDestroy
    public void destroy() {
        logger.info("Destroying Shiro environment...");
        this.environmentLoader.destroyEnvironment(this.servletContext);
        this.status = ModuleStatus.DESTROYED;
    }

    @Override
    public ModuleStatus getStatus() {
        return this.status;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    private static class ConfigurationCacheResetListener
    implements CacheResetListener {
        private ConfigurationCacheResetListener() {
        }

        @Override
        public void handleReset(CacheResetEvent e) {
            ActionLogic.clearConfigurationCache();
        }
    }
}

