/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.resourceactions;

import com.manydesigns.portofino.resourceactions.ResourceAction;
import com.manydesigns.portofino.resourceactions.ResourceActionName;
import com.manydesigns.portofino.resourceactions.annotations.ConfigurationClass;
import com.manydesigns.portofino.resourceactions.annotations.ScriptTemplate;
import com.manydesigns.portofino.resourceactions.annotations.SupportsDetail;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceActionLogic {
    public static final String copyright = "Copyright (C) 2005-2019 ManyDesigns srl";
    public static final Logger logger = LoggerFactory.getLogger(ResourceActionLogic.class);

    public static boolean supportsDetail(Class<?> actionClass) {
        if (!ResourceAction.class.isAssignableFrom(actionClass)) {
            return false;
        }
        SupportsDetail supportsDetail = actionClass.getAnnotation(SupportsDetail.class);
        if (supportsDetail != null) {
            return supportsDetail.value();
        }
        return ResourceActionLogic.supportsDetail(actionClass.getSuperclass());
    }

    public static Class<?> getConfigurationClass(Class<?> actionClass) {
        if (!ResourceAction.class.isAssignableFrom(actionClass)) {
            return null;
        }
        ConfigurationClass configurationClass = actionClass.getAnnotation(ConfigurationClass.class);
        if (configurationClass != null) {
            return configurationClass.value();
        }
        return ResourceActionLogic.getConfigurationClass(actionClass.getSuperclass());
    }

    public static String getScriptTemplate(Class<?> actionClass) {
        if (!ResourceAction.class.isAssignableFrom(actionClass)) {
            return null;
        }
        ScriptTemplate scriptTemplate = actionClass.getAnnotation(ScriptTemplate.class);
        if (scriptTemplate != null) {
            String templateLocation = scriptTemplate.value();
            try {
                return IOUtils.toString((InputStream)actionClass.getResourceAsStream(templateLocation), (Charset)Charset.forName("UTF-8"));
            }
            catch (Exception e) {
                logger.error("Can't load script template: " + templateLocation + " for class: " + actionClass.getName(), (Throwable)e);
            }
        } else {
            String template = ResourceActionLogic.getScriptTemplate(actionClass.getSuperclass());
            if (template != null) {
                return template;
            }
        }
        logger.debug("Falling back to default template for {}", actionClass);
        try {
            InputStream stream = ResourceActionLogic.class.getResourceAsStream("/com/manydesigns/portofino/resourceactions/default_script_template.txt");
            return IOUtils.toString((InputStream)stream, (Charset)Charset.forName("UTF-8"));
        }
        catch (Exception e) {
            throw new Error("Can't load script template", e);
        }
    }

    public static String getDescriptionKey(Class<?> actionClass) {
        ResourceActionName annotation = actionClass.getAnnotation(ResourceActionName.class);
        if (annotation != null) {
            return annotation.value();
        }
        return actionClass.getName();
    }
}

