/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.resourceactions.form;

import com.manydesigns.elements.Mode;
import com.manydesigns.elements.forms.TableForm;
import com.manydesigns.elements.forms.TableFormBuilder;
import com.manydesigns.elements.reflection.ClassAccessor;
import com.manydesigns.portofino.resourceactions.AbstractResourceAction;
import com.manydesigns.portofino.resourceactions.ResourceActionName;
import com.manydesigns.portofino.resourceactions.annotations.ScriptTemplate;
import com.manydesigns.portofino.security.AccessLevel;
import com.manydesigns.portofino.security.RequiresPermissions;
import com.manydesigns.portofino.security.SupportsPermissions;
import java.util.List;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequiresPermissions(level=AccessLevel.VIEW)
@ResourceActionName(value="TableForm")
@ScriptTemplate(value="table_form_template.groovy")
@SupportsPermissions(value={"post-form"})
public abstract class TableFormAction
extends AbstractResourceAction {
    public static final String copyright = "Copyright (C) 2005-2019 ManyDesigns srl";
    public static final Logger logger = LoggerFactory.getLogger(TableFormAction.class);
    public static final String POST_FORM_PERMISSION = "post-form";
    protected TableForm form;

    public Response preparePage() {
        if (!this.actionInstance.getParameters().isEmpty()) {
            return Response.status((int)404).build();
        }
        return null;
    }

    protected void setupTableForm(Mode mode) {
        List<?> objects = this.getObjects();
        int nRows = objects == null ? 0 : objects.size();
        TableFormBuilder tableFormBuilder = this.createTableFormBuilder();
        this.configureTableFormBuilder(tableFormBuilder, mode, nRows);
        this.form = this.buildTableForm(tableFormBuilder);
    }

    protected TableFormBuilder createTableFormBuilder() {
        return new TableFormBuilder(this.getClassAccessor());
    }

    protected TableFormBuilder configureTableFormBuilder(TableFormBuilder formBuilder, Mode mode, int nRows) {
        return formBuilder.configMode(mode).configNRows(nRows);
    }

    protected TableForm buildTableForm(TableFormBuilder formBuilder) {
        return formBuilder.build();
    }

    protected abstract ClassAccessor getClassAccessor();

    protected abstract List<?> getObjects();

    protected Mode getMode() {
        return Mode.EDIT;
    }

    protected void validationFailed(TableForm form, Object object) {
        logger.debug("Form validation failed");
    }

    public TableForm getForm() {
        return this.form;
    }

    public static interface ActionOnForm {
        public Object invoke(TableForm var1, Object var2);
    }
}

