/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.resourceactions.registry;

import com.manydesigns.portofino.resourceactions.ResourceAction;
import com.manydesigns.portofino.resourceactions.ResourceActionLogic;
import com.manydesigns.portofino.resourceactions.registry.ActionInfo;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class ActionRegistry
implements Iterable<ActionInfo> {
    public static final String copyright = "Copyright (C) 2005-2019 ManyDesigns srl";
    protected final List<ActionInfo> registry = new CopyOnWriteArrayList<ActionInfo>();

    public ActionInfo register(Class<?> actionClass) {
        String descriptionKey = ResourceActionLogic.getDescriptionKey(actionClass);
        Class<?> configurationClass = ResourceActionLogic.getConfigurationClass(actionClass);
        String scriptTemplate = ResourceActionLogic.getScriptTemplate(actionClass);
        boolean supportsDetail = ResourceActionLogic.supportsDetail(actionClass);
        ActionInfo info = new ActionInfo(actionClass, configurationClass, scriptTemplate, supportsDetail, descriptionKey);
        this.registry.add(info);
        return info;
    }

    @Override
    public Iterator<ActionInfo> iterator() {
        return this.registry.iterator();
    }

    public ActionInfo getInfo(Class<? extends ResourceAction> actionClass) {
        for (ActionInfo info : this.registry) {
            if (info.actionClass != actionClass) continue;
            return info;
        }
        return null;
    }
}

