/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.rest;

import com.manydesigns.elements.ElementsThreadLocals;
import com.manydesigns.portofino.actions.ActionDescriptor;
import com.manydesigns.portofino.actions.ActionLogic;
import com.manydesigns.portofino.dispatcher.Resource;
import com.manydesigns.portofino.dispatcher.ResourceResolver;
import com.manydesigns.portofino.dispatcher.Root;
import com.manydesigns.portofino.i18n.TextProviderBean;
import com.manydesigns.portofino.resourceactions.AbstractResourceAction;
import com.manydesigns.portofino.resourceactions.ActionContext;
import com.manydesigns.portofino.resourceactions.ActionInstance;
import com.manydesigns.portofino.resourceactions.ResourceAction;
import com.manydesigns.portofino.security.AccessLevel;
import com.manydesigns.portofino.security.RequiresPermissions;
import com.manydesigns.portofino.shiro.SecurityUtilsBean;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import ognl.OgnlContext;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;

public class PortofinoRoot
extends AbstractResourceAction {
    @Context
    protected ServletContext servletContext;
    @Context
    protected HttpServletResponse response;
    protected ResourceResolver resourceResolver;
    protected static final ConcurrentMap<String, FileObject> children = new ConcurrentHashMap<String, FileObject>();

    protected PortofinoRoot(FileObject location, ResourceResolver resourceResolver) {
        this.setLocation(location);
        this.resourceResolver = resourceResolver;
    }

    public static PortofinoRoot get(FileObject location, ResourceResolver resourceResolver) throws Exception {
        Object root = Root.get((FileObject)location, (ResourceResolver)resourceResolver);
        if (!(root instanceof PortofinoRoot)) {
            if (!root.getClass().equals(Root.class)) {
                logger.warn(root + " defined in " + location + " does not extend PortofinoRoot, ignoring");
            }
            root = new PortofinoRoot(location, resourceResolver);
        }
        return (PortofinoRoot)root;
    }

    @Path(value="{pathSegment}")
    public Object consumePathSegment(@PathParam(value="pathSegment") String pathSegment) {
        logger.debug("Publishing securityUtils in OGNL context");
        OgnlContext ognlContext = ElementsThreadLocals.getOgnlContext();
        ognlContext.put((Object)"securityUtils", (Object)new SecurityUtilsBean());
        logger.debug("Publishing textProvider in OGNL context");
        ognlContext.put((Object)"textProvider", (Object)new TextProviderBean(ElementsThreadLocals.getTextProvider()));
        return super.consumePathSegment(pathSegment);
    }

    protected FileObject getChildLocation(String pathSegment) throws FileSystemException {
        FileObject child = (FileObject)children.get(pathSegment);
        if (child != null) {
            return child;
        }
        return super.getChildLocation(pathSegment);
    }

    public PortofinoRoot init() {
        super.init();
        ActionDescriptor rootActionDescriptor = ActionLogic.getActionDescriptor(this.location);
        ActionInstance actionInstance = new ActionInstance(null, this.location, rootActionDescriptor, this.getClass());
        this.setActionInstance(actionInstance);
        HttpServletRequest request = ElementsThreadLocals.getHttpServletRequest();
        ActionContext context = new ActionContext();
        context.setServletContext(this.servletContext);
        context.setRequest(request);
        context.setResponse(this.response);
        context.setActionPath("/");
        this.setContext(context);
        return this;
    }

    @Override
    public ResourceAction getParent() {
        return null;
    }

    public static void mount(FileObject fileObject) {
        FileObject previous = children.putIfAbsent(PortofinoRoot.getDefaultMountPointName(fileObject), fileObject);
        if (previous != null) {
            throw new RuntimeException("Already mounted: " + previous);
        }
    }

    public static void mount(FileObject fileObject, String name) {
        FileObject previous = children.putIfAbsent(name, fileObject);
        if (previous != null && !previous.equals(fileObject)) {
            throw new RuntimeException("Already mounted: " + previous);
        }
    }

    public static String getDefaultMountPointName(FileObject fileObject) {
        return fileObject.getName().getBaseName();
    }

    public static FileObject unmount(String child) {
        return (FileObject)children.remove(child);
    }

    public static boolean unmount(FileObject object) {
        return children.remove(PortofinoRoot.getDefaultMountPointName(object), object);
    }

    @Path(value=":description")
    @Produces(value={"application/json"})
    @GET
    @RequiresPermissions(level=AccessLevel.NONE)
    public Map<String, Object> getJSONDescription() {
        HashMap<String, Object> description = new HashMap<String, Object>();
        description.put("superclass", this.getClass().getSuperclass().getName());
        description.put("class", this.getClass().getName());
        description.put("page", this.actionInstance.getActionDescriptor());
        description.put("path", this.getPath());
        description.put("children", this.getSubResources());
        description.put("loginPath", this.portofinoConfiguration.getString("login.path"));
        return description;
    }

    public Collection<String> getSubResources() {
        HashSet<String> subresources = new HashSet<String>(super.getSubResources());
        subresources.addAll(children.keySet());
        return subresources;
    }

    public void setParent(Resource parent) {
        throw new UnsupportedOperationException("Cannot set the parent of the root");
    }

    public String getPath() {
        return "";
    }

    public ResourceResolver getResourceResolver() {
        return this.resourceResolver;
    }

    @GET
    @Produces(value={"application/json"})
    public Response openAPIJSON() throws URISyntaxException {
        return Response.temporaryRedirect((URI)new URI("openapi.json")).build();
    }

    @GET
    @Produces(value={"application/yaml"})
    public Response openAPIYAML() throws URISyntaxException {
        return Response.temporaryRedirect((URI)new URI("openapi.yaml")).build();
    }
}

