/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.shiro;

import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.StringUtils;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.codec.Base64;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.web.filter.PathMatchingFilter;
import org.apache.shiro.web.util.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpBasicAuthenticationFilter
extends PathMatchingFilter {
    public static final String copyright = "Copyright (C) 2005-2019 ManyDesigns srl";
    private static final Logger logger = LoggerFactory.getLogger(HttpBasicAuthenticationFilter.class);
    protected static final String AUTHORIZATION_HEADER = "Authorization";

    protected boolean onPreHandle(ServletRequest request, ServletResponse response, Object mappedValue) throws Exception {
        HttpServletRequest httpRequest;
        String authorizationHeader;
        Subject subject = SecurityUtils.getSubject();
        if (!subject.isAuthenticated() && !StringUtils.isEmpty((String)(authorizationHeader = (httpRequest = WebUtils.toHttp((ServletRequest)request)).getHeader(AUTHORIZATION_HEADER)))) {
            UsernamePasswordToken token;
            String username;
            String[] prinCred = this.getPrincipalsAndCredentials(authorizationHeader);
            String host = this.getHost(request);
            if (prinCred == null || prinCred.length < 2) {
                username = prinCred == null || prinCred.length == 0 ? "" : prinCred[0];
                token = new UsernamePasswordToken(username, "", false, host);
            } else {
                username = prinCred[0];
                String password = prinCred[1];
                token = new UsernamePasswordToken(username, password, false, host);
            }
            try {
                subject.login((AuthenticationToken)token);
            }
            catch (AuthenticationException e) {
                logger.warn("Failed HTTP basic authentication to " + httpRequest.getRequestURL(), (Throwable)e);
                HttpServletResponse httpResponse = WebUtils.toHttp((ServletResponse)response);
                httpResponse.setStatus(401);
                Configuration config = (Configuration)request.getServletContext().getAttribute("portofinoConfiguration");
                String authcHeader = "BASIC realm=\"" + config.getString("app.name") + "\"";
                httpResponse.setHeader("WWW-Authenticate", authcHeader);
                return false;
            }
        }
        return true;
    }

    protected String getHost(ServletRequest request) {
        return request.getRemoteHost();
    }

    protected String[] getPrincipalsAndCredentials(String authorizationHeader) {
        String[] authTokens = authorizationHeader.split(" ", 2);
        if (authTokens.length < 2) {
            return null;
        }
        String decoded = Base64.decodeToString((String)authTokens[1]);
        return decoded.split(":", 2);
    }
}

