/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.i18n;

import com.manydesigns.elements.i18n.TextProvider;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;

public class MultipleTextProvider
implements TextProvider {
    protected final List<ResourceBundle> resourceBundles;

    public MultipleTextProvider(ResourceBundle ... resourceBundles) {
        this.resourceBundles = new ArrayList<ResourceBundle>(Arrays.asList(resourceBundles));
    }

    public String getText(String key, Object ... args) {
        String localizedString = this.getLocalizedString(key);
        return MessageFormat.format(localizedString != null ? localizedString : key, args);
    }

    public String getTextOrNull(String key, Object ... args) {
        String localizedString = this.getLocalizedString(key);
        return localizedString != null ? MessageFormat.format(localizedString, args) : null;
    }

    public List<ResourceBundle> getResourceBundles() {
        return this.resourceBundles;
    }

    public String getLocalizedString(String key) {
        for (ResourceBundle current : this.resourceBundles) {
            try {
                return current.getString(key);
            }
            catch (Throwable throwable) {
            }
        }
        return null;
    }
}

