/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.resourceactions.form;

import com.manydesigns.elements.Mode;
import com.manydesigns.elements.forms.Form;
import com.manydesigns.elements.forms.FormBuilder;
import com.manydesigns.elements.reflection.ClassAccessor;
import com.manydesigns.elements.util.FormUtil;
import com.manydesigns.portofino.resourceactions.AbstractResourceAction;
import com.manydesigns.portofino.resourceactions.ResourceActionName;
import com.manydesigns.portofino.resourceactions.annotations.ScriptTemplate;
import com.manydesigns.portofino.security.AccessLevel;
import com.manydesigns.portofino.security.RequiresPermissions;
import com.manydesigns.portofino.security.SupportsPermissions;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequiresPermissions(level=AccessLevel.VIEW)
@ResourceActionName(value="Form")
@ScriptTemplate(value="form_template.groovy")
@SupportsPermissions(value={"post-form"})
public abstract class FormAction
extends AbstractResourceAction {
    public static final String copyright = "Copyright (C) 2005-2019 ManyDesigns srl";
    public static final Logger logger = LoggerFactory.getLogger(FormAction.class);
    public static final String POST_FORM_PERMISSION = "post-form";
    protected Form form;

    public Response preparePage() {
        if (!this.actionInstance.getParameters().isEmpty()) {
            return Response.status((int)404).build();
        }
        return null;
    }

    protected void setupForm(Mode mode) {
        FormBuilder formBuilder = this.createFormBuilder();
        this.configureFormBuilder(formBuilder, mode);
        this.form = this.buildForm(formBuilder);
    }

    protected FormBuilder createFormBuilder() {
        return new FormBuilder(this.getClassAccessor());
    }

    protected FormBuilder configureFormBuilder(FormBuilder formBuilder, Mode mode) {
        return formBuilder.configMode(mode);
    }

    protected Form buildForm(FormBuilder formBuilder) {
        return formBuilder.build();
    }

    protected abstract ClassAccessor getClassAccessor();

    protected abstract Object getObject();

    protected Mode getMode() {
        return Mode.EDIT;
    }

    protected void validationFailed(Form form, Object object) {
        logger.debug("Form validation failed");
    }

    public Form getForm() {
        return this.form;
    }

    public boolean isFormWithRichTextFields() {
        return !FormUtil.collectEditableRichTextFields((Form)this.form).isEmpty();
    }

    public static interface ActionOnForm {
        public Object invoke(Form var1, Object var2);
    }
}

