/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.resourceactions.login;

import com.manydesigns.mail.queue.MailQueue;
import com.manydesigns.mail.queue.QueueException;
import com.manydesigns.mail.queue.model.Email;
import com.manydesigns.mail.queue.model.Recipient;
import com.manydesigns.portofino.resourceactions.ResourceAction;
import com.manydesigns.portofino.resourceactions.ResourceActionName;
import com.manydesigns.portofino.resourceactions.annotations.ScriptTemplate;
import com.manydesigns.portofino.rest.actions.user.LoginAction;
import com.manydesigns.portofino.security.SecurityLogic;
import com.manydesigns.portofino.shiro.JSONWebToken;
import com.manydesigns.portofino.shiro.JWTFilter;
import com.manydesigns.portofino.shiro.PortofinoRealm;
import com.manydesigns.portofino.shiro.ShiroUtils;
import java.io.Serializable;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.session.Session;
import org.apache.shiro.subject.Subject;
import org.json.JSONStringer;
import org.springframework.beans.factory.annotation.Autowired;

@ScriptTemplate(value="script_template.groovy")
@ResourceActionName(value="Login")
public class DefaultLoginAction
extends LoginAction
implements ResourceAction {
    public static final String copyright = "Copyright (C) 2005-2019 ManyDesigns srl";
    @Autowired
    public MailQueue mailQueue;

    @Override
    @POST
    @Produces(value={"application/json"})
    public String login(@FormParam(value="username") String username, @FormParam(value="password") String password) throws AuthenticationException {
        Subject subject = SecurityUtils.getSubject();
        if (!subject.isAuthenticated()) {
            try {
                UsernamePasswordToken usernamePasswordToken = new UsernamePasswordToken(username, password);
                usernamePasswordToken.setRememberMe(false);
                subject.login((AuthenticationToken)usernamePasswordToken);
                logger.info("User {} login", (Object)ShiroUtils.getUserId(subject));
                Object principal = subject.getPrincipal();
                subject.logout();
                PortofinoRealm portofinoRealm = ShiroUtils.getPortofinoRealm();
                String jwt = portofinoRealm.generateWebToken(principal);
                subject.login((AuthenticationToken)new JSONWebToken(jwt));
                return this.userInfo(subject, portofinoRealm, jwt);
            }
            catch (AuthenticationException e) {
                logger.warn("Login failed for '" + username + "': " + e.getMessage(), (Throwable)e);
                throw new WebApplicationException(Response.Status.UNAUTHORIZED);
            }
        }
        return this.checkJWT();
    }

    @GET
    @Produces(value={"application/json"})
    @RequiresAuthentication
    public String checkJWT() {
        Subject subject = SecurityUtils.getSubject();
        PortofinoRealm portofinoRealm = ShiroUtils.getPortofinoRealm();
        String jwt = JWTFilter.getJSONWebToken(this.context.getRequest());
        if (jwt == null) {
            subject.logout();
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        return this.userInfo(subject, portofinoRealm, jwt);
    }

    public String userInfo(Subject subject, PortofinoRealm portofinoRealm, String jwt) {
        boolean administrator = SecurityLogic.isAdministrator(this.portofinoConfiguration);
        Session session = subject.getSession(true);
        JSONStringer stringer = new JSONStringer();
        stringer.object().key("portofinoSessionId").value((Object)session.getId()).key("userId").value((Object)ShiroUtils.getUserId(subject)).key("displayName").value((Object)portofinoRealm.getUserPrettyName((Serializable)subject.getPrincipal())).key("administrator").value(administrator).key("groups").value(portofinoRealm.getGroups(subject.getPrincipal())).key("jwt").value((Object)jwt).endObject();
        return stringer.toString();
    }

    @Override
    protected void sendForgotPasswordEmail(String from, String to, String subject, String body) {
        this.sendMail(from, to, subject, body);
    }

    @Override
    protected void sendSignupConfirmationEmail(String from, String to, String subject, String body) {
        this.sendMail(from, to, subject, body);
    }

    protected void sendMail(String from, String to, String subject, String body) {
        if (this.mailQueue == null) {
            throw new UnsupportedOperationException("Mail queue is not enabled");
        }
        Email email = new Email();
        email.getRecipients().add(new Recipient(Recipient.Type.TO, to));
        email.setFrom(from);
        email.setSubject(subject);
        email.setHtmlBody(body);
        try {
            this.mailQueue.enqueue(email);
        }
        catch (QueueException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getApplicationName() {
        return this.portofinoConfiguration.getString("app.name");
    }
}

