/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.rest;

import com.manydesigns.elements.ElementsThreadLocals;
import com.manydesigns.elements.messages.RequestMessages;
import com.manydesigns.portofino.cache.ControlsCache;
import com.manydesigns.portofino.operations.Guarded;
import com.manydesigns.portofino.operations.Operations;
import com.manydesigns.portofino.resourceactions.ResourceAction;
import com.manydesigns.portofino.security.SecurityLogic;
import com.manydesigns.portofino.shiro.SecurityUtilsBean;
import com.manydesigns.portofino.shiro.ShiroUtils;
import java.io.Serializable;
import java.lang.reflect.Method;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.ConstrainedTo;
import javax.ws.rs.RuntimeType;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.Provider;
import ognl.OgnlContext;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.aop.MethodInvocation;
import org.apache.shiro.authz.AuthorizationException;
import org.apache.shiro.authz.UnauthenticatedException;
import org.apache.shiro.authz.aop.AnnotationsAuthorizingMethodInterceptor;
import org.apache.shiro.subject.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

@Provider
@ConstrainedTo(value=RuntimeType.SERVER)
public class PortofinoFilter
implements ContainerRequestFilter,
ContainerResponseFilter {
    public static final String copyright = "Copyright (C) 2005-2019 ManyDesigns srl";
    public static final Logger logger = LoggerFactory.getLogger(PortofinoFilter.class);
    public static final Logger accessLogger = LoggerFactory.getLogger((String)"com.manydesigns.portofino.access");
    public static final String MESSAGE_HEADER = "X-Portofino-Message";
    @Context
    protected ResourceInfo resourceInfo;
    @Context
    protected HttpServletRequest request;
    @Context
    protected ServletContext servletContext;
    protected static final AuthChecker AUTH_CHECKER = new AuthChecker();

    public void filter(ContainerRequestContext requestContext) {
        UriInfo uriInfo = requestContext.getUriInfo();
        if (uriInfo.getMatchedResources().isEmpty()) {
            return;
        }
        Object resource = uriInfo.getMatchedResources().get(0);
        if (this.resourceInfo == null || this.resourceInfo.getResourceClass() == null) {
            return;
        }
        if (resource.getClass() != this.resourceInfo.getResourceClass()) {
            throw new RuntimeException("Inconsistency: matched resource is not of the right type, " + this.resourceInfo.getResourceClass());
        }
        this.fillMDC();
        logger.debug("Publishing securityUtils in OGNL context");
        OgnlContext ognlContext = ElementsThreadLocals.getOgnlContext();
        ognlContext.put((Object)"securityUtils", (Object)new SecurityUtilsBean());
        if (resource instanceof ResourceAction) {
            ResourceAction resourceAction = (ResourceAction)resource;
            resourceAction.prepareForExecution();
        }
        this.checkAuthorizations(requestContext, resource);
        accessLogger.info(requestContext.getMethod());
    }

    protected void addCacheHeaders(ContainerResponseContext responseContext) {
        if (this.resourceInfo.getResourceMethod() != null && this.resourceInfo.getResourceMethod().isAnnotationPresent(ControlsCache.class)) {
            return;
        }
        responseContext.getHeaders().putSingle((Object)"Pragma", (Object)"no-cache");
        responseContext.getHeaders().putSingle((Object)"Expires", (Object)0);
        responseContext.getHeaders().add((Object)"Cache-Control", (Object)"no-cache");
        responseContext.getHeaders().add((Object)"Cache-Control", (Object)"no-store");
    }

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) {
        this.addCacheHeaders(responseContext);
        for (String message : RequestMessages.consumeErrorMessages()) {
            responseContext.getHeaders().add((Object)MESSAGE_HEADER, (Object)("error: " + message));
        }
        for (String message : RequestMessages.consumeWarningMessages()) {
            responseContext.getHeaders().add((Object)MESSAGE_HEADER, (Object)("warning: " + message));
        }
        for (String message : RequestMessages.consumeInfoMessages()) {
            responseContext.getHeaders().add((Object)MESSAGE_HEADER, (Object)("info: " + message));
        }
    }

    protected void checkAuthorizations(ContainerRequestContext requestContext, Object resource) {
        try {
            Method handler = this.resourceInfo.getResourceMethod();
            AUTH_CHECKER.assertAuthorized(resource, handler);
            logger.debug("Standard Shiro security check passed.");
            if (resource instanceof ResourceAction) {
                this.checkResourceActionInvocation(requestContext, (ResourceAction)resource);
            }
        }
        catch (UnauthenticatedException e) {
            logger.debug("Method required authentication", (Throwable)e);
            requestContext.abortWith(Response.status((Response.Status)Response.Status.UNAUTHORIZED).build());
        }
        catch (AuthorizationException e) {
            logger.warn("Method invocation not authorized", (Throwable)e);
            requestContext.abortWith(Response.status((Response.Status)Response.Status.FORBIDDEN).build());
        }
    }

    protected void fillMDC() {
        HttpServletRequest request;
        logger.debug("Retrieving user");
        Serializable userId = null;
        Subject subject = SecurityUtils.getSubject();
        Object principal = subject.getPrincipal();
        if (principal == null) {
            logger.debug("No user found");
        } else {
            userId = ShiroUtils.getUserId(subject);
            logger.debug("Retrieved userId={}", (Object)userId);
        }
        logger.debug("Setting up logging MDC");
        MDC.clear();
        if (userId != null) {
            MDC.put((String)"userId", (String)userId.toString());
        }
        if ((request = ElementsThreadLocals.getHttpServletRequest()) != null) {
            MDC.put((String)"req.requestURI", (String)request.getRequestURI());
        }
    }

    protected void checkResourceActionInvocation(ContainerRequestContext requestContext, ResourceAction resourceAction) {
        Method handler = this.resourceInfo.getResourceMethod();
        HttpServletRequest request = ElementsThreadLocals.getHttpServletRequest();
        if (!SecurityLogic.isAllowed(request, resourceAction.getActionInstance(), resourceAction, handler)) {
            Response.Status status = SecurityUtils.getSubject().isAuthenticated() ? Response.Status.FORBIDDEN : Response.Status.UNAUTHORIZED;
            requestContext.abortWith(Response.status((Response.Status)status).build());
        } else if (!Operations.doGuardsPass(resourceAction, handler)) {
            if (resourceAction instanceof Guarded) {
                Response response = ((Guarded)((Object)resourceAction)).guardsFailed(handler);
                requestContext.abortWith(response);
            } else {
                requestContext.abortWith(Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)"The action couldn't be invoked, a guard did not pass").build());
            }
        } else {
            logger.debug("Portofino-specific security check passed");
        }
    }

    public static final class AuthChecker
    extends AnnotationsAuthorizingMethodInterceptor {
        public void assertAuthorized(final Object resource, final Method handler) throws AuthorizationException {
            super.assertAuthorized(new MethodInvocation(){

                public Object proceed() {
                    return null;
                }

                public Method getMethod() {
                    return handler;
                }

                public Object[] getArguments() {
                    return new Object[0];
                }

                public Object getThis() {
                    return resource;
                }
            });
        }
    }
}

