/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.rest.actions.user;

import com.github.cage.Cage;
import com.manydesigns.elements.ElementsThreadLocals;
import com.manydesigns.elements.Mode;
import com.manydesigns.elements.forms.Form;
import com.manydesigns.elements.forms.FormBuilder;
import com.manydesigns.portofino.resourceactions.AbstractResourceAction;
import com.manydesigns.portofino.rest.actions.user.CaptchaGenerator;
import com.manydesigns.portofino.shiro.PortofinoRealm;
import com.manydesigns.portofino.shiro.ShiroUtils;
import java.io.Serializable;
import java.util.List;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.StringUtils;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.session.Session;
import org.apache.shiro.subject.Subject;
import org.json.JSONStringer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LoginAction
extends AbstractResourceAction {
    public static final String copyright = "Copyright (C) 2005-2019 ManyDesigns srl";
    protected Form signUpForm;
    public String returnUrl;
    public String cancelReturnUrl;
    private static Cage cage;
    public static final String CAPTCHA_SESSION_ATTRIBUTE = "LoginAction.captcha";
    public boolean captchaValidationFailed;
    public static final Logger logger;

    @POST
    @Produces(value={"application/json"})
    public String login(@FormParam(value="username") String username, @FormParam(value="password") String password) throws AuthenticationException {
        Subject subject = SecurityUtils.getSubject();
        if (!subject.isAuthenticated()) {
            try {
                UsernamePasswordToken usernamePasswordToken = new UsernamePasswordToken(username, password);
                usernamePasswordToken.setRememberMe(false);
                subject.login((AuthenticationToken)usernamePasswordToken);
                logger.info("User {} login", (Object)ShiroUtils.getUserId(subject));
                Session session = subject.getSession(true);
                JSONStringer stringer = new JSONStringer();
                stringer.object().key("portofinoSessionId").value((Object)session.getId()).endObject();
                return stringer.toString();
            }
            catch (AuthenticationException e) {
                logger.warn("Login failed for '" + username + "': " + e.getMessage(), (Throwable)e);
            }
        }
        return "{}";
    }

    protected String getRememberedUserName(Serializable principal) {
        PortofinoRealm realm = ShiroUtils.getPortofinoRealm();
        return realm.getUserPrettyName(principal);
    }

    @Path(value="{sessionId}")
    @DELETE
    @Deprecated
    public void logout(@PathParam(value="sessionId") String sessionId) {
        this.logout();
    }

    @DELETE
    public void logout() {
        Subject subject = SecurityUtils.getSubject();
        subject.logout();
        logger.info("User logout");
    }

    protected abstract void sendForgotPasswordEmail(String var1, String var2, String var3, String var4);

    protected abstract void sendSignupConfirmationEmail(String var1, String var2, String var3, String var4);

    protected void setupSignUpForm(PortofinoRealm realm) {
        FormBuilder formBuilder = new FormBuilder(realm.getSelfRegisteredUserClassAccessor()).configMode(Mode.CREATE).configReflectiveFields();
        this.signUpForm = formBuilder.build();
    }

    protected boolean validateSignUpPassword(List<String> errorMessages) {
        return true;
    }

    protected boolean checkPasswordStrength(String password, List<String> errorMessages) {
        if (password == null) {
            errorMessages.add(ElementsThreadLocals.getText((String)"null.password", (Object[])new Object[0]));
            return false;
        }
        if (password.length() < 8) {
            errorMessages.add(ElementsThreadLocals.getText((String)"password.too.short", (Object[])new Object[]{8}));
            return false;
        }
        if (StringUtils.isAlpha((String)password)) {
            errorMessages.add(ElementsThreadLocals.getText((String)"password.only.letters", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public abstract String getApplicationName();

    public String getReturnUrl() {
        return this.returnUrl;
    }

    public void setReturnUrl(String returnUrl) {
        this.returnUrl = returnUrl;
    }

    public String getCancelReturnUrl() {
        return this.cancelReturnUrl;
    }

    public void setCancelReturnUrl(String cancelReturnUrl) {
        this.cancelReturnUrl = cancelReturnUrl;
    }

    @Override
    public Configuration getPortofinoConfiguration() {
        return this.portofinoConfiguration;
    }

    public Form getSignUpForm() {
        return this.signUpForm;
    }

    public boolean isCaptchaValidationFailed() {
        return this.captchaValidationFailed;
    }

    static {
        logger = LoggerFactory.getLogger(LoginAction.class);
        try {
            cage = new CaptchaGenerator();
        }
        catch (NoClassDefFoundError e) {
            cage = null;
            logger.warn("Captcha generator not available", (Throwable)e);
        }
    }
}

