/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.servlets;

import com.manydesigns.elements.ElementsProperties;
import com.manydesigns.elements.ElementsThreadLocals;
import com.manydesigns.elements.configuration.BeanLookup;
import com.manydesigns.elements.crypto.KeyManager;
import com.manydesigns.elements.servlet.AttributeMap;
import com.manydesigns.elements.util.ElementsFileUtils;
import com.manydesigns.portofino.PortofinoProperties;
import com.manydesigns.portofino.dispatcher.ResourceResolver;
import com.manydesigns.portofino.dispatcher.resolvers.ResourceResolvers;
import com.manydesigns.portofino.dispatcher.web.DispatcherInitializer;
import com.manydesigns.portofino.i18n.ResourceBundleManager;
import com.manydesigns.portofino.rest.PortofinoRoot;
import com.manydesigns.portofino.servlets.ServerInfo;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Enumeration;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextAttributeEvent;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.configuration.BaseConfiguration;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.configuration.PropertyConverter;
import org.apache.commons.configuration.interpol.ConfigurationInterpolator;
import org.apache.commons.lang.text.StrLookup;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.VFS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class PortofinoListener
extends DispatcherInitializer
implements ServletContextListener,
HttpSessionListener,
ServletContextAttributeListener {
    public static final String copyright = "Copyright (C) 2005-2019 ManyDesigns srl";
    public static final String SEPARATOR = "--------------------------------------------------------------------------------";
    public static final String PORTOFINO_MESSAGES_FILE_NAME = "portofino-messages.properties";
    protected Configuration elementsConfiguration;
    protected Configuration configuration;
    protected File applicationDirectory;
    protected ServletContext servletContext;
    protected ServerInfo serverInfo;
    public static final Logger logger = LoggerFactory.getLogger(PortofinoListener.class);

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        try {
            ElementsThreadLocals.setupDefaultElementsContext();
            ServletContext servletContext = servletContextEvent.getServletContext();
            ElementsThreadLocals.setServletContext((ServletContext)servletContext);
            AttributeMap servletContextAttributeMap = AttributeMap.createAttributeMap((ServletContext)servletContext);
            ElementsThreadLocals.getOgnlContext().put((Object)"servletContext", (Object)servletContextAttributeMap);
            this.init(servletContextEvent);
            super.contextInitialized(servletContextEvent);
        }
        catch (Throwable e) {
            logger.error("Could not start ManyDesigns Portofino", e);
            throw new Error(e);
        }
        finally {
            ElementsThreadLocals.removeElementsContext();
        }
    }

    private void init(ServletContextEvent servletContextEvent) {
        MDC.clear();
        this.servletContext = servletContextEvent.getServletContext();
        this.serverInfo = new ServerInfo(this.servletContext);
        this.servletContext.setAttribute("com.manydesigns.portofino.serverInfo", (Object)this.serverInfo);
        this.setupCommonsConfiguration();
        this.elementsConfiguration = ElementsProperties.getConfiguration();
        String applicationDirectoryPath = this.servletContext.getInitParameter("portofino.application.directory");
        if (applicationDirectoryPath != null) {
            try {
                applicationDirectoryPath = (String)PropertyConverter.interpolate((Object)applicationDirectoryPath, (AbstractConfiguration)new BaseConfiguration());
                this.applicationDirectory = new File(applicationDirectoryPath);
                if (!this.applicationDirectory.isDirectory()) {
                    logger.error("Configured application directory " + applicationDirectoryPath + " is not a directory");
                    this.applicationDirectory = null;
                }
            }
            catch (Exception e) {
                logger.error("Configured application directory " + applicationDirectoryPath + " is not valid", (Throwable)e);
            }
        }
        if (this.applicationDirectory == null) {
            this.applicationDirectory = new File(this.serverInfo.getRealPath(), "WEB-INF");
        }
        logger.info("Application directory: {}", (Object)this.applicationDirectory.getAbsolutePath());
        try {
            this.loadConfiguration();
        }
        catch (ConfigurationException e) {
            logger.error("Could not load configuration", (Throwable)e);
            throw new Error(e);
        }
        this.servletContext.setAttribute("com.manydesigns.portofino.application.directory", (Object)this.applicationDirectory);
        this.servletContext.setAttribute("portofinoConfiguration", (Object)this.configuration);
        try {
            logger.info("Initializing KeyManager ");
            KeyManager.init((Configuration)this.configuration);
        }
        catch (Exception e) {
            logger.error("Could not initialize KeyManager", (Throwable)e);
        }
        logger.debug("Installing I18n ResourceBundleManager");
        ResourceBundleManager resourceBundleManager = new ResourceBundleManager();
        try {
            Enumeration<URL> messagesSearchPaths = ((Object)((Object)this)).getClass().getClassLoader().getResources(PORTOFINO_MESSAGES_FILE_NAME);
            while (messagesSearchPaths.hasMoreElements()) {
                resourceBundleManager.addSearchPath(messagesSearchPaths.nextElement().toString());
            }
            File appMessages = new File(this.applicationDirectory, PORTOFINO_MESSAGES_FILE_NAME);
            resourceBundleManager.addSearchPath(appMessages.getAbsolutePath());
        }
        catch (IOException e) {
            logger.warn("Could not initialize resource bundle manager", (Throwable)e);
        }
        this.servletContext.setAttribute("com.manydesigns.portofino.resourceBundleManager", (Object)resourceBundleManager);
        logger.info("Servlet API version is " + this.serverInfo.getServletApiVersion());
        if (this.serverInfo.getServletApiMajor() < 3) {
            String msg = "Servlet API version should be >= 3.0.";
            logger.warn(msg);
        }
        String encoding = this.configuration.getString("url.encoding", "UTF-8");
        logger.info("URL character encoding is set to " + encoding + ". Make sure the web server uses the same encoding to parse URLs.");
        if (!Charset.isSupported(encoding)) {
            logger.error("The encoding is not supported by the JVM!");
        }
        String lineSeparator = System.getProperty("line.separator", "\n");
        logger.info(lineSeparator + SEPARATOR + lineSeparator + "--- ManyDesigns Portofino " + PortofinoProperties.getPortofinoVersion() + " started successfully" + lineSeparator + "--- Context path: {}" + lineSeparator + "--- Real path: {}" + lineSeparator + "--- Visit http://portofino.manydesigns.com for news, documentation, issue tracker, community forums, commercial support!" + lineSeparator + SEPARATOR, (Object[])new String[]{this.serverInfo.getContextPath(), this.serverInfo.getRealPath()});
    }

    protected String getApplicationDirectoryPath(ServletContext servletContext) {
        return this.applicationDirectory.getAbsolutePath();
    }

    protected FileObject getCodeBaseRoot() throws FileSystemException {
        File codeBaseRoot = new File(this.applicationDirectory, "classes");
        logger.info("Initializing codebase with classpath: " + codeBaseRoot.getAbsolutePath());
        ElementsFileUtils.ensureDirectoryExistsAndWarnIfNotWritable((File)codeBaseRoot);
        return VFS.getManager().resolveFile(codeBaseRoot.toString());
    }

    protected PortofinoRoot getRoot(FileObject actionsDirectory, ResourceResolvers resourceResolver) throws Exception {
        return PortofinoRoot.get(actionsDirectory, (ResourceResolver)resourceResolver);
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        MDC.clear();
    }

    public void sessionCreated(HttpSessionEvent httpSessionEvent) {
        HttpSession session = httpSessionEvent.getSession();
        logger.debug("Session created: id={}", (Object)session.getId());
    }

    public void sessionDestroyed(HttpSessionEvent httpSessionEvent) {
        HttpSession session = httpSessionEvent.getSession();
        logger.debug("Session destroyed: id={}", (Object)session.getId());
    }

    protected void loadConfiguration() throws ConfigurationException {
        File localConfigurationFile;
        File configurationFile = new File(this.applicationDirectory, "portofino.properties");
        this.configuration = new PropertiesConfiguration(configurationFile);
        String localConfigurationPath = null;
        try {
            localConfigurationPath = System.getProperty("portofino.configuration.file");
        }
        catch (SecurityException e) {
            logger.warn("Reading system properties is forbidden. Will read configuration file from standard location.", (Throwable)e);
        }
        if (localConfigurationPath != null) {
            localConfigurationFile = new File(localConfigurationPath);
            if (!localConfigurationFile.exists()) {
                logger.warn("Configuration file " + localConfigurationPath + " does not exist");
            }
        } else {
            localConfigurationFile = new File(this.applicationDirectory, "portofino-local.properties");
        }
        if (localConfigurationFile.exists()) {
            logger.info("Local configuration file: {}", (Object)localConfigurationFile);
            PropertiesConfiguration localConfiguration = new PropertiesConfiguration(localConfigurationFile);
            CompositeConfiguration compositeConfiguration = new CompositeConfiguration();
            compositeConfiguration.addConfiguration((Configuration)localConfiguration, true);
            compositeConfiguration.addConfiguration(this.configuration);
            this.configuration = compositeConfiguration;
        }
    }

    public void setupCommonsConfiguration() {
        logger.debug("Setting up commons-configuration lookups...");
        BeanLookup serverInfoLookup = new BeanLookup((Object)this.serverInfo);
        ConfigurationInterpolator.registerGlobalLookup((String)"serverInfo", (StrLookup)serverInfoLookup);
    }

    public void attributeAdded(ServletContextAttributeEvent servletContextAttributeEvent) {
        logger.debug("Servlet context attribute added: " + servletContextAttributeEvent.getName() + " = " + servletContextAttributeEvent.getValue());
    }

    public void attributeRemoved(ServletContextAttributeEvent servletContextAttributeEvent) {
        logger.debug("Servlet context attribute removed: " + servletContextAttributeEvent.getName() + " = " + servletContextAttributeEvent.getValue());
    }

    public void attributeReplaced(ServletContextAttributeEvent servletContextAttributeEvent) {
        logger.debug("Servlet context attribute replaced: " + servletContextAttributeEvent.getName() + " = " + servletContextAttributeEvent.getValue());
    }
}

