/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.shiro;

import com.manydesigns.elements.reflection.ClassAccessor;
import com.manydesigns.portofino.code.CodeBase;
import com.manydesigns.portofino.shiro.PortofinoRealm;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authz.AuthorizationException;
import org.apache.shiro.authz.Permission;
import org.apache.shiro.cache.CacheManager;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.util.Destroyable;
import org.apache.shiro.util.LifecycleUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class SecurityClassRealm
implements PortofinoRealm,
Destroyable {
    public static final String copyright = "Copyright (C) 2005-2019 ManyDesigns srl";
    public static final Logger logger = LoggerFactory.getLogger(SecurityClassRealm.class);
    protected final CodeBase codeBase;
    protected final String className;
    protected final ApplicationContext applicationContext;
    protected volatile PortofinoRealm security;
    protected volatile boolean destroyed = false;
    protected CacheManager cacheManager;

    public SecurityClassRealm(CodeBase codeBase, String className, ApplicationContext applicationContext) throws InstantiationException, IllegalAccessException, IOException, ClassNotFoundException {
        this.codeBase = codeBase;
        this.className = className;
        this.applicationContext = applicationContext;
        this.doEnsureDelegate();
    }

    private synchronized PortofinoRealm ensureDelegate() {
        if (this.destroyed) {
            throw new IllegalStateException("This realm has been destroyed.");
        }
        try {
            return this.doEnsureDelegate();
        }
        catch (Exception e) {
            throw new Error("Security.groovy not found or not loadable", e);
        }
    }

    private PortofinoRealm doEnsureDelegate() throws IllegalAccessException, InstantiationException, IOException, ClassNotFoundException {
        Object securityTemp;
        Class scriptClass = this.codeBase.loadClass(this.className);
        if (scriptClass.isInstance(this.security)) {
            return this.security;
        }
        logger.info("Refreshing Portofino Realm Delegate instance (Security.groovy)");
        if (this.security != null) {
            logger.debug("Script class changed: from " + this.security.getClass() + " to " + scriptClass);
        }
        if ((securityTemp = scriptClass.newInstance()) instanceof PortofinoRealm) {
            PortofinoRealm realm = (PortofinoRealm)securityTemp;
            this.configureDelegate(realm);
            PortofinoRealm oldSecurity = this.security;
            this.security = realm;
            LifecycleUtils.destroy((Object)oldSecurity);
            return realm;
        }
        throw new ClassCastException("Security object is not an instance of " + PortofinoRealm.class + ": " + securityTemp + " (" + securityTemp.getClass().getSuperclass() + " " + Arrays.asList(securityTemp.getClass().getInterfaces()) + ")");
    }

    protected void configureDelegate(PortofinoRealm security) {
        this.applicationContext.getAutowireCapableBeanFactory().autowireBean((Object)security);
        security.setCacheManager(this.cacheManager);
        LifecycleUtils.init((Object)security);
    }

    @Override
    public void verifyUser(Serializable user) {
        this.ensureDelegate().verifyUser(user);
    }

    @Override
    public void changePassword(Serializable user, String oldPassword, String newPassword) {
        this.ensureDelegate().changePassword(user, oldPassword, newPassword);
    }

    @Override
    public String generateOneTimeToken(Serializable user) {
        return this.ensureDelegate().generateOneTimeToken(user);
    }

    @Override
    public String encryptPassword(String password) {
        return this.ensureDelegate().encryptPassword(password);
    }

    @Override
    public Map<Serializable, String> getUsers() {
        return this.ensureDelegate().getUsers();
    }

    @Override
    public Serializable getUserById(String encodedUserId) {
        return this.ensureDelegate().getUserById(encodedUserId);
    }

    @Override
    public Serializable getUserByEmail(String email) {
        return this.ensureDelegate().getUserByEmail(email);
    }

    @Override
    public ClassAccessor getSelfRegisteredUserClassAccessor() {
        return this.ensureDelegate().getSelfRegisteredUserClassAccessor();
    }

    @Override
    public String saveSelfRegisteredUser(Object user) {
        return this.ensureDelegate().saveSelfRegisteredUser(user);
    }

    @Override
    public String getUserPrettyName(Serializable user) {
        return this.ensureDelegate().getUserPrettyName(user);
    }

    @Override
    public Serializable getUserId(Serializable user) {
        return this.ensureDelegate().getUserId(user);
    }

    @Override
    public Set<String> getGroups() {
        return this.ensureDelegate().getGroups();
    }

    @Override
    public Set<String> getGroups(Object principal) {
        return this.ensureDelegate().getGroups(principal);
    }

    @Override
    public String generateWebToken(Object principal) {
        return this.ensureDelegate().generateWebToken(principal);
    }

    public String getName() {
        return this.ensureDelegate().getName();
    }

    public boolean supports(AuthenticationToken token) {
        return this.ensureDelegate().supports(token);
    }

    public AuthenticationInfo getAuthenticationInfo(AuthenticationToken token) throws AuthenticationException {
        return this.ensureDelegate().getAuthenticationInfo(token);
    }

    public boolean isPermitted(PrincipalCollection principals, String permission) {
        return this.ensureDelegate().isPermitted(principals, permission);
    }

    public boolean isPermitted(PrincipalCollection subjectPrincipal, Permission permission) {
        return this.ensureDelegate().isPermitted(subjectPrincipal, permission);
    }

    public boolean[] isPermitted(PrincipalCollection subjectPrincipal, String ... permissions) {
        return this.ensureDelegate().isPermitted(subjectPrincipal, permissions);
    }

    public boolean[] isPermitted(PrincipalCollection subjectPrincipal, List<Permission> permissions) {
        return this.ensureDelegate().isPermitted(subjectPrincipal, permissions);
    }

    public boolean isPermittedAll(PrincipalCollection subjectPrincipal, String ... permissions) {
        return this.ensureDelegate().isPermittedAll(subjectPrincipal, permissions);
    }

    public boolean isPermittedAll(PrincipalCollection subjectPrincipal, Collection<Permission> permissions) {
        return this.ensureDelegate().isPermittedAll(subjectPrincipal, permissions);
    }

    public void checkPermission(PrincipalCollection subjectPrincipal, String permission) throws AuthorizationException {
        this.ensureDelegate().checkPermission(subjectPrincipal, permission);
    }

    public void checkPermission(PrincipalCollection subjectPrincipal, Permission permission) throws AuthorizationException {
        this.ensureDelegate().checkPermission(subjectPrincipal, permission);
    }

    public void checkPermissions(PrincipalCollection subjectPrincipal, String ... permissions) throws AuthorizationException {
        this.ensureDelegate().checkPermissions(subjectPrincipal, permissions);
    }

    public void checkPermissions(PrincipalCollection subjectPrincipal, Collection<Permission> permissions) throws AuthorizationException {
        this.ensureDelegate().checkPermissions(subjectPrincipal, permissions);
    }

    public boolean hasRole(PrincipalCollection subjectPrincipal, String roleIdentifier) {
        return this.ensureDelegate().hasRole(subjectPrincipal, roleIdentifier);
    }

    public boolean[] hasRoles(PrincipalCollection subjectPrincipal, List<String> roleIdentifiers) {
        return this.ensureDelegate().hasRoles(subjectPrincipal, roleIdentifiers);
    }

    public boolean hasAllRoles(PrincipalCollection subjectPrincipal, Collection<String> roleIdentifiers) {
        return this.ensureDelegate().hasAllRoles(subjectPrincipal, roleIdentifiers);
    }

    public void checkRole(PrincipalCollection subjectPrincipal, String roleIdentifier) throws AuthorizationException {
        this.ensureDelegate().checkRole(subjectPrincipal, roleIdentifier);
    }

    public void checkRoles(PrincipalCollection subjectPrincipal, Collection<String> roleIdentifiers) throws AuthorizationException {
        this.ensureDelegate().checkRoles(subjectPrincipal, roleIdentifiers);
    }

    public void checkRoles(PrincipalCollection subjectPrincipal, String ... roleIdentifiers) throws AuthorizationException {
        this.ensureDelegate().checkRoles(subjectPrincipal, roleIdentifiers);
    }

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
        if (this.security != null) {
            this.security.setCacheManager(cacheManager);
        }
    }

    public void destroy() {
        boolean wasDestroyed = this.destroyed;
        this.destroyed = true;
        if (!wasDestroyed) {
            logger.info("Destroying realm delegate");
            LifecycleUtils.destroy((Object)this.security);
        }
    }
}

